/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.archivers.zip.ZipIoUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ZipIoUtilTest
extends AbstractTempDirTest {
    private FileChannel mockFileChannel() throws IOException {
        FileChannel spy = (FileChannel)Mockito.spy(FileChannel.class);
        ((FileChannel)Mockito.doNothing().when((Object)spy)).close();
        return spy;
    }

    private SeekableByteChannel mockSeekableByteChannel() {
        return (SeekableByteChannel)Mockito.mock(SeekableByteChannel.class);
    }

    @Test
    public void testWriteFully_whenFullAtOnce_thenSucceed() throws IOException {
        try (SeekableByteChannel channel = this.mockSeekableByteChannel();){
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any())).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(5);
                return 5;
            }).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(6);
                return 6;
            });
            ZipIoUtil.writeFully((SeekableByteChannel)channel, (ByteBuffer)ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)));
            ZipIoUtil.writeFully((SeekableByteChannel)channel, (ByteBuffer)ByteBuffer.wrap("world\n".getBytes(StandardCharsets.UTF_8)));
            ((SeekableByteChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)2))).write((ByteBuffer)ArgumentMatchers.any());
        }
    }

    @Test
    public void testWriteFully_whenFullButPartial_thenSucceed() throws IOException {
        try (SeekableByteChannel channel = this.mockSeekableByteChannel();){
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any())).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(3);
                return 3;
            }).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(5);
                return 2;
            }).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(6);
                return 6;
            });
            ZipIoUtil.writeFully((SeekableByteChannel)channel, (ByteBuffer)ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)));
            ZipIoUtil.writeFully((SeekableByteChannel)channel, (ByteBuffer)ByteBuffer.wrap("world\n".getBytes(StandardCharsets.UTF_8)));
            ((SeekableByteChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)3))).write((ByteBuffer)ArgumentMatchers.any());
        }
    }

    @Test
    public void testWriteFully_whenPartial_thenFail() throws IOException {
        try (SeekableByteChannel channel = this.mockSeekableByteChannel();){
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any())).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(3);
                return 3;
            }).thenAnswer(answer -> 0);
            Assertions.assertThrows(IOException.class, () -> ZipIoUtil.writeFully((SeekableByteChannel)channel, (ByteBuffer)ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8))));
            ((SeekableByteChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)2))).write((ByteBuffer)ArgumentMatchers.any());
        }
    }

    @Test
    public void testWriteFullyAt_whenFullAtOnce_thenSucceed() throws IOException {
        try (FileChannel channel = this.mockFileChannel();){
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L))).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(5);
                return 5;
            });
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)30L))).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(6);
                return 6;
            });
            ZipIoUtil.writeFullyAt((FileChannel)channel, (ByteBuffer)ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)), (long)20L);
            ZipIoUtil.writeFullyAt((FileChannel)channel, (ByteBuffer)ByteBuffer.wrap("world\n".getBytes(StandardCharsets.UTF_8)), (long)30L);
            ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L));
            ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)30L));
        }
    }

    @Test
    public void testWriteFullyAt_whenFullButPartial_thenSucceed() throws IOException {
        try (FileChannel channel = this.mockFileChannel();){
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L))).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(3);
                return 3;
            });
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)23L))).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(5);
                return 2;
            });
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)30L))).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(6);
                return 6;
            });
            ZipIoUtil.writeFullyAt((FileChannel)channel, (ByteBuffer)ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)), (long)20L);
            ZipIoUtil.writeFullyAt((FileChannel)channel, (ByteBuffer)ByteBuffer.wrap("world\n".getBytes(StandardCharsets.UTF_8)), (long)30L);
            ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L));
            ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)23L));
            ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)30L));
        }
    }

    @Test
    public void testWriteFullyAt_whenPartial_thenFail() throws IOException {
        try (FileChannel channel = this.mockFileChannel();){
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L))).thenAnswer(answer -> {
                ((ByteBuffer)answer.getArgument(0)).position(3);
                return 3;
            });
            Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)23L))).thenAnswer(answer -> 0);
            Assertions.assertThrows(IOException.class, () -> ZipIoUtil.writeFullyAt((FileChannel)channel, (ByteBuffer)ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)), (long)20L));
            ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L));
            ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)23L));
            ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)0))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)25L));
        }
    }
}

