/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveStructSparse;
import org.apache.commons.compress.archivers.tar.TarConstants;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.lang3.SystemProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class TarArchiveEntryTest
implements TarConstants {
    private static final String OS = SystemProperties.getOsName().toLowerCase(Locale.ROOT);
    private static final String ROOT = OS.startsWith("windows") || OS.startsWith("netware") ? "C:\\" : "/";

    private void assertGnuMagic(TarArchiveEntry t) {
        Assertions.assertEquals((Object)"ustar  \u0000", (Object)this.readMagic(t));
    }

    private void assertPosixMagic(TarArchiveEntry t) {
        Assertions.assertEquals((Object)"ustar\u000000", (Object)this.readMagic(t));
    }

    private TarArchiveEntry createEntryForTimeTests() {
        TarArchiveEntry entry = new TarArchiveEntry("./times.txt");
        entry.addPaxHeader("size", "1");
        entry.addPaxHeader("mtime", "1647221103.5998539");
        entry.addPaxHeader("atime", "1647221460.7069272");
        entry.addPaxHeader("ctime", "1647221339.7005053");
        entry.addPaxHeader("LIBARCHIVE.creationtime", "1647221340.7235090");
        return entry;
    }

    private String readMagic(TarArchiveEntry t) {
        byte[] buf = new byte[512];
        t.writeEntryHeader(buf);
        return new String(buf, 257, 8);
    }

    @Test
    public void testExtraPaxHeaders() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveEntry entry = new TarArchiveEntry("./weasels");
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            entry.addPaxHeader("APACHE.mustelida", "true");
            entry.addPaxHeader("SCHILY.xattr.user.org.apache.weasels", "maximum weasels");
            entry.addPaxHeader("size", "1");
            Assertions.assertEquals((int)2, (int)entry.getExtraPaxHeaders().size(), (String)"extra header count");
            Assertions.assertEquals((Object)"true", (Object)entry.getExtraPaxHeader("APACHE.mustelida"), (String)"APACHE.mustelida");
            Assertions.assertEquals((Object)"maximum weasels", (Object)entry.getExtraPaxHeader("SCHILY.xattr.user.org.apache.weasels"), (String)"SCHILY.xattr.user.org.apache.weasels");
            Assertions.assertEquals((long)entry.getSize(), (long)1L, (String)"size");
            tos.putArchiveEntry(entry);
            tos.write(87);
            tos.closeArchiveEntry();
        }
        Assertions.assertNotEquals((int)0, (int)entry.getExtraPaxHeaders().size(), (String)"should have extra headers before clear");
        entry.clearExtraPaxHeaders();
        Assertions.assertEquals((int)0, (int)entry.getExtraPaxHeaders().size(), (String)"extra headers should be empty after clear");
        try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));){
            entry = tis.getNextTarEntry();
            Assertions.assertNotNull((Object)entry, (String)"couldn't get entry");
            Assertions.assertEquals((int)2, (int)entry.getExtraPaxHeaders().size(), (String)"extra header count");
            Assertions.assertEquals((Object)"true", (Object)entry.getExtraPaxHeader("APACHE.mustelida"), (String)"APACHE.mustelida");
            Assertions.assertEquals((Object)"maximum weasels", (Object)entry.getExtraPaxHeader("SCHILY.xattr.user.org.apache.weasels"), (String)"user.org.apache.weasels");
            Assertions.assertEquals((int)87, (int)tis.read());
            Assertions.assertTrue((tis.read() < 0 ? 1 : 0) != 0, (String)"should be at end of entry");
            Assertions.assertNull((Object)tis.getNextTarEntry(), (String)"should be at end of file");
        }
    }

    @Test
    public void testFileSystemRoot() {
        TarArchiveEntry t = new TarArchiveEntry(new File(ROOT));
        Assertions.assertEquals((Object)"/", (Object)t.getName());
        Assertions.assertEquals((byte)53, (byte)t.getLinkFlag());
    }

    @Test
    public void testGetFileFromNonFileEntry() {
        TarArchiveEntry entry = new TarArchiveEntry("test.txt");
        Assertions.assertNull((Object)entry.getFile());
        Assertions.assertNull((Object)entry.getPath());
    }

    @Test
    public void testGetOrderedSparseHeadersRejectsOverlappingStructs() throws Exception {
        TarArchiveEntry te = new TarArchiveEntry("test");
        te.fillStarSparseData(Collections.singletonMap("SCHILY.realsize", "201"));
        te.setSparseHeaders(Arrays.asList(new TarArchiveStructSparse(10L, 5L), new TarArchiveStructSparse(12L, 1L)));
        Assertions.assertThrows(IOException.class, () -> te.getOrderedSparseHeaders());
    }

    @Test
    public void testGetOrderedSparseHeadersRejectsStructsPointingBeyondOutputEntry() throws Exception {
        TarArchiveEntry te = new TarArchiveEntry("test");
        te.setSparseHeaders(Arrays.asList(new TarArchiveStructSparse(200L, 2L)));
        te.fillStarSparseData(Collections.singletonMap("SCHILY.realsize", "201"));
        Assertions.assertThrows(IOException.class, () -> te.getOrderedSparseHeaders());
    }

    @Test
    public void testGetOrderedSparseHeadersRejectsStructsWithReallyBigNumbers() throws Exception {
        TarArchiveEntry te = new TarArchiveEntry("test");
        te.fillStarSparseData(Collections.singletonMap("SCHILY.realsize", String.valueOf(Long.MAX_VALUE)));
        te.setSparseHeaders(Arrays.asList(new TarArchiveStructSparse(Long.MAX_VALUE, 2L)));
        Assertions.assertThrows(IOException.class, () -> te.getOrderedSparseHeaders());
    }

    @Test
    public void testGetOrderedSparseHeadersSortsAndFiltersSparseStructs() throws Exception {
        TarArchiveEntry te = new TarArchiveEntry("test");
        te.fillStarSparseData(Collections.singletonMap("SCHILY.realsize", "201"));
        te.setSparseHeaders(Arrays.asList(new TarArchiveStructSparse(10L, 2L), new TarArchiveStructSparse(20L, 0L), new TarArchiveStructSparse(15L, 1L), new TarArchiveStructSparse(0L, 0L)));
        List strs = te.getOrderedSparseHeaders();
        Assertions.assertEquals((int)3, (int)strs.size());
        Assertions.assertEquals((long)10L, (long)((TarArchiveStructSparse)strs.get(0)).getOffset());
        Assertions.assertEquals((long)15L, (long)((TarArchiveStructSparse)strs.get(1)).getOffset());
        Assertions.assertEquals((long)20L, (long)((TarArchiveStructSparse)strs.get(2)).getOffset());
    }

    @Test
    public void testLinkFlagConstructor() {
        TarArchiveEntry t = new TarArchiveEntry("/foo", 76);
        this.assertGnuMagic(t);
        Assertions.assertEquals((Object)"foo", (Object)t.getName());
        Assertions.assertEquals((byte)76, (byte)t.getLinkFlag());
    }

    @Test
    public void testLinkFlagConstructorWithFileFlag() {
        TarArchiveEntry t = new TarArchiveEntry("/foo", 48);
        this.assertPosixMagic(t);
        Assertions.assertEquals((Object)"foo", (Object)t.getName());
        Assertions.assertEquals((byte)48, (byte)t.getLinkFlag());
    }

    @Test
    public void testLinkFlagConstructorWithPreserve() {
        TarArchiveEntry t = new TarArchiveEntry("/foo", 76, true);
        this.assertGnuMagic(t);
        Assertions.assertEquals((Object)"/foo", (Object)t.getName());
        Assertions.assertEquals((byte)76, (byte)t.getLinkFlag());
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    public void testLinuxFileInformationFromFile() throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(AbstractTest.getFile("test1.xml"));
        Assertions.assertNotEquals((long)0L, (long)entry.getLongUserId());
        Assertions.assertNotEquals((long)0L, (long)entry.getLongGroupId());
        Assertions.assertNotEquals((Object)"", (Object)entry.getUserName());
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    public void testLinuxFileInformationFromPath() throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(AbstractTest.getPath("test1.xml"));
        Assertions.assertNotEquals((long)0L, (long)entry.getLongUserId());
        Assertions.assertNotEquals((long)0L, (long)entry.getLongGroupId());
        Assertions.assertNotEquals((Object)"", (Object)entry.getUserName());
    }

    @Test
    public void testMaxFileSize() {
        TarArchiveEntry t = new TarArchiveEntry("");
        t.setSize(0L);
        t.setSize(1L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> t.setSize(-1L));
        t.setSize(0x1FFFFFFFFL);
        t.setSize(0x200000000L);
    }

    @Test
    public void testNegativeOffsetInConstructorNotAllowed() {
        byte[] entryContent = "test1.xml\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u00000000644\u00000000765\u00000000765\u000000000001142\u000010716545626\u0000012260\u0000 0\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000ustar  \u0000tcurdt\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000tcurdt\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes(StandardCharsets.UTF_8);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TarArchiveEntry(entryContent, ZipEncodingHelper.getZipEncoding((String)StandardCharsets.ISO_8859_1.name()), false, -1L));
    }

    @Test
    public void testNegativeOffsetInSetterNotAllowed() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TarArchiveEntry("test").setDataOffset(-1L));
    }

    @Test
    public void testPaxTimeFieldsForInvalidValues() {
        String[] headerNames = new String[]{"LIBARCHIVE.creationtime", "atime", "mtime", "ctime"};
        String[] testValues = new String[]{new Random().nextLong() + "." + String.join((CharSequence)"", Collections.nCopies(15000, String.valueOf(Long.MAX_VALUE))), "9e9999999", "9E9999999", String.valueOf(Long.MAX_VALUE), String.valueOf(Long.MIN_VALUE)};
        TarArchiveEntry entry = new TarArchiveEntry("test.txt");
        for (String name : headerNames) {
            for (String value : testValues) {
                Exception exp = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> entry.addPaxHeader(name, value));
                Assertions.assertTrue((boolean)exp.getCause().getMessage().startsWith("Corrupted PAX header. Time field value is invalid"));
            }
        }
    }

    @Test
    public void testPreservesDriveSpecOnWindowsAndNetwareIfAskedTo() {
        Assumptions.assumeTrue((boolean)"C:\\".equals(ROOT));
        TarArchiveEntry t = new TarArchiveEntry(ROOT + "foo.txt", true);
        Assertions.assertEquals((Object)"C:/foo.txt", (Object)t.getName());
        Assertions.assertEquals((byte)48, (byte)t.getLinkFlag());
        t = new TarArchiveEntry(ROOT + "foo.txt", 76, true);
        Assertions.assertEquals((Object)"C:/foo.txt", (Object)t.getName());
        Assertions.assertEquals((byte)76, (byte)t.getLinkFlag());
    }

    @Test
    public void testShouldNotWriteTimePaxHeadersByDefault() throws IOException {
        TarArchiveEntry entry;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            entry = this.createEntryForTimeTests();
            tos.putArchiveEntry(entry);
            tos.write(87);
            tos.closeArchiveEntry();
        }
        try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));){
            entry = tis.getNextTarEntry();
            Assertions.assertNotNull((Object)entry, (String)"couldn't get entry");
            Assertions.assertEquals((int)0, (int)entry.getExtraPaxHeaders().size(), (String)"extra header count");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("mtime"), (String)"mtime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("atime"), (String)"atime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("ctime"), (String)"ctime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("LIBARCHIVE.creationtime"), (String)"birthtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03Z"), (Object)entry.getLastModifiedTime(), (String)"mtime");
            Assertions.assertNull((Object)entry.getLastAccessTime(), (String)"atime");
            Assertions.assertNull((Object)entry.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)entry.getCreationTime(), (String)"birthtime");
            Assertions.assertEquals((int)87, (int)tis.read());
            Assertions.assertTrue((tis.read() < 0 ? 1 : 0) != 0, (String)"should be at end of entry");
            Assertions.assertNull((Object)tis.getNextTarEntry(), (String)"should be at end of file");
        }
    }

    @Test
    public void testShouldParseTimePaxHeadersAndNotCountAsExtraPaxHeaders() {
        TarArchiveEntry entry = this.createEntryForTimeTests();
        Assertions.assertEquals((int)0, (int)entry.getExtraPaxHeaders().size(), (String)"extra header count");
        Assertions.assertNull((Object)entry.getExtraPaxHeader("size"), (String)"size");
        Assertions.assertNull((Object)entry.getExtraPaxHeader("mtime"), (String)"mtime");
        Assertions.assertNull((Object)entry.getExtraPaxHeader("atime"), (String)"atime");
        Assertions.assertNull((Object)entry.getExtraPaxHeader("ctime"), (String)"ctime");
        Assertions.assertNull((Object)entry.getExtraPaxHeader("LIBARCHIVE.creationtime"), (String)"birthtime");
        Assertions.assertEquals((long)entry.getSize(), (long)1L, (String)"size");
        Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03.599853900Z"), (Object)entry.getLastModifiedTime(), (String)"mtime");
        Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:31:00.706927200Z"), (Object)entry.getLastAccessTime(), (String)"atime");
        Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:28:59.700505300Z"), (Object)entry.getStatusChangeTime(), (String)"ctime");
        Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:29:00.723509000Z"), (Object)entry.getCreationTime(), (String)"birthtime");
    }

    @Test
    public void testShouldWriteTimesAsPaxHeadersForPosixMode() throws IOException {
        TarArchiveEntry entry;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            entry = this.createEntryForTimeTests();
            tos.setBigNumberMode(2);
            tos.putArchiveEntry(entry);
            tos.write(87);
            tos.closeArchiveEntry();
        }
        try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));){
            entry = tis.getNextTarEntry();
            Assertions.assertNotNull((Object)entry, (String)"couldn't get entry");
            Assertions.assertEquals((int)0, (int)entry.getExtraPaxHeaders().size(), (String)"extra header count");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("mtime"), (String)"mtime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("atime"), (String)"atime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("ctime"), (String)"ctime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("LIBARCHIVE.creationtime"), (String)"birthtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03.599853900Z"), (Object)entry.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:31:00.706927200Z"), (Object)entry.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:28:59.700505300Z"), (Object)entry.getStatusChangeTime(), (String)"ctime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:29:00.723509000Z"), (Object)entry.getCreationTime(), (String)"birthtime");
            Assertions.assertEquals((int)87, (int)tis.read());
            Assertions.assertTrue((tis.read() < 0 ? 1 : 0) != 0, (String)"should be at end of entry");
            Assertions.assertNull((Object)tis.getNextTarEntry(), (String)"should be at end of file");
        }
    }

    @Test
    public void testShouldWriteTimesAsPaxHeadersForPosixModeAndCreationTimeShouldBeUsedAsCtime() throws IOException {
        TarArchiveEntry entry;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            entry = this.createEntryForTimeTests();
            entry.setStatusChangeTime(null);
            tos.setBigNumberMode(2);
            tos.putArchiveEntry(entry);
            tos.write(87);
            tos.closeArchiveEntry();
        }
        try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));){
            entry = tis.getNextTarEntry();
            Assertions.assertNotNull((Object)entry, (String)"couldn't get entry");
            Assertions.assertEquals((int)0, (int)entry.getExtraPaxHeaders().size(), (String)"extra header count");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("mtime"), (String)"mtime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("atime"), (String)"atime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("ctime"), (String)"ctime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("LIBARCHIVE.creationtime"), (String)"birthtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03.599853900Z"), (Object)entry.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:31:00.706927200Z"), (Object)entry.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:29:00.723509000Z"), (Object)entry.getStatusChangeTime(), (String)"ctime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:29:00.723509000Z"), (Object)entry.getCreationTime(), (String)"birthtime");
            Assertions.assertEquals((int)87, (int)tis.read());
            Assertions.assertTrue((tis.read() < 0 ? 1 : 0) != 0, (String)"should be at end of entry");
            Assertions.assertNull((Object)tis.getNextTarEntry(), (String)"should be at end of file");
        }
    }

    @Test
    public void testShouldWriteTimesForStarMode() throws IOException {
        TarArchiveEntry entry;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            entry = this.createEntryForTimeTests();
            tos.setBigNumberMode(1);
            tos.putArchiveEntry(entry);
            tos.write(87);
            tos.closeArchiveEntry();
        }
        try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));){
            entry = tis.getNextTarEntry();
            Assertions.assertNotNull((Object)entry, (String)"couldn't get entry");
            Assertions.assertEquals((int)0, (int)entry.getExtraPaxHeaders().size(), (String)"extra header count");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("mtime"), (String)"mtime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("atime"), (String)"atime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("ctime"), (String)"ctime");
            Assertions.assertNull((Object)entry.getExtraPaxHeader("LIBARCHIVE.creationtime"), (String)"birthtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03Z"), (Object)entry.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:31:00Z"), (Object)entry.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:28:59Z"), (Object)entry.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)entry.getCreationTime(), (String)"birthtime");
            Assertions.assertEquals((int)87, (int)tis.read());
            Assertions.assertTrue((tis.read() < 0 ? 1 : 0) != 0, (String)"should be at end of entry");
            Assertions.assertNull((Object)tis.getNextTarEntry(), (String)"should be at end of file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTarFileWithFSRoot() throws IOException {
        File f = File.createTempFile("taetest", ".tar");
        TarArchiveEntry t = new TarArchiveEntry(new File(ROOT));
        try {
            try (TarArchiveOutputStream tout = new TarArchiveOutputStream(Files.newOutputStream(f.toPath(), new OpenOption[0]));){
                tout.putArchiveEntry(t);
                tout.closeArchiveEntry();
                t = new TarArchiveEntry(new File(new File(ROOT), "foo.txt"));
                t.setSize(6L);
                tout.putArchiveEntry(t);
                tout.write(new byte[]{104, 101, 108, 108, 111, 32});
                tout.closeArchiveEntry();
                t = new TarArchiveEntry(new File(new File(ROOT), "bar.txt").getAbsolutePath());
                t.setSize(5L);
                tout.putArchiveEntry(t);
                tout.write(new byte[]{119, 111, 114, 108, 100});
                tout.closeArchiveEntry();
                t = new TarArchiveEntry("dummy");
                t.setName(new File(new File(ROOT), "baz.txt").getAbsolutePath());
                t.setSize(1L);
                tout.putArchiveEntry(t);
                tout.write(new byte[]{33});
                tout.closeArchiveEntry();
            }
            try (TarArchiveInputStream tin = new TarArchiveInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));){
                t = tin.getNextTarEntry();
                Assertions.assertNotNull((Object)t);
                Assertions.assertEquals((Object)"/", (Object)t.getName());
                Assertions.assertEquals((byte)53, (byte)t.getLinkFlag());
                Assertions.assertTrue((boolean)t.isCheckSumOK());
                t = tin.getNextTarEntry();
                Assertions.assertNotNull((Object)t);
                Assertions.assertEquals((Object)"foo.txt", (Object)t.getName());
                Assertions.assertEquals((byte)48, (byte)t.getLinkFlag());
                Assertions.assertTrue((boolean)t.isCheckSumOK());
                t = tin.getNextTarEntry();
                Assertions.assertNotNull((Object)t);
                Assertions.assertEquals((Object)"bar.txt", (Object)t.getName());
                Assertions.assertEquals((byte)48, (byte)t.getLinkFlag());
                Assertions.assertTrue((boolean)t.isCheckSumOK());
                t = tin.getNextTarEntry();
                Assertions.assertNotNull((Object)t);
                Assertions.assertEquals((Object)"baz.txt", (Object)t.getName());
                Assertions.assertEquals((byte)48, (byte)t.getLinkFlag());
                Assertions.assertTrue((boolean)t.isCheckSumOK());
            }
        }
        finally {
            AbstractTest.forceDelete(f);
        }
    }

    @Test
    @EnabledOnOs(value={OS.WINDOWS})
    public void testWindowsFileInformationFromFile() throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(AbstractTest.getFile("test1.xml"));
        Assertions.assertNotEquals((Object)"", (Object)entry.getUserName());
    }

    @Test
    @EnabledOnOs(value={OS.WINDOWS})
    public void testWindowsFileInformationFromPath() throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(AbstractTest.getPath("test1.xml"));
        Assertions.assertNotEquals((Object)"", (Object)entry.getUserName());
    }

    private FileTime toFileTime(String text) {
        return FileTime.from(Instant.parse(text));
    }
}

