/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.changes;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.changes.Change;
import org.apache.commons.compress.changes.ChangeSet;
import org.apache.commons.compress.changes.ChangeSetPerformer;
import org.apache.commons.compress.changes.ChangeSetResults;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public final class ChangeSetSafeTypesTest<I extends ArchiveInputStream<E>, O extends ArchiveOutputStream<E>, E extends ArchiveEntry>
extends AbstractTest {
    private void archiveListDelete(String prefix) {
        this.archiveList.removeIf(entry -> entry.equals(prefix));
    }

    private void archiveListDeleteDir(String prefix) {
        this.archiveList.removeIf(entry -> entry.startsWith(prefix + "/"));
    }

    private <T extends ArchiveInputStream<?>> T createArchiveInputStream(InputStream inputStream) throws ArchiveException {
        return (T)this.factory.createArchiveInputStream(inputStream);
    }

    private <T extends ArchiveInputStream<?>> T createArchiveInputStream(String archiverName, InputStream inputStream) throws ArchiveException {
        return (T)this.factory.createArchiveInputStream(archiverName, inputStream);
    }

    private <T extends ArchiveOutputStream<?>> T createArchiveOutputStream(String archiverName, OutputStream outputStream) throws ArchiveException {
        return (T)this.factory.createArchiveOutputStream(archiverName, outputStream);
    }

    private <A extends ArchiveEntry> ChangeSet<A> createChangeSet() {
        return new ChangeSet();
    }

    @Test
    public void testAddAlreadyExistingWithReplaceFalse() throws Exception {
        String archiverName = "zip";
        Path input = this.createArchive("zip");
        File result = this.createTempFile("test", ".zip");
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             ZipArchiveInputStream ais = (ZipArchiveInputStream)this.createArchiveInputStream("zip", inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             ZipArchiveOutputStream out = (ZipArchiveOutputStream)this.createArchiveOutputStream("zip", outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            ChangeSet changeSet = this.createChangeSet();
            ZipArchiveEntry entry = new ZipArchiveEntry("testdata/test1.xml");
            changeSet.add((ArchiveEntry)entry, csInputStream, false);
            ChangeSetResults results = new ChangeSetPerformer(changeSet).perform((ArchiveInputStream)ais, (ArchiveOutputStream)out);
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test1.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromChangeSet().isEmpty());
            Assertions.assertTrue((boolean)results.getDeleted().isEmpty());
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testAddAlreadyExistingWithReplaceTrue() throws Exception {
        String archiverName = "zip";
        Path input = this.createArchive("zip");
        File result = this.createTempFile("test", ".zip");
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             ZipArchiveInputStream ais = (ZipArchiveInputStream)this.createArchiveInputStream("zip", inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             ZipArchiveOutputStream out = (ZipArchiveOutputStream)this.createArchiveOutputStream("zip", outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            ChangeSet changeSet = this.createChangeSet();
            ZipArchiveEntry entry = new ZipArchiveEntry("testdata/test1.xml");
            changeSet.add((ArchiveEntry)entry, csInputStream, true);
            ChangeSetResults results = new ChangeSetPerformer(changeSet).perform((ArchiveInputStream)ais, (ArchiveOutputStream)out);
            Assertions.assertTrue((boolean)results.getAddedFromChangeSet().contains("testdata/test1.xml"));
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testAddChangeTwice() throws Exception {
        try (InputStream in = ChangeSetSafeTypesTest.newInputStream("test.txt");
             InputStream in2 = ChangeSetSafeTypesTest.newInputStream("test2.xml");){
            ZipArchiveEntry e = new ZipArchiveEntry("test.txt");
            ZipArchiveEntry e2 = new ZipArchiveEntry("test.txt");
            ChangeSet changeSet = this.createChangeSet();
            changeSet.add((ArchiveEntry)e, in);
            changeSet.add((ArchiveEntry)e2, in2);
            Assertions.assertEquals((int)1, (int)changeSet.getChanges().size());
            Change change = (Change)changeSet.getChanges().iterator().next();
            InputStream cInputStream = change.getInputStream();
            Assertions.assertEquals((Object)in2, (Object)cInputStream);
        }
    }

    @Test
    public void testAddChangeTwiceWithoutReplace() throws Exception {
        try (InputStream in = ChangeSetSafeTypesTest.newInputStream("test.txt");
             InputStream in2 = ChangeSetSafeTypesTest.newInputStream("test2.xml");){
            ZipArchiveEntry e = new ZipArchiveEntry("test.txt");
            ZipArchiveEntry e2 = new ZipArchiveEntry("test.txt");
            ChangeSet changeSet = this.createChangeSet();
            changeSet.add((ArchiveEntry)e, in, true);
            changeSet.add((ArchiveEntry)e2, in2, false);
            Assertions.assertEquals((int)1, (int)changeSet.getChanges().size());
            Change change = (Change)changeSet.getChanges().iterator().next();
            InputStream cInputStream = change.getInputStream();
            Assertions.assertEquals((Object)in, (Object)cInputStream);
        }
    }

    @Test
    public void testAddDeleteAdd() throws Exception {
        String archiverName = "cpio";
        Path input = this.createArchive("cpio");
        File result = this.createTempFile("test", ".cpio");
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             CpioArchiveInputStream ais = (CpioArchiveInputStream)this.createArchiveInputStream("cpio", inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             CpioArchiveOutputStream out = (CpioArchiveOutputStream)this.createArchiveOutputStream("cpio", outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            ChangeSet changeSet = this.createChangeSet();
            changeSet.add((ArchiveEntry)new CpioArchiveEntry("blub/test.txt"), csInputStream);
            this.archiveList.add("blub/test.txt");
            changeSet.deleteDir("blub");
            this.archiveListDeleteDir("blub");
            new ChangeSetPerformer(changeSet).perform((ArchiveInputStream)ais, (ArchiveOutputStream)out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testAddDeleteToOneFileArchive() throws Exception {
        String archiverName = "cpio";
        Path input = this.createSingleEntryArchive("cpio");
        File result = this.createTempFile("test", ".cpio");
        ChangeSet changeSet = this.createChangeSet();
        File file = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             CpioArchiveInputStream ais = (CpioArchiveInputStream)this.createArchiveInputStream("cpio", inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             CpioArchiveOutputStream out = (CpioArchiveOutputStream)this.createArchiveOutputStream("cpio", outputStream);
             InputStream csInputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            changeSet.add((ArchiveEntry)out.createArchiveEntry(file, "bla/test.txt"), csInputStream);
            this.archiveList.add("bla/test.txt");
            changeSet.delete("test1.xml");
            this.archiveListDelete("test1.xml");
            new ChangeSetPerformer(changeSet).perform((ArchiveInputStream)ais, (ArchiveOutputStream)out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testAddMoveDelete() throws Exception {
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getEmptyOutputArchiveNames"})
    public void testAddToEmptyArchive(String archiverName) throws Exception {
        Path input = this.createEmptyArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        ChangeSet changeSet = this.createChangeSet();
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            changeSet.add(out.createArchiveEntry(file1, "bla/test.txt"), csInputStream);
            this.archiveList.add("bla/test.txt");
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getZipOutputArchiveNames"})
    public void testAddToEmptyZipArchive(String archiverName) throws Exception {
        Path input = this.createEmptyArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        ChangeSet changeSet = this.createChangeSet();
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             ZipArchiveInputStream ais = (ZipArchiveInputStream)this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             ZipArchiveOutputStream out = (ZipArchiveOutputStream)this.createArchiveOutputStream(archiverName, outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            changeSet.add((ArchiveEntry)new ZipArchiveEntry("bla/test.txt"), csInputStream);
            this.archiveList.add("bla/test.txt");
            new ChangeSetPerformer(changeSet).perform((ArchiveInputStream)ais, (ArchiveOutputStream)out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getZipOutputArchiveNames"})
    public void testAddToEmptyZipParamArchive(String archiverName) throws Exception {
        Path input = this.createEmptyArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        ChangeSet changeSet = this.createChangeSet();
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            changeSet.add((ArchiveEntry)new ZipArchiveEntry("bla/test.txt"), csInputStream);
            this.archiveList.add("bla/test.txt");
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testChangeSetResults(String archiverName) throws Exception {
        Path input = this.createArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            ChangeSet changeSet = this.createChangeSet();
            changeSet.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            ArchiveEntry entry = out.createArchiveEntry(file1, "bla/test.txt");
            changeSet.add(entry, csInputStream);
            this.archiveList.add("bla/test.txt");
            ChangeSetResults results = new ChangeSetPerformer(changeSet).perform(ais, out);
            inputStream.close();
            Assertions.assertEquals((int)1, (int)results.getAddedFromChangeSet().size());
            Assertions.assertEquals((Object)"bla/test.txt", results.getAddedFromChangeSet().iterator().next());
            Assertions.assertEquals((int)3, (int)results.getDeleted().size());
            Assertions.assertTrue((boolean)results.getDeleted().contains("bla/test4.xml"));
            Assertions.assertTrue((boolean)results.getDeleted().contains("bla/test5.xml"));
            Assertions.assertTrue((boolean)results.getDeleted().contains("bla/blubber/test6.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test1.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test2.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("test/test3.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("test.txt"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("something/bla"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("test with spaces.txt"));
            Assertions.assertEquals((int)6, (int)results.getAddedFromStream().size());
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteAddDelete() throws Exception {
        String archiverName = "cpio";
        Path input = this.createArchive("cpio");
        File result = this.createTempFile("test", ".cpio");
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             CpioArchiveInputStream ais = (CpioArchiveInputStream)this.createArchiveInputStream("cpio", inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             CpioArchiveOutputStream out = (CpioArchiveOutputStream)this.createArchiveOutputStream("cpio", outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            ChangeSet changeSet = this.createChangeSet();
            changeSet.deleteDir("bla");
            changeSet.add((ArchiveEntry)new CpioArchiveEntry("bla/test.txt"), csInputStream);
            this.archiveList.add("bla/test.txt");
            changeSet.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            new ChangeSetPerformer(changeSet).perform((ArchiveInputStream)ais, (ArchiveOutputStream)out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteAddToOneFileArchive() throws Exception {
        String archiverName = "zip";
        Path input = this.createSingleEntryArchive("zip");
        File result = this.createTempFile("test", ".zip");
        ChangeSet changeSet = this.createChangeSet();
        File file = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             ZipArchiveInputStream ais = (ZipArchiveInputStream)this.createArchiveInputStream("zip", inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             ZipArchiveOutputStream out = (ZipArchiveOutputStream)this.createArchiveOutputStream("zip", outputStream);
             InputStream csInputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            changeSet.delete("test1.xml");
            this.archiveListDelete("test1.xml");
            ZipArchiveEntry entry = out.createArchiveEntry(file, "bla/test.txt");
            changeSet.add((ArchiveEntry)entry, csInputStream);
            this.archiveList.add("bla/test.txt");
            new ChangeSetPerformer(changeSet).perform((ArchiveInputStream)ais, (ArchiveOutputStream)out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeleteDir(String archiverName) throws Exception {
        Path input = this.createArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);){
            ChangeSet changeSet = this.createChangeSet();
            changeSet.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeleteDir2(String archiverName) throws Exception {
        Path input = this.createArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);){
            ChangeSet changeSet = this.createChangeSet();
            changeSet.deleteDir("la");
            this.archiveListDeleteDir("la");
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeleteDir3(String archiverName) throws Exception {
        Path input = this.createArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);){
            ChangeSet changeSet = this.createChangeSet();
            changeSet.deleteDir("test.txt");
            this.archiveListDeleteDir("test.txt");
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeleteFileCpio(String archiverName) throws Exception {
        Path input = this.createArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);){
            ChangeSet changeSet = this.createChangeSet();
            changeSet.delete("bla/test5.xml");
            this.archiveListDelete("bla/test5.xml");
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeleteFileCpio2(String archiverName) throws Exception {
        Path input = this.createArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);){
            ChangeSet changeSet = this.createChangeSet();
            changeSet.delete("bla");
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteFromAndAddToAr() throws Exception {
        String archiverName = "ar";
        ChangeSet changeSet = this.createChangeSet();
        changeSet.delete("test2.xml");
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        ArArchiveEntry entry = new ArArchiveEntry("test.txt", file1.length());
        File input = ChangeSetSafeTypesTest.getFile("bla.ar");
        File result = this.newTempFile("bla.ar");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             Object ais = this.createArchiveInputStream("ar", inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream("ar", outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            changeSet.add((ArchiveEntry)entry, csInputStream);
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("test.txt");
        this.checkArchiveContent(result, expected);
    }

    @Test
    public void testDeleteFromAndAddToJar() throws Exception {
        String archiverName = "jar";
        ChangeSet changeSet = this.createChangeSet();
        changeSet.delete("test2.xml");
        changeSet.deleteDir("META-INF");
        changeSet.delete(".classpath");
        changeSet.delete(".project");
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        JarArchiveEntry entry = new JarArchiveEntry("testdata/test.txt");
        File input = ChangeSetSafeTypesTest.getFile("bla.jar");
        File result = this.newTempFile("bla.jar");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             Object ais = this.createArchiveInputStream("jar", inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream("jar", outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            changeSet.add((ArchiveEntry)entry, csInputStream);
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("testdata/test.txt");
        this.checkArchiveContent(result, expected);
    }

    @Test
    public void testDeleteFromAndAddToTar() throws Exception {
        String archiverName = "tar";
        ChangeSet changeSet = this.createChangeSet();
        changeSet.delete("test2.xml");
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        TarArchiveEntry entry = new TarArchiveEntry("testdata/test.txt");
        entry.setModTime(0L);
        entry.setSize(file1.length());
        entry.setUserId(0);
        entry.setGroupId(0);
        entry.setUserName("avalon");
        entry.setGroupName("excalibur");
        entry.setMode(32768);
        File input = ChangeSetSafeTypesTest.getFile("bla.tar");
        File result = this.newTempFile("bla.tar");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             Object ais = this.createArchiveInputStream("tar", inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream("tar", outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            changeSet.add((ArchiveEntry)entry, csInputStream);
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("testdata/test.txt");
        try (InputStream inputStream = Files.newInputStream(result.toPath(), new OpenOption[0]);
             Object archiveInputStream = this.createArchiveInputStream("tar", inputStream);){
            this.checkArchiveContent((ArchiveInputStream<?>)archiveInputStream, (List<String>)expected);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getZipOutputArchiveNames"})
    public void testDeleteFromAndAddToZip(String archiverName) throws Exception {
        Path input = this.createArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            ChangeSet changeSet = this.createChangeSet();
            ZipArchiveEntry entry = new ZipArchiveEntry("blub/test.txt");
            changeSet.add((ArchiveEntry)entry, csInputStream);
            this.archiveList.add("blub/test.txt");
            changeSet.delete("testdata/test1.xml");
            this.archiveListDelete("testdata/test1.xml");
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getZipOutputArchiveNames"})
    public void testDeleteFromAndAddToZipUsingZipFilePerform(String archiverName) throws Exception {
        Path input = this.createArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        try (ZipFile ais = ((ZipFile.Builder)ZipFile.builder().setPath(input)).get();
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            ChangeSet changeSet = this.createChangeSet();
            ZipArchiveEntry entry = new ZipArchiveEntry("blub/test.txt");
            changeSet.add((ArchiveEntry)entry, csInputStream);
            this.archiveList.add("blub/test.txt");
            changeSet.delete("testdata/test1.xml");
            this.archiveListDelete("testdata/test1.xml");
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteFromAr() throws Exception {
        String archiverName = "ar";
        ChangeSet changeSet = this.createChangeSet();
        changeSet.delete("test2.xml");
        File input = ChangeSetSafeTypesTest.getFile("bla.ar");
        File temp = this.newTempFile("bla.ar");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             Object ais = this.createArchiveInputStream("ar", inputStream);
             OutputStream outputStream = Files.newOutputStream(temp.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream("ar", outputStream);){
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getZipOutputArchiveNames"})
    public void testDeleteFromJar(String archiverName) throws Exception {
        ChangeSet changeSet = this.createChangeSet();
        changeSet.delete("test2.xml");
        changeSet.deleteDir("META-INF");
        changeSet.delete(".classpath");
        changeSet.delete(".project");
        File input = ChangeSetSafeTypesTest.getFile("bla.jar");
        File temp = this.newTempFile("bla.jar");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(temp.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);){
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    @Test
    public void testDeleteFromTar() throws Exception {
        String archiverName = "tar";
        ChangeSet changeSet = this.createChangeSet();
        changeSet.delete("test2.xml");
        File input = ChangeSetSafeTypesTest.getFile("bla.tar");
        File temp = this.newTempFile("bla.tar");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             Object ais = this.createArchiveInputStream("tar", inputStream);
             OutputStream outputStream = Files.newOutputStream(temp.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream("tar", outputStream);){
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getZipOutputArchiveNames"})
    public void testDeleteFromZip(String archiverName) throws Exception {
        ChangeSet changeSet = this.createChangeSet();
        changeSet.delete("test2.xml");
        File input = ChangeSetSafeTypesTest.getFile("bla.zip");
        File temp = this.createTempFile("test", ".zip");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(temp.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);){
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeletePlusAdd(String archiverName) throws Exception {
        Path input = this.createArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        File file1 = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            ChangeSet changeSet = this.createChangeSet();
            changeSet.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            ArchiveEntry entry = out.createArchiveEntry(file1, "bla/test.txt");
            changeSet.add(entry, csInputStream);
            this.archiveList.add("bla/test.txt");
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeletePlusAddSame(String archiverName) throws Exception {
        Path input = this.createArchive(archiverName);
        File result = this.createTempFile("test", "." + archiverName);
        File testTxt = ChangeSetSafeTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             Object ais = this.createArchiveInputStream(archiverName, inputStream);
             OutputStream outputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             Object out = this.createArchiveOutputStream(archiverName, outputStream);
             InputStream csInputStream = Files.newInputStream(testTxt.toPath(), new OpenOption[0]);){
            ChangeSet changeSet = this.createChangeSet();
            changeSet.delete("test/test3.xml");
            this.archiveListDelete("test/test3.xml");
            ArchiveEntry entry = out.createArchiveEntry(testTxt, "test/test3.xml");
            changeSet.add(entry, csInputStream);
            this.archiveList.add("test/test3.xml");
            new ChangeSetPerformer(changeSet).perform(ais, out);
        }
        try (BufferedInputStream buf = new BufferedInputStream(Files.newInputStream(result.toPath(), new OpenOption[0]));
             Object in = this.createArchiveInputStream(buf);){
            File check = this.checkArchiveContent((ArchiveInputStream<?>)in, this.archiveList, false);
            File test3xml = new File(check, "result/test/test3.xml");
            Assertions.assertEquals((long)testTxt.length(), (long)test3xml.length());
            try (BufferedReader reader = new BufferedReader(Files.newBufferedReader(test3xml.toPath()));){
                String str;
                while ((str = reader.readLine()) != null) {
                    "111111111111111111111111111000101011".equals(str);
                }
            }
            ChangeSetSafeTypesTest.forceDelete(check);
        }
    }

    @Test
    public void testRenameAndDelete() {
    }
}

