/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.snappy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Random;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class SnappyRoundtripTest
extends AbstractTest {
    private static Parameters newParameters(int windowSize, int minBackReferenceLength, int maxBackReferenceLength, int maxOffset, int maxLiteralLength) {
        return Parameters.builder((int)windowSize).withMinBackReferenceLength(minBackReferenceLength).withMaxBackReferenceLength(maxBackReferenceLength).withMaxOffset(maxOffset).withMaxLiteralLength(maxLiteralLength).build();
    }

    private void roundTripTest(byte[] input, Parameters params) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (SnappyCompressorOutputStream sos = new SnappyCompressorOutputStream((OutputStream)os, (long)input.length, params);){
            sos.write(input);
        }
        try (SnappyCompressorInputStream sis = new SnappyCompressorInputStream((InputStream)new ByteArrayInputStream(os.toByteArray()), params.getWindowSize());){
            byte[] actual = IOUtils.toByteArray((InputStream)sis);
            Assertions.assertArrayEquals((byte[])input, (byte[])actual);
        }
    }

    private void roundTripTest(Path input, Parameters params) throws IOException {
        File outputSz = this.newTempFile(input.getFileName() + ".raw.sz");
        try (OutputStream os = Files.newOutputStream(outputSz.toPath(), new OpenOption[0]);
             SnappyCompressorOutputStream sos = new SnappyCompressorOutputStream(os, Files.size(input), params);){
            Files.copy(input, (OutputStream)sos);
        }
        try (SnappyCompressorInputStream sis = new SnappyCompressorInputStream(Files.newInputStream(outputSz.toPath(), new OpenOption[0]), params.getWindowSize());){
            byte[] expected = Files.readAllBytes(input);
            byte[] actual = IOUtils.toByteArray((InputStream)sis);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    private void roundTripTest(String testFile) throws IOException {
        this.roundTripTest(SnappyRoundtripTest.getPath(testFile), SnappyCompressorOutputStream.createParameterBuilder((int)32768).build());
    }

    @Test
    public void testBiggerFileRoundtrip() throws IOException {
        this.roundTripTest("COMPRESS-256.7z");
    }

    @Test
    public void testBlaTarRoundtrip() throws IOException {
        this.roundTripTest("bla.tar");
    }

    @Test
    public void testBlaTarRoundtripTunedForCompressionRatio() throws IOException {
        this.roundTripTest(SnappyRoundtripTest.getPath("bla.tar"), SnappyCompressorOutputStream.createParameterBuilder((int)32768).tunedForCompressionRatio().build());
    }

    @Test
    public void testBlaTarRoundtripTunedForSpeed() throws IOException {
        this.roundTripTest(SnappyRoundtripTest.getPath("bla.tar"), SnappyCompressorOutputStream.createParameterBuilder((int)32768).tunedForSpeed().build());
    }

    @Test
    public void testGzippedLoremIpsumRoundtrip() throws IOException {
        this.roundTripTest("lorem-ipsum.txt.gz");
    }

    @Test
    public void testTryReallyBigOffset() throws IOException {
        ByteArrayOutputStream fs = new ByteArrayOutputStream(66560);
        fs.write(0);
        fs.write(0);
        fs.write(0);
        fs.write(0);
        int cnt = 0x200000;
        Random r = new Random();
        for (int i = 0; i < 0x200000; ++i) {
            fs.write(r.nextInt(255) + 1);
        }
        fs.write(0);
        fs.write(0);
        fs.write(0);
        fs.write(0);
        this.roundTripTest(fs.toByteArray(), SnappyRoundtripTest.newParameters(131072, 4, 64, 65536, 65536));
    }

    @Test
    public void testTryReallyLongLiterals() throws IOException {
        Path path = this.newTempPath("reallyBigLiteralTest");
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            int cnt = 524288;
            Random r = new Random();
            for (int i = 0; i < 524288; ++i) {
                outputStream.write(r.nextInt(256));
            }
        }
        this.roundTripTest(path, SnappyRoundtripTest.newParameters(262144, 4, 64, 32768, 131072));
    }
}

