/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.pack200;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200Utils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public final class Pack200UtilsTest
extends AbstractTest {
    private long parseEntry(InputStream is) throws IOException {
        try (UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();){
            long l;
            try (Pack200CompressorInputStream p = new Pack200CompressorInputStream(is);){
                l = IOUtils.copy((InputStream)p, (OutputStream)bos);
            }
            return l;
        }
    }

    @Test
    public void testCompress675() throws Exception {
        long expectedCount;
        File pack = Pack200UtilsTest.getFile("bla.pack");
        File archiveFile = this.createTempFile();
        try (UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();
             Pack200CompressorInputStream inputStream = new Pack200CompressorInputStream((InputStream)new FileInputStream(pack));){
            IOUtils.copy((InputStream)inputStream, (OutputStream)bos);
            expectedCount = bos.size() * 2;
        }
        try (FileOutputStream os = new FileOutputStream(archiveFile);
             TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)os);){
            TarArchiveEntry ae = taos.createArchiveEntry(pack, "./bla.pack");
            taos.putArchiveEntry(ae);
            try (FileInputStream in = new FileInputStream(pack);){
                IOUtils.copy((InputStream)in, (OutputStream)taos);
            }
            taos.closeArchiveEntry();
            TarArchiveEntry ae2 = taos.createArchiveEntry(pack, "./bla2.pack");
            taos.putArchiveEntry(ae2);
            try (FileInputStream in = new FileInputStream(pack);){
                IOUtils.copy((InputStream)in, (OutputStream)taos);
            }
            taos.closeArchiveEntry();
            taos.finish();
            taos.flush();
        }
        try (FileInputStream is = new FileInputStream(archiveFile);
             TarArchiveInputStream in = new TarArchiveInputStream((InputStream)is);){
            TarArchiveEntry entry = in.getNextEntry();
            int entries = 0;
            long count = 0L;
            while (entry != null) {
                if (in.canReadEntryData((ArchiveEntry)entry)) {
                    CloseShieldInputStream wrap = CloseShieldInputStream.wrap((InputStream)in);
                    count += this.parseEntry((InputStream)wrap);
                    ++entries;
                }
                entry = in.getNextEntry();
            }
            Assert.assertEquals((long)2L, (long)entries);
            Assert.assertEquals((long)expectedCount, (long)count);
        }
    }

    @Test
    public void testNormalize() throws Throwable {
        File input = Pack200UtilsTest.getFile("bla.jar");
        File output = this.createTempFile();
        Pack200Utils.normalize((File)input, (File)output, new HashMap());
        try (InputStream is = Files.newInputStream(output.toPath(), new OpenOption[0]);
             ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", is);){
            ArchiveEntry entry = in.getNextEntry();
            while (entry != null) {
                File archiveEntry = this.newTempFile(entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    entry = in.getNextEntry();
                    continue;
                }
                Files.copy((InputStream)in, archiveEntry.toPath(), new CopyOption[0]);
                entry = in.getNextEntry();
            }
        }
    }

    @Test
    public void testNormalizeInPlace() throws Throwable {
        File input = Pack200UtilsTest.getFile("bla.jar");
        File output = this.createTempFile();
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            Files.copy(is, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        Pack200Utils.normalize((File)output);
        is = Files.newInputStream(output.toPath(), new OpenOption[0]);
        try (ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", is);){
            ArchiveEntry entry = in.getNextEntry();
            while (entry != null) {
                File archiveEntry = this.newTempFile(entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    entry = in.getNextEntry();
                    continue;
                }
                Files.copy((InputStream)in, archiveEntry.toPath(), new CopyOption[0]);
                entry = in.getNextEntry();
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

