/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Random;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.Zip64RequiredException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.io.RandomAccessFileMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class Zip64SupportIT {
    private static final long FIVE_BILLION = 5000000000L;
    private static final int ONE_MILLION = 1000000;
    private static final int ONE_HUNDRED_THOUSAND = 100000;
    private static final ZipOutputTest write100KFilesModeNever = (f, zos) -> {
        zos.setUseZip64(Zip64Mode.Never);
        Zip64RequiredException ex = (Zip64RequiredException)Assertions.assertThrows(Zip64RequiredException.class, () -> Zip64SupportIT.write100KFilesToStream(zos), (String)"expected a Zip64RequiredException");
        Assertions.assertEquals((Object)"Archive contains more than 65535 entries.", (Object)ex.getMessage());
    };
    private static final ZipOutputTest write3EntriesCreatingBigArchiveModeNever = (f, zos) -> {
        zos.setUseZip64(Zip64Mode.Never);
        Zip64RequiredException ex = (Zip64RequiredException)Assertions.assertThrows(Zip64RequiredException.class, () -> Zip64SupportIT.write3EntriesCreatingBigArchiveToStream(zos), (String)"expected a Zip64RequiredException");
        Assertions.assertEquals((Object)"Archive's size exceeds the limit of 4GByte.", (Object)ex.getMessage());
    };

    private static File get100KFileFile() throws Throwable {
        return AbstractTest.getFile("100k_Files.zip");
    }

    private static File get100KFileFileGeneratedBy7ZIP() throws Throwable {
        return AbstractTest.getFile("100k_Files_7ZIP.zip");
    }

    private static File get100KFileFileGeneratedByJava7Jar() throws Throwable {
        return AbstractTest.getFile("100k_Files_jar.zip");
    }

    private static File get100KFileFileGeneratedByPKZip() throws Throwable {
        return AbstractTest.getFile("100k_Files_PKZip.zip");
    }

    private static File get100KFileFileGeneratedByWinCF() throws Throwable {
        return AbstractTest.getFile("100k_Files_WindowsCompressedFolders.zip");
    }

    private static File get100KFileFileGeneratedByWinZIP() throws Throwable {
        return AbstractTest.getFile("100k_Files_WinZIP.zip");
    }

    private static File get5GBZerosFile() throws Throwable {
        return AbstractTest.getFile("5GB_of_Zeros.zip");
    }

    private static File get5GBZerosFileGeneratedBy7ZIP() throws Throwable {
        return AbstractTest.getFile("5GB_of_Zeros_7ZIP.zip");
    }

    private static File get5GBZerosFileGeneratedByJava7Jar() throws Throwable {
        return AbstractTest.getFile("5GB_of_Zeros_jar.zip");
    }

    private static File get5GBZerosFileGeneratedByPKZip() throws Throwable {
        return AbstractTest.getFile("5GB_of_Zeros_PKZip.zip");
    }

    private static File get5GBZerosFileGeneratedByWinZIP() throws Throwable {
        return AbstractTest.getFile("5GB_of_Zeros_WinZip.zip");
    }

    private static long getLengthAndPositionAtCentralDirectory(RandomAccessFile a) throws IOException {
        long end = a.length();
        a.seek(end - 22L - 20L);
        byte[] sig = new byte[4];
        a.readFully(sig);
        if (sig[0] != 80 || sig[1] != 75 || sig[2] != 6 || sig[3] != 7) {
            return Zip64SupportIT.getLengthAndPositionAtCentralDirectory32(a, end);
        }
        long cdOffsetLoc = end - 22L - 20L - 56L + 48L;
        a.seek(cdOffsetLoc);
        byte[] cdOffset = new byte[8];
        a.readFully(cdOffset);
        a.seek(ZipEightByteInteger.getLongValue((byte[])cdOffset));
        return end;
    }

    private static long getLengthAndPositionAtCentralDirectory32(RandomAccessFile a, long end) throws IOException {
        a.seek(end - 22L + 16L);
        byte[] cdOffset = new byte[4];
        a.readFully(cdOffset);
        a.seek(ZipLong.getValue((byte[])cdOffset));
        return end;
    }

    private static File getTempFile(String testName) throws Throwable {
        File f = File.createTempFile("commons-compress-" + testName, ".zip");
        f.deleteOnExit();
        return f;
    }

    private static void read100KFilesImpl(File f) throws IOException {
        try (InputStream fin = Files.newInputStream(f.toPath(), new OpenOption[0]);
             ZipArchiveInputStream zin = new ZipArchiveInputStream(fin);){
            ZipArchiveEntry zae;
            int files = 0;
            while ((zae = zin.getNextZipEntry()) != null) {
                if (zae.isDirectory()) continue;
                ++files;
                Assertions.assertEquals((long)0L, (long)zae.getSize());
            }
            Assertions.assertEquals((int)100000, (int)files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read100KFilesUsingZipFileImpl(File f) throws IOException {
        ZipFile zf = null;
        try {
            zf = ((ZipFile.Builder)ZipFile.builder().setFile(f)).get();
            int files = 0;
            Enumeration e = zf.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry zae = (ZipArchiveEntry)e.nextElement();
                if (zae.isDirectory()) continue;
                ++files;
                Assertions.assertEquals((long)0L, (long)zae.getSize());
            }
            Assertions.assertEquals((int)100000, (int)files);
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }

    private static void read5GBOfZerosImpl(File f, String expectedName) throws IOException {
        try (InputStream fin = Files.newInputStream(f.toPath(), new OpenOption[0]);
             ZipArchiveInputStream zin = new ZipArchiveInputStream(fin);){
            int readNow;
            ZipArchiveEntry zae = zin.getNextZipEntry();
            while (zae.isDirectory()) {
                zae = zin.getNextZipEntry();
            }
            Assertions.assertEquals((Object)expectedName, (Object)zae.getName());
            byte[] buf = new byte[0x100000];
            long read = 0L;
            Random r = new Random(System.currentTimeMillis());
            while ((readNow = zin.read(buf, 0, buf.length)) > 0) {
                for (int i = 0; i < 1024; ++i) {
                    int idx = r.nextInt(readNow);
                    Assertions.assertEquals((int)0, (int)buf[idx], (String)("testing byte " + (read + (long)idx)));
                }
                read += (long)readNow;
            }
            Assertions.assertEquals((long)5000000000L, (long)read);
            Assertions.assertNull((Object)zin.getNextZipEntry());
            Assertions.assertEquals((long)5000000000L, (long)zae.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read5GBOfZerosUsingZipFileImpl(File f, String expectedName) throws IOException {
        ZipFile zf = null;
        try {
            zf = ((ZipFile.Builder)ZipFile.builder().setFile(f)).get();
            Enumeration e = zf.getEntries();
            Assertions.assertTrue((boolean)e.hasMoreElements());
            ZipArchiveEntry zae = (ZipArchiveEntry)e.nextElement();
            while (zae.isDirectory()) {
                zae = (ZipArchiveEntry)e.nextElement();
            }
            Assertions.assertEquals((Object)expectedName, (Object)zae.getName());
            Assertions.assertEquals((long)5000000000L, (long)zae.getSize());
            byte[] buf = new byte[0x100000];
            long read = 0L;
            Random r = new Random(System.currentTimeMillis());
            try (InputStream zin = zf.getInputStream(zae);){
                int readNow;
                while ((readNow = zin.read(buf, 0, buf.length)) > 0) {
                    for (int i = 0; i < 1024; ++i) {
                        int idx = r.nextInt(readNow);
                        Assertions.assertEquals((int)0, (int)buf[idx], (String)("testing byte " + (read + (long)idx)));
                    }
                    read += (long)readNow;
                }
            }
            Assertions.assertEquals((long)5000000000L, (long)read);
            Assertions.assertFalse((boolean)e.hasMoreElements());
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }

    private static void withTemporaryArchive(String testName, ZipOutputTest test, boolean useRandomAccessFile) throws Throwable {
        Zip64SupportIT.withTemporaryArchive(testName, test, useRandomAccessFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void withTemporaryArchive(String testName, ZipOutputTest test, boolean useRandomAccessFile, Long splitSize) throws Throwable {
        ZipArchiveOutputStream zos;
        ZipArchiveOutputStream zipArchiveOutputStream;
        File f = Zip64SupportIT.getTempFile(testName);
        File dir = null;
        if (splitSize != null) {
            dir = Files.createTempDirectory("commons-compress-" + testName, new FileAttribute[0]).toFile();
            dir.deleteOnExit();
            f = new File(dir, "commons-compress-" + testName + ".zip");
        }
        BufferedOutputStream os = null;
        if (useRandomAccessFile) {
            zipArchiveOutputStream = new ZipArchiveOutputStream(f);
        } else {
            os = new BufferedOutputStream(Files.newOutputStream(f.toPath(), new OpenOption[0]));
            zipArchiveOutputStream = zos = new ZipArchiveOutputStream((OutputStream)os);
        }
        if (splitSize != null) {
            zos = new ZipArchiveOutputStream(f, splitSize.longValue());
        }
        try {
            test.test(f, zos);
        }
        catch (IOException ex) {
            System.err.println("Failed to write archive because of: " + ex.getMessage() + " - likely not enough disk space.");
            Assumptions.assumeTrue((boolean)false);
        }
        finally {
            try {
                zos.destroy();
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                    AbstractTest.forceDelete(f);
                }
                finally {
                    if (dir != null) {
                        File directory = dir;
                        AbstractTest.forceDelete(directory);
                    }
                }
            }
        }
    }

    private static ZipOutputTest write100KFiles() {
        return Zip64SupportIT.write100KFiles(Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest write100KFiles(Zip64Mode mode) {
        return (f, zos) -> {
            if (mode != Zip64Mode.AsNeeded) {
                zos.setUseZip64(mode);
            }
            Zip64SupportIT.write100KFilesToStream(zos);
            try (RandomAccessFile a = RandomAccessFileMode.READ_ONLY.create(f);){
                long end = a.length();
                a.seek(end - 22L);
                byte[] eocd = new byte[12];
                a.readFully(eocd);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 5, 6, 0, 0, 0, 0, -1, -1, -1, -1}, (byte[])eocd);
                long expectedZ64EocdOffset = end - 22L - 20L - 56L;
                byte[] loc = ZipEightByteInteger.getBytes((long)expectedZ64EocdOffset);
                a.seek(end - 22L - 20L);
                byte[] z64EocdLoc = new byte[20];
                a.readFully(z64EocdLoc);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 6, 7, 0, 0, 0, 0, loc[0], loc[1], loc[2], loc[3], loc[4], loc[5], loc[6], loc[7], 1, 0, 0, 0}, (byte[])z64EocdLoc);
                a.seek(expectedZ64EocdOffset);
                byte[] z64EocdStart = new byte[40];
                a.readFully(z64EocdStart);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 6, 6, 44, 0, 0, 0, 0, 0, 0, 0, 45, 0, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0, -96, -122, 1, 0, 0, 0, 0, 0, -96, -122, 1, 0, 0, 0, 0, 0}, (byte[])z64EocdStart);
                a.seek(expectedZ64EocdOffset + 48L);
                byte[] cdOffset = new byte[8];
                a.readFully(cdOffset);
                long cdLoc = ZipEightByteInteger.getLongValue((byte[])cdOffset);
                a.seek(cdLoc);
                byte[] sig = new byte[4];
                a.readFully(sig);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2}, (byte[])sig);
            }
        };
    }

    private static void write100KFilesToStream(ZipArchiveOutputStream zos) throws IOException {
        for (int i = 0; i < 100000; ++i) {
            ZipArchiveEntry zae = new ZipArchiveEntry(String.valueOf(i));
            zae.setSize(0L);
            zos.putArchiveEntry(zae);
            zos.closeArchiveEntry();
        }
        zos.close();
    }

    private static ZipOutputTest write3EntriesCreatingBigArchive() {
        return Zip64SupportIT.write3EntriesCreatingBigArchive(Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest write3EntriesCreatingBigArchive(Zip64Mode mode) {
        return Zip64SupportIT.write3EntriesCreatingBigArchive(mode, false);
    }

    private static ZipOutputTest write3EntriesCreatingBigArchive(Zip64Mode mode, boolean isSplitArchive) {
        return (f, zos) -> {
            if (mode != Zip64Mode.AsNeeded) {
                zos.setUseZip64(mode);
            }
            Zip64SupportIT.write3EntriesCreatingBigArchiveToStream(zos);
            try (RandomAccessFile a = RandomAccessFileMode.READ_ONLY.create(f);){
                Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                a.skipBytes(94 + 2 * (mode == Zip64Mode.Always ? 32 : 0));
                byte[] header = new byte[12];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 0, 8, 0, 0}, (byte[])header, (String)"CDH start");
                a.skipBytes(12);
                byte[] originalSize = new byte[4];
                a.readFully(originalSize);
                if (mode == Zip64Mode.Always) {
                    Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1}, (byte[])originalSize, (String)"CDH original size");
                } else {
                    Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 0, 0}, (byte[])originalSize, (String)"CDH original size");
                }
                byte[] rest = new byte[19];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, (byte)(mode == Zip64Mode.Always ? 32 : 12), 0, 0, 0, (byte)(isSplitArchive ? 255 : 0), (byte)(isSplitArchive ? 255 : 0), 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 50}, (byte[])rest, (String)"CDH rest");
                if (mode == Zip64Mode.Always) {
                    byte[] extra1 = new byte[12];
                    a.readFully(extra1);
                    Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 28, 0, 1, 0, 0, 0, 0, 0, 0, 0}, (byte[])extra1, (String)"CDH extra");
                    a.skipBytes(8);
                } else {
                    byte[] extra2 = new byte[4];
                    a.readFully(extra2);
                    Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 8, 0}, (byte[])extra2, (String)"CDH extra");
                }
                byte[] offset = new byte[8];
                a.readFully(offset);
                a.seek(ZipEightByteInteger.getLongValue((byte[])offset));
                byte[] sig = new byte[4];
                a.readFully(sig);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4}, (byte[])sig, (String)"LFH signature");
            }
        };
    }

    private static void write3EntriesCreatingBigArchiveToStream(ZipArchiveOutputStream zos) throws IOException {
        ZipArchiveEntry zae;
        byte[] buf = new byte[1000000];
        for (int i = 0; i < 2; ++i) {
            zae = new ZipArchiveEntry(String.valueOf(i));
            zae.setSize(2500000000L);
            zae.setMethod(0);
            zae.setCrc(2319486742L);
            zos.putArchiveEntry(zae);
            int j = 0;
            while ((long)j < 2500L) {
                zos.write(buf);
                ++j;
            }
            zos.closeArchiveEntry();
        }
        zae = new ZipArchiveEntry(String.valueOf(2));
        zae.setSize(1L);
        zae.setMethod(0);
        zae.setCrc(163128923L);
        zos.putArchiveEntry(zae);
        zos.write(new byte[]{42});
        zos.closeArchiveEntry();
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File write5GBZerosFile(String testName) throws Throwable {
        File f = Zip64SupportIT.getTempFile(testName);
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream(f);
        try {
            zos.setUseZip64(Zip64Mode.Always);
            byte[] buf = new byte[1000000];
            ZipArchiveEntry zae = new ZipArchiveEntry("5GB_of_Zeros");
            zae.setSize(5000000000L);
            zae.setMethod(8);
            zae.setCrc(2319486742L);
            zos.putArchiveEntry(zae);
            int j = 0;
            while ((long)j < 5000L) {
                zos.write(buf);
                ++j;
            }
            zos.closeArchiveEntry();
            zos.close();
        }
        catch (IOException ex) {
            System.err.println("Failed to write archive because of: " + ex.getMessage() + " - likely not enough disk space.");
            Assumptions.assumeTrue((boolean)false);
        }
        finally {
            zos.destroy();
        }
        return f;
    }

    private static ZipOutputTest writeBigDeflatedEntryToFile(boolean knownSize) {
        return Zip64SupportIT.writeBigDeflatedEntryToFile(knownSize, Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest writeBigDeflatedEntryToFile(boolean knownSize, Zip64Mode mode) {
        return (f, zos) -> {
            if (mode != Zip64Mode.AsNeeded) {
                zos.setUseZip64(mode);
            }
            byte[] buf = new byte[1000000];
            ZipArchiveEntry zae = new ZipArchiveEntry("0");
            if (knownSize) {
                zae.setSize(5000000000L);
            }
            zae.setMethod(8);
            zos.putArchiveEntry(zae);
            int j = 0;
            while ((long)j < 5000L) {
                zos.write(buf);
                ++j;
            }
            zos.closeArchiveEntry();
            zos.close();
            try (RandomAccessFile a = RandomAccessFileMode.READ_ONLY.create(f);){
                Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                byte[] header = new byte[12];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 0, 8, 8, 0}, (byte[])header, (String)"CDH start");
                a.skipBytes(4);
                byte[] rest = new byte[26];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 111, 49, 92, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, (byte)(mode == Zip64Mode.Always ? 32 : 20), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (byte[])rest, (String)"CDH rest");
                byte[] offset = new byte[4];
                a.readFully(offset);
                if (mode == Zip64Mode.Always) {
                    Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1}, (byte[])offset, (String)"offset");
                } else {
                    Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0}, (byte[])offset, (String)"offset");
                }
                Assertions.assertEquals((int)48, (int)a.read());
                byte[] extra = new byte[12];
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, (byte)(mode == Zip64Mode.Always ? 28 : 16), 0, 0, -14, 5, 42, 1, 0, 0, 0}, (byte[])extra, (String)"CDH extra");
                if (mode == Zip64Mode.Always) {
                    a.skipBytes(8);
                    offset = new byte[8];
                    a.readFully(offset);
                    Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, (byte[])offset, (String)"extra offset");
                }
                a.seek(0L);
                header = new byte[10];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 0, 8, 8, 0}, (byte[])header, (String)"LFH start");
                a.skipBytes(4);
                rest = new byte[17];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 111, 49, 92, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest);
                extra = new byte[12];
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 0, -14, 5, 42, 1, 0, 0, 0}, (byte[])extra);
            }
        };
    }

    private static ZipOutputTest writeBigDeflatedEntryToFileModeNever(boolean knownSize) {
        return (f, zos) -> {
            zos.setUseZip64(Zip64Mode.Never);
            Zip64RequiredException ex = (Zip64RequiredException)Assertions.assertThrows(Zip64RequiredException.class, () -> {
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                if (knownSize) {
                    zae.setSize(5000000000L);
                }
                zae.setMethod(8);
                zos.putArchiveEntry(zae);
                int j = 0;
                while ((long)j < 5000L) {
                    zos.write(buf);
                    ++j;
                }
                zos.closeArchiveEntry();
            }, (String)"expected a Zip64RequiredException");
            Assertions.assertTrue((boolean)ex.getMessage().startsWith("0's size"));
        };
    }

    private static ZipOutputTest writeBigDeflatedEntryToStream(boolean knownSize, Zip64Mode mode) {
        return (f, zos) -> {
            if (mode != Zip64Mode.AsNeeded) {
                zos.setUseZip64(mode);
            }
            byte[] buf = new byte[1000000];
            ZipArchiveEntry zae = new ZipArchiveEntry("0");
            if (knownSize) {
                zae.setSize(5000000000L);
            }
            zae.setMethod(8);
            zos.putArchiveEntry(zae);
            int j = 0;
            while ((long)j < 5000L) {
                zos.write(buf);
                ++j;
            }
            zos.closeArchiveEntry();
            zos.close();
            try (RandomAccessFile a = RandomAccessFileMode.READ_ONLY.create(f);){
                Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                long cfhPos = a.getFilePointer();
                byte[] header = new byte[12];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 8, 8, 8, 0}, (byte[])header, (String)"CDH start");
                a.skipBytes(4);
                byte[] rest = new byte[26];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 111, 49, 92, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, (byte)(mode == Zip64Mode.Always ? 32 : 20), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (byte[])rest, (String)"CDH rest");
                byte[] offset = new byte[4];
                a.readFully(offset);
                if (mode == Zip64Mode.Always) {
                    Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1}, (byte[])offset, (String)"offset");
                } else {
                    Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0}, (byte[])offset, (String)"offset");
                }
                Assertions.assertEquals((int)48, (int)a.read());
                byte[] extra = new byte[12];
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, (byte)(mode == Zip64Mode.Always ? 28 : 16), 0, 0, -14, 5, 42, 1, 0, 0, 0}, (byte[])extra, (String)"CDH extra");
                if (mode == Zip64Mode.Always) {
                    a.skipBytes(8);
                    offset = new byte[8];
                    a.readFully(offset);
                    Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, (byte[])offset, (String)"extra offset");
                }
                a.seek(cfhPos - 24L);
                byte[] dd = new byte[8];
                a.readFully(dd);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 7, 8, 80, 111, 49, 92}, (byte[])dd, (String)"DD");
                a.skipBytes(8);
                dd = new byte[8];
                a.readFully(dd);
                Assertions.assertArrayEquals((byte[])new byte[]{0, -14, 5, 42, 1, 0, 0, 0}, (byte[])dd, (String)"DD sizes");
                a.seek(0L);
                header = new byte[10];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 8, 8, 8, 0}, (byte[])header, (String)"LFH start");
                a.skipBytes(4);
                rest = new byte[17];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest, (String)"LFH rest");
                extra = new byte[20];
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (byte[])extra, (String)"LFH extra");
            }
        };
    }

    private static ZipOutputTest writeBigDeflatedEntryUnknownSizeToStream(Zip64Mode mode) {
        return (f, zos) -> {
            Zip64RequiredException ex = (Zip64RequiredException)Assertions.assertThrows(Zip64RequiredException.class, () -> {
                if (mode != Zip64Mode.AsNeeded) {
                    zos.setUseZip64(mode);
                }
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                zae.setMethod(8);
                zos.putArchiveEntry(zae);
                int j = 0;
                while ((long)j < 5000L) {
                    zos.write(buf);
                    ++j;
                }
                zos.closeArchiveEntry();
            }, (String)"expected a Zip64RequiredException");
            Assertions.assertTrue((boolean)ex.getMessage().startsWith("0's size"));
        };
    }

    private static ZipOutputTest writeBigStoredEntry(boolean knownSize) {
        return Zip64SupportIT.writeBigStoredEntry(knownSize, Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest writeBigStoredEntry(boolean knownSize, Zip64Mode mode) {
        return (f, zos) -> {
            if (mode != Zip64Mode.AsNeeded) {
                zos.setUseZip64(mode);
            }
            byte[] buf = new byte[1000000];
            ZipArchiveEntry zae = new ZipArchiveEntry("0");
            if (knownSize) {
                zae.setSize(5000000000L);
                zae.setCrc(1546743632L);
            }
            zae.setMethod(0);
            zos.putArchiveEntry(zae);
            int j = 0;
            while ((long)j < 5000L) {
                zos.write(buf);
                ++j;
            }
            zos.closeArchiveEntry();
            zos.close();
            try (RandomAccessFile a = RandomAccessFileMode.READ_ONLY.create(f);){
                Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                byte[] header = new byte[12];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 0, 8, 0, 0}, (byte[])header, (String)"CDH start");
                a.skipBytes(4);
                byte[] rest = new byte[26];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 111, 49, 92, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, (byte)(mode == Zip64Mode.Always ? 32 : 20), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (byte[])rest, (String)"CDH rest");
                byte[] offset = new byte[4];
                a.readFully(offset);
                if (mode == Zip64Mode.Always) {
                    Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1}, (byte[])offset, (String)"offset");
                } else {
                    Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0}, (byte[])offset, (String)"offset");
                }
                Assertions.assertEquals((int)48, (int)a.read());
                byte[] extra = new byte[20];
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, (byte)(mode == Zip64Mode.Always ? 28 : 16), 0, 0, -14, 5, 42, 1, 0, 0, 0, 0, -14, 5, 42, 1, 0, 0, 0}, (byte[])extra, (String)"CDH extra");
                if (mode == Zip64Mode.Always) {
                    offset = new byte[8];
                    a.readFully(offset);
                    Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, (byte[])offset, (String)"extra offset");
                }
                a.seek(0L);
                header = new byte[10];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 0, 8, 0, 0}, (byte[])header, (String)"LFH start");
                a.skipBytes(4);
                rest = new byte[17];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 111, 49, 92, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest, (String)"LFH rest");
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 0, -14, 5, 42, 1, 0, 0, 0, 0, -14, 5, 42, 1, 0, 0, 0}, (byte[])extra, (String)"LFH extra");
            }
        };
    }

    private static ZipOutputTest writeBigStoredEntryModeNever(boolean knownSize) {
        return (f, zos) -> {
            zos.setUseZip64(Zip64Mode.Never);
            Zip64RequiredException ex = (Zip64RequiredException)Assertions.assertThrows(Zip64RequiredException.class, () -> {
                byte[] buf = new byte[1000000];
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                if (knownSize) {
                    zae.setSize(5000000000L);
                    zae.setCrc(1546743632L);
                }
                zae.setMethod(0);
                zos.putArchiveEntry(zae);
                int j = 0;
                while ((long)j < 5000L) {
                    zos.write(buf);
                    ++j;
                }
                zos.closeArchiveEntry();
            }, (String)"expected a Zip64RequiredException");
            Assertions.assertTrue((boolean)ex.getMessage().startsWith("0's size"));
        };
    }

    private static ZipOutputTest writeSmallDeflatedEntryToFile(boolean knownSize) {
        return Zip64SupportIT.writeSmallDeflatedEntryToFile(knownSize, Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest writeSmallDeflatedEntryToFile(boolean knownSize, Zip64Mode mode) {
        return (f, zos) -> {
            if (mode != Zip64Mode.AsNeeded) {
                zos.setUseZip64(mode);
            }
            byte[] buf = new byte[1000000];
            ZipArchiveEntry zae = new ZipArchiveEntry("0");
            if (knownSize) {
                zae.setSize(1000000L);
            }
            zae.setMethod(8);
            zos.putArchiveEntry(zae);
            zos.write(buf);
            zos.closeArchiveEntry();
            zos.close();
            try (RandomAccessFile a = RandomAccessFileMode.READ_ONLY.create(f);){
                Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                byte[] header = new byte[12];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 20, 0, 20, 0, 0, 8, 8, 0}, (byte[])header);
                a.skipBytes(4);
                byte[] crc = new byte[4];
                a.readFully(crc);
                Assertions.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc);
                a.skipBytes(4);
                byte[] rest = new byte[23];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest);
                a.seek(0L);
                header = new byte[10];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 20, 0, 0, 8, 8, 0}, (byte[])header);
                a.skipBytes(4);
                crc = new byte[4];
                a.readFully(crc);
                Assertions.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc);
                a.skipBytes(4);
                rest = new byte[9];
                a.readFully(rest);
                boolean hasExtra = mode == Zip64Mode.AsNeeded && !knownSize;
                Assertions.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0, 1, 0, (byte)(!hasExtra ? 0 : 20), 0, 48}, (byte[])rest);
                if (hasExtra) {
                    byte[] extra = new byte[12];
                    a.readFully(extra);
                    Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 64, 66, 15, 0, 0, 0, 0, 0}, (byte[])extra);
                }
            }
        };
    }

    private static ZipOutputTest writeSmallDeflatedEntryToFileModeAlways(boolean knownSize) {
        return (f, zos) -> {
            zos.setUseZip64(Zip64Mode.Always);
            byte[] buf = new byte[1000000];
            ZipArchiveEntry zae = new ZipArchiveEntry("0");
            if (knownSize) {
                zae.setSize(1000000L);
            }
            zae.setMethod(8);
            zos.putArchiveEntry(zae);
            zos.write(buf);
            zos.closeArchiveEntry();
            zos.close();
            try (RandomAccessFile a = RandomAccessFileMode.READ_ONLY.create(f);){
                Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                byte[] header = new byte[12];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 0, 8, 8, 0}, (byte[])header, (String)"CDH start");
                a.skipBytes(4);
                byte[] crc = new byte[4];
                a.readFully(crc);
                Assertions.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc, (String)"CDH CRC");
                a.skipBytes(4);
                byte[] rest = new byte[23];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, 1, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 48}, (byte[])rest, (String)"CDH rest");
                byte[] extra = new byte[12];
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 28, 0, 64, 66, 15, 0, 0, 0, 0, 0}, (byte[])extra, (String)"CDH extra");
                a.skipBytes(8);
                byte[] offset = new byte[8];
                a.readFully(offset);
                Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, (byte[])offset, (String)"extra offset");
                a.seek(0L);
                header = new byte[10];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 0, 8, 8, 0}, (byte[])header, (String)"LFH start");
                a.skipBytes(4);
                crc = new byte[4];
                a.readFully(crc);
                Assertions.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc, (String)"LFH CRC");
                rest = new byte[13];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest, (String)"LFH rest");
                extra = new byte[12];
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 64, 66, 15, 0, 0, 0, 0, 0}, (byte[])extra, (String)"LFH extra");
            }
        };
    }

    private static ZipOutputTest writeSmallDeflatedEntryToStream(boolean knownSize, Zip64Mode mode) {
        return (f, zos) -> {
            if (mode != Zip64Mode.AsNeeded) {
                zos.setUseZip64(mode);
            }
            byte[] buf = new byte[1000000];
            ZipArchiveEntry zae = new ZipArchiveEntry("0");
            if (knownSize) {
                zae.setSize(1000000L);
            }
            zae.setMethod(8);
            zos.putArchiveEntry(zae);
            zos.write(buf);
            zos.closeArchiveEntry();
            zos.close();
            try (RandomAccessFile a = RandomAccessFileMode.READ_ONLY.create(f);){
                Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                long cfhPos = a.getFilePointer();
                byte[] header = new byte[12];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 20, 0, 20, 0, 8, 8, 8, 0}, (byte[])header);
                a.skipBytes(4);
                byte[] crc = new byte[4];
                a.readFully(crc);
                Assertions.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc);
                a.skipBytes(4);
                byte[] rest = new byte[23];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest);
                a.seek(cfhPos - 16L);
                byte[] dd = new byte[8];
                a.readFully(dd);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 7, 8, -98, -53, 121, 18}, (byte[])dd);
                a.skipBytes(4);
                dd = new byte[4];
                a.readFully(dd);
                Assertions.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0}, (byte[])dd);
                a.seek(0L);
                header = new byte[10];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 20, 0, 8, 8, 8, 0}, (byte[])header);
                a.skipBytes(4);
                rest = new byte[17];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 48}, (byte[])rest);
            }
        };
    }

    private static ZipOutputTest writeSmallDeflatedEntryToStreamModeAlways(boolean knownSize) {
        return (f, zos) -> {
            zos.setUseZip64(Zip64Mode.Always);
            byte[] buf = new byte[1000000];
            ZipArchiveEntry zae = new ZipArchiveEntry("0");
            if (knownSize) {
                zae.setSize(1000000L);
            }
            zae.setMethod(8);
            zos.putArchiveEntry(zae);
            zos.write(buf);
            zos.closeArchiveEntry();
            zos.close();
            try (RandomAccessFile a = RandomAccessFileMode.READ_ONLY.create(f);){
                Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                long cfhPos = a.getFilePointer();
                byte[] header = new byte[12];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 8, 8, 8, 0}, (byte[])header, (String)"CDH start");
                a.skipBytes(4);
                byte[] crc = new byte[4];
                a.readFully(crc);
                Assertions.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18}, (byte[])crc);
                a.skipBytes(4);
                byte[] rest = new byte[23];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, 1, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 48}, (byte[])rest, (String)"CDH rest");
                byte[] extra = new byte[12];
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 28, 0, 64, 66, 15, 0, 0, 0, 0, 0}, (byte[])extra, (String)"CDH extra");
                a.skipBytes(8);
                byte[] offset = new byte[8];
                a.readFully(offset);
                Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, (byte[])offset, (String)"extra offset");
                a.seek(cfhPos - 24L);
                byte[] dd = new byte[8];
                a.readFully(dd);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 7, 8, -98, -53, 121, 18}, (byte[])dd, (String)"DD");
                a.skipBytes(8);
                dd = new byte[8];
                a.readFully(dd);
                Assertions.assertArrayEquals((byte[])new byte[]{64, 66, 15, 0, 0, 0, 0, 0}, (byte[])dd, (String)"DD size");
                a.seek(0L);
                header = new byte[10];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 8, 8, 8, 0}, (byte[])header, (String)"LFH start");
                a.skipBytes(4);
                rest = new byte[17];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest, (String)"LFH rest");
                extra = new byte[20];
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (byte[])extra, (String)"LFH extra");
            }
        };
    }

    private static ZipOutputTest writeSmallStoredEntry(boolean knownSize) {
        return Zip64SupportIT.writeSmallStoredEntry(knownSize, Zip64Mode.AsNeeded);
    }

    private static ZipOutputTest writeSmallStoredEntry(boolean knownSize, Zip64Mode mode) {
        return (f, zos) -> {
            if (mode != Zip64Mode.AsNeeded) {
                zos.setUseZip64(mode);
            }
            byte[] buf = new byte[1000000];
            ZipArchiveEntry zae = new ZipArchiveEntry("0");
            if (knownSize) {
                zae.setSize(1000000L);
                zae.setCrc(309971870L);
            }
            zae.setMethod(0);
            zos.putArchiveEntry(zae);
            zos.write(buf);
            zos.closeArchiveEntry();
            zos.close();
            try (RandomAccessFile a = RandomAccessFileMode.READ_ONLY.create(f);){
                Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                byte[] header = new byte[12];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 20, 0, 10, 0, 0, 8, 0, 0}, (byte[])header, (String)"CDH start");
                a.skipBytes(4);
                byte[] rest = new byte[31];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18, 64, 66, 15, 0, 64, 66, 15, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, (byte[])rest, (String)"CDH rest");
                boolean hasExtra = mode == Zip64Mode.Always || mode == Zip64Mode.AsNeeded && !knownSize;
                a.seek(0L);
                header = new byte[10];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 10, 0, 0, 8, 0, 0}, (byte[])header, (String)"LFH start");
                a.skipBytes(4);
                rest = new byte[17];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18, 64, 66, 15, 0, 64, 66, 15, 0, 1, 0, (byte)(!hasExtra ? 0 : 20), 0, 48}, (byte[])rest, (String)"LFH rest");
                if (hasExtra) {
                    byte[] extra = new byte[20];
                    a.readFully(extra);
                    Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 64, 66, 15, 0, 0, 0, 0, 0, 64, 66, 15, 0, 0, 0, 0, 0}, (byte[])extra, (String)"ZIP64 extra field");
                }
            }
        };
    }

    private static ZipOutputTest writeSmallStoredEntryModeAlways(boolean knownSize) {
        return (f, zos) -> {
            zos.setUseZip64(Zip64Mode.Always);
            byte[] buf = new byte[1000000];
            ZipArchiveEntry zae = new ZipArchiveEntry("0");
            if (knownSize) {
                zae.setSize(1000000L);
                zae.setCrc(309971870L);
            }
            zae.setMethod(0);
            zos.putArchiveEntry(zae);
            zos.write(buf);
            zos.closeArchiveEntry();
            zos.close();
            try (RandomAccessFile a = RandomAccessFileMode.READ_ONLY.create(f);){
                Zip64SupportIT.getLengthAndPositionAtCentralDirectory(a);
                byte[] header = new byte[12];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 1, 2, 45, 0, 45, 0, 0, 8, 0, 0}, (byte[])header, (String)"CDH start");
                a.skipBytes(4);
                byte[] rest = new byte[31];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 48}, (byte[])rest, (String)"CDH rest");
                byte[] extra = new byte[28];
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 28, 0, 64, 66, 15, 0, 0, 0, 0, 0, 64, 66, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (byte[])extra, (String)"CDH extra");
                a.seek(0L);
                header = new byte[10];
                a.readFully(header);
                Assertions.assertArrayEquals((byte[])new byte[]{80, 75, 3, 4, 45, 0, 0, 8, 0, 0}, (byte[])header, (String)"LFH start");
                a.skipBytes(4);
                rest = new byte[17];
                a.readFully(rest);
                Assertions.assertArrayEquals((byte[])new byte[]{-98, -53, 121, 18, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, 20, 0, 48}, (byte[])rest, (String)"LFH rest");
                extra = new byte[20];
                a.readFully(extra);
                Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 16, 0, 64, 66, 15, 0, 0, 0, 0, 0, 64, 66, 15, 0, 0, 0, 0, 0}, (byte[])extra, (String)"LFH extra");
            }
        };
    }

    private File buildZipWithZip64Mode(String fileName, Zip64Mode zip64Mode, File inputFile) throws Throwable {
        File outputFile = Zip64SupportIT.getTempFile(fileName);
        outputFile.createNewFile();
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)));){
            zipArchiveOutputStream.setUseZip64(zip64Mode);
            zipArchiveOutputStream.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
            zipArchiveOutputStream.putArchiveEntry(new ZipArchiveEntry("input.bin"));
            Files.copy(inputFile.toPath(), (OutputStream)zipArchiveOutputStream);
            zipArchiveOutputStream.closeArchiveEntry();
        }
        return outputFile;
    }

    @Test
    public void testRead100KFilesGeneratedBy7ZIPUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFileGeneratedBy7ZIP());
    }

    @Test
    public void testRead100KFilesGeneratedBy7ZIPUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFileGeneratedBy7ZIP());
    }

    @Test
    public void testRead100KFilesGeneratedByJava7JarUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFileGeneratedByJava7Jar());
    }

    @Test
    public void testRead100KFilesGeneratedByJava7JarUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFileGeneratedByJava7Jar());
    }

    @Test
    public void testRead100KFilesGeneratedByPKZipUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFileGeneratedByPKZip());
    }

    @Test
    public void testRead100KFilesGeneratedByPKZipUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFileGeneratedByPKZip());
    }

    @Test
    public void testRead100KFilesGeneratedByWinCFUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFileGeneratedByWinCF());
    }

    @Test
    public void testRead100KFilesGeneratedByWinCFUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFileGeneratedByWinCF());
    }

    @Test
    public void testRead100KFilesGeneratedByWinZIPUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFileGeneratedByWinZIP());
    }

    @Test
    public void testRead100KFilesGeneratedByWinZIPUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFileGeneratedByWinZIP());
    }

    @Test
    public void testRead100KFilesUsingInputStream() throws Throwable {
        Zip64SupportIT.read100KFilesImpl(Zip64SupportIT.get100KFileFile());
    }

    @Test
    public void testRead100KFilesUsingZipFile() throws Throwable {
        Zip64SupportIT.read100KFilesUsingZipFileImpl(Zip64SupportIT.get100KFileFile());
    }

    @Test
    public void testRead3EntriesCreatingBigArchiveFileUsingZipFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("read3EntriesCreatingBigArchiveFileUsingZipFile", (f, zos) -> {
            Zip64SupportIT.write3EntriesCreatingBigArchiveToStream(zos);
            ZipFile zf = null;
            try {
                zf = ((ZipFile.Builder)ZipFile.builder().setFile(f)).get();
                int idx = 0;
                Enumeration e = zf.getEntriesInPhysicalOrder();
                while (e.hasMoreElements()) {
                    ZipArchiveEntry zae = (ZipArchiveEntry)e.nextElement();
                    Assertions.assertEquals((Object)String.valueOf(idx), (Object)zae.getName());
                    if (idx++ < 2) {
                        Assertions.assertEquals((long)2500000000L, (long)zae.getSize());
                        continue;
                    }
                    Assertions.assertEquals((long)1L, (long)zae.getSize());
                    InputStream i = zf.getInputStream(zae);
                    try {
                        Assertions.assertNotNull((Object)i);
                        Assertions.assertEquals((int)42, (int)i.read());
                    }
                    finally {
                        if (i == null) continue;
                        i.close();
                    }
                }
            }
            catch (Throwable throwable) {
                ZipFile.closeQuietly(zf);
                throw throwable;
            }
            ZipFile.closeQuietly((ZipFile)zf);
        }, true);
    }

    @Test
    public void testRead5GBOfZerosGeneratedBy7ZIPUsingInputStream() throws Throwable {
        Zip64SupportIT.read5GBOfZerosImpl(Zip64SupportIT.get5GBZerosFileGeneratedBy7ZIP(), "5GB_of_Zeros");
    }

    @Test
    public void testRead5GBOfZerosGeneratedBy7ZIPUsingZipFile() throws Throwable {
        Zip64SupportIT.read5GBOfZerosUsingZipFileImpl(Zip64SupportIT.get5GBZerosFileGeneratedBy7ZIP(), "5GB_of_Zeros");
    }

    @Test
    public void testRead5GBOfZerosGeneratedByJava7JarUsingInputStream() throws Throwable {
        Zip64SupportIT.read5GBOfZerosImpl(Zip64SupportIT.get5GBZerosFileGeneratedByJava7Jar(), "5GB_of_Zeros");
    }

    @Test
    public void testRead5GBOfZerosGeneratedByJava7JarUsingZipFile() throws Throwable {
        Zip64SupportIT.read5GBOfZerosUsingZipFileImpl(Zip64SupportIT.get5GBZerosFileGeneratedByJava7Jar(), "5GB_of_Zeros");
    }

    @Test
    public void testRead5GBOfZerosGeneratedByPKZipUsingInputStream() throws Throwable {
        Zip64SupportIT.read5GBOfZerosImpl(Zip64SupportIT.get5GBZerosFileGeneratedByPKZip(), "zip6/5GB_of_Zeros");
    }

    @Test
    public void testRead5GBOfZerosGeneratedByPKZipUsingZipFile() throws Throwable {
        Zip64SupportIT.read5GBOfZerosUsingZipFileImpl(Zip64SupportIT.get5GBZerosFileGeneratedByPKZip(), "zip6/5GB_of_Zeros");
    }

    @Test
    public void testRead5GBOfZerosGeneratedByWinZIPUsingInputStream() throws Throwable {
        Zip64SupportIT.read5GBOfZerosImpl(Zip64SupportIT.get5GBZerosFileGeneratedByWinZIP(), "5GB_of_Zeros");
    }

    @Test
    public void testRead5GBOfZerosGeneratedByWinZIPUsingZipFile() throws Throwable {
        Zip64SupportIT.read5GBOfZerosUsingZipFileImpl(Zip64SupportIT.get5GBZerosFileGeneratedByWinZIP(), "5GB_of_Zeros");
    }

    @Test
    public void testRead5GBOfZerosUsingInputStream() throws Throwable {
        Zip64SupportIT.read5GBOfZerosImpl(Zip64SupportIT.get5GBZerosFile(), "5GB_of_Zeros");
    }

    @Test
    public void testRead5GBOfZerosUsingZipFile() throws Throwable {
        Zip64SupportIT.read5GBOfZerosUsingZipFileImpl(Zip64SupportIT.get5GBZerosFile(), "5GB_of_Zeros");
    }

    @Test
    public void testReadSelfGenerated100KFilesUsingZipFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("readSelfGenerated100KFilesUsingZipFile()", (f, zos) -> {
            Zip64SupportIT.write100KFilesToStream(zos);
            Zip64SupportIT.read100KFilesUsingZipFileImpl(f);
        }, true);
    }

    @Test
    public void testWrite100KFilesFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesFile", Zip64SupportIT.write100KFiles(), true);
    }

    @Test
    public void testWrite100KFilesFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesFileModeAlways", Zip64SupportIT.write100KFiles(Zip64Mode.Always), true);
    }

    @Test
    public void testWrite100KFilesFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesFileModeNever", write100KFilesModeNever, true);
    }

    @Test
    public void testWrite100KFilesStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesStream", Zip64SupportIT.write100KFiles(), false);
    }

    @Test
    public void testWrite100KFilesStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesStreamModeAlways", Zip64SupportIT.write100KFiles(Zip64Mode.Always), false);
    }

    @Test
    public void testWrite100KFilesStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write100KFilesStreamModeNever", write100KFilesModeNever, false);
    }

    @Test
    public void testWrite3EntriesCreatingBigArchiveFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveFile", Zip64SupportIT.write3EntriesCreatingBigArchive(), true);
    }

    @Test
    public void testWrite3EntriesCreatingBigArchiveFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveFileModeAlways", Zip64SupportIT.write3EntriesCreatingBigArchive(Zip64Mode.Always), true);
    }

    @Test
    public void testWrite3EntriesCreatingBigArchiveFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveFileModeNever", write3EntriesCreatingBigArchiveModeNever, true);
    }

    @Test
    public void testWrite3EntriesCreatingBigArchiveStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveStream", Zip64SupportIT.write3EntriesCreatingBigArchive(), false);
    }

    @Test
    public void testWrite3EntriesCreatingBigArchiveStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveStreamModeAlways", Zip64SupportIT.write3EntriesCreatingBigArchive(Zip64Mode.Always), false);
    }

    @Test
    public void testWrite3EntriesCreatingBigArchiveStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingBigArchiveStreamModeNever", write3EntriesCreatingBigArchiveModeNever, false);
    }

    @Test
    public void testWrite3EntriesCreatingManySplitArchiveFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingManySplitArchiveFileModeAlways", Zip64SupportIT.write3EntriesCreatingBigArchive(Zip64Mode.Always, true), true, 65536L);
    }

    @Test
    public void testWrite3EntriesCreatingManySplitArchiveFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("write3EntriesCreatingManySplitArchiveFileModeNever", write3EntriesCreatingBigArchiveModeNever, true, 65536L);
    }

    @Test
    public void testWriteAndRead5GBOfZerosUsingZipFile() throws Throwable {
        File f = null;
        try {
            f = Zip64SupportIT.write5GBZerosFile("writeAndRead5GBOfZerosUsingZipFile");
            Zip64SupportIT.read5GBOfZerosUsingZipFileImpl(f, "5GB_of_Zeros");
        }
        finally {
            if (f != null) {
                AbstractTest.forceDelete(f);
            }
        }
    }

    @Test
    public void testWriteBigDeflatedEntryKnownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToFile", Zip64SupportIT.writeBigDeflatedEntryToFile(true), true);
    }

    @Test
    public void testWriteBigDeflatedEntryKnownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToFileModeAlways", Zip64SupportIT.writeBigDeflatedEntryToFile(true, Zip64Mode.Always), true);
    }

    @Test
    public void testWriteBigDeflatedEntryKnownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToFileModeNever", Zip64SupportIT.writeBigDeflatedEntryToFileModeNever(true), true);
    }

    @Test
    public void testWriteBigDeflatedEntryKnownSizeToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToStream", Zip64SupportIT.writeBigDeflatedEntryToStream(true, Zip64Mode.AsNeeded), false);
    }

    @Test
    public void testWriteBigDeflatedEntryKnownSizeToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToStreamModeAlways", Zip64SupportIT.writeBigDeflatedEntryToStream(true, Zip64Mode.Always), false);
    }

    @Test
    public void testWriteBigDeflatedEntryKnownSizeToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryKnownSizeToStreamModeNever", (f, zos) -> {
            zos.setUseZip64(Zip64Mode.Never);
            Zip64RequiredException ex = (Zip64RequiredException)Assertions.assertThrows(Zip64RequiredException.class, () -> {
                ZipArchiveEntry zae = new ZipArchiveEntry("0");
                zae.setSize(5000000000L);
                zae.setMethod(8);
                zos.putArchiveEntry(zae);
            }, (String)"expected a Zip64RequiredException");
            Assertions.assertTrue((boolean)ex.getMessage().startsWith("0's size"));
        }, false);
    }

    @Test
    public void testWriteBigDeflatedEntryUnknownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToFile", Zip64SupportIT.writeBigDeflatedEntryToFile(false), true);
    }

    @Test
    public void testWriteBigDeflatedEntryUnknownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToFileModeAlways", Zip64SupportIT.writeBigDeflatedEntryToFile(false, Zip64Mode.Always), true);
    }

    @Test
    public void testWriteBigDeflatedEntryUnknownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToFileModeNever", Zip64SupportIT.writeBigDeflatedEntryToFileModeNever(false), true);
    }

    @Test
    public void testWriteBigDeflatedEntryUnknownSizeToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToStream", Zip64SupportIT.writeBigDeflatedEntryUnknownSizeToStream(Zip64Mode.AsNeeded), false);
    }

    @Test
    public void testWriteBigDeflatedEntryUnknownSizeToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToStreamModeAlways", Zip64SupportIT.writeBigDeflatedEntryToStream(false, Zip64Mode.Always), false);
    }

    @Test
    public void testWriteBigDeflatedEntryUnknownSizeToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigDeflatedEntryUnknownSizeToStreamModeNever", Zip64SupportIT.writeBigDeflatedEntryUnknownSizeToStream(Zip64Mode.Never), false);
    }

    @Test
    public void testWriteBigStoredEntryKnownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryKnownSizeToFile", Zip64SupportIT.writeBigStoredEntry(true), true);
    }

    @Test
    public void testWriteBigStoredEntryKnownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryKnownSizeToFileModeAlways", Zip64SupportIT.writeBigStoredEntry(true, Zip64Mode.Always), true);
    }

    @Test
    public void testWriteBigStoredEntryKnownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryKnownSizeToFileModeNever", Zip64SupportIT.writeBigStoredEntryModeNever(true), true);
    }

    @Test
    public void testWriteBigStoredEntryToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryToStream", Zip64SupportIT.writeBigStoredEntry(true), false);
    }

    @Test
    public void testWriteBigStoredEntryToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryToStreamModeAlways", Zip64SupportIT.writeBigStoredEntry(true, Zip64Mode.Always), false);
    }

    @Test
    public void testWriteBigStoredEntryToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryToStreamModeNever", Zip64SupportIT.writeBigStoredEntryModeNever(true), false);
    }

    @Test
    public void testWriteBigStoredEntryUnknownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryUnknownSizeToFile", Zip64SupportIT.writeBigStoredEntry(false), true);
    }

    @Test
    public void testWriteBigStoredEntryUnknownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryUnknownSizeToFileModeAlways", Zip64SupportIT.writeBigStoredEntry(false, Zip64Mode.Always), true);
    }

    @Test
    public void testWriteBigStoredEntryUnknownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeBigStoredEntryUnknownSizeToFileModeNever", Zip64SupportIT.writeBigStoredEntryModeNever(false), true);
    }

    @Test
    public void testWriteSmallDeflatedEntryKnownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToFile", Zip64SupportIT.writeSmallDeflatedEntryToFile(true), true);
    }

    @Test
    public void testWriteSmallDeflatedEntryKnownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToFileModeAlways", Zip64SupportIT.writeSmallDeflatedEntryToFileModeAlways(true), true);
    }

    @Test
    public void testWriteSmallDeflatedEntryKnownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToFileModeNever", Zip64SupportIT.writeSmallDeflatedEntryToFile(true, Zip64Mode.Never), true);
    }

    @Test
    public void testWriteSmallDeflatedEntryKnownSizeToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToStream", Zip64SupportIT.writeSmallDeflatedEntryToStream(true, Zip64Mode.AsNeeded), false);
    }

    @Test
    public void testWriteSmallDeflatedEntryKnownSizeToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToStreamModeAlways", Zip64SupportIT.writeSmallDeflatedEntryToStreamModeAlways(true), false);
    }

    @Test
    public void testWriteSmallDeflatedEntryKnownSizeToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryKnownSizeToStreamModeNever", Zip64SupportIT.writeSmallDeflatedEntryToStream(true, Zip64Mode.Never), false);
    }

    @Test
    public void testWriteSmallDeflatedEntryUnknownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToFile", Zip64SupportIT.writeSmallDeflatedEntryToFile(false), true);
    }

    @Test
    public void testWriteSmallDeflatedEntryUnknownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToFileModeAlways", Zip64SupportIT.writeSmallDeflatedEntryToFileModeAlways(false), true);
    }

    @Test
    public void testWriteSmallDeflatedEntryUnknownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToFileModeNever", Zip64SupportIT.writeSmallDeflatedEntryToFile(false, Zip64Mode.Never), true);
    }

    @Test
    public void testWriteSmallDeflatedEntryUnknownSizeToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToStream", Zip64SupportIT.writeSmallDeflatedEntryToStream(false, Zip64Mode.AsNeeded), false);
    }

    @Test
    public void testWriteSmallDeflatedEntryUnknownSizeToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToStreamModeAlways", Zip64SupportIT.writeSmallDeflatedEntryToStreamModeAlways(false), false);
    }

    @Test
    public void testWriteSmallDeflatedEntryUnknownSizeToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallDeflatedEntryUnknownSizeToStreamModeNever", Zip64SupportIT.writeSmallDeflatedEntryToStream(false, Zip64Mode.Never), false);
    }

    @Test
    public void testWriteSmallStoredEntryKnownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryKnownSizeToFile", Zip64SupportIT.writeSmallStoredEntry(true), true);
    }

    @Test
    public void testWriteSmallStoredEntryKnownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryKnownSizeToFileModeAlways", Zip64SupportIT.writeSmallStoredEntryModeAlways(true), true);
    }

    @Test
    public void testWriteSmallStoredEntryKnownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryKnownSizeToFileModeNever", Zip64SupportIT.writeSmallStoredEntry(true, Zip64Mode.Never), true);
    }

    @Test
    public void testWriteSmallStoredEntryToStream() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryToStream", Zip64SupportIT.writeSmallStoredEntry(true), false);
    }

    @Test
    public void testWriteSmallStoredEntryToStreamModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryToStreamModeAlways", Zip64SupportIT.writeSmallStoredEntryModeAlways(true), false);
    }

    @Test
    public void testWriteSmallStoredEntryToStreamModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryToStreamModeNever", Zip64SupportIT.writeSmallStoredEntry(true, Zip64Mode.Never), false);
    }

    @Test
    public void testWriteSmallStoredEntryUnknownSizeToFile() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryUnknownSizeToFile", Zip64SupportIT.writeSmallStoredEntry(false), true);
    }

    @Test
    public void testWriteSmallStoredEntryUnknownSizeToFileModeAlways() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryUnknownSizeToFileModeAlways", Zip64SupportIT.writeSmallStoredEntryModeAlways(false), true);
    }

    @Test
    public void testWriteSmallStoredEntryUnknownSizeToFileModeNever() throws Throwable {
        Zip64SupportIT.withTemporaryArchive("writeSmallStoredEntryUnknownSizeToFileModeNever", Zip64SupportIT.writeSmallStoredEntry(false, Zip64Mode.Never), true);
    }

    @Test
    public void testZip64ModeAlwaysWithCompatibility() throws Throwable {
        File inputFile = AbstractTest.getFile("test3.xml");
        File zipUsingModeAlwaysWithCompatibility = this.buildZipWithZip64Mode("testZip64ModeAlwaysWithCompatibility-output-1", Zip64Mode.AlwaysWithCompatibility, inputFile);
        ZipFile zipFileWithAlwaysWithCompatibility = ((ZipFile.Builder)ZipFile.builder().setFile(zipUsingModeAlwaysWithCompatibility)).get();
        ZipArchiveEntry entry = (ZipArchiveEntry)zipFileWithAlwaysWithCompatibility.getEntries().nextElement();
        for (ZipExtraField extraField : entry.getExtraFields()) {
            if (!(extraField instanceof Zip64ExtendedInformationExtraField)) continue;
            Assertions.assertNull((Object)((Zip64ExtendedInformationExtraField)extraField).getRelativeHeaderOffset());
            Assertions.assertNull((Object)((Zip64ExtendedInformationExtraField)extraField).getDiskStartNumber());
        }
        File zipUsingModeAlways = this.buildZipWithZip64Mode("testZip64ModeAlwaysWithCompatibility-output-2", Zip64Mode.Always, inputFile);
        ZipFile zipFileWithAlways = ((ZipFile.Builder)ZipFile.builder().setFile(zipUsingModeAlways)).get();
        entry = (ZipArchiveEntry)zipFileWithAlways.getEntries().nextElement();
        for (ZipExtraField extraField : entry.getExtraFields()) {
            if (!(extraField instanceof Zip64ExtendedInformationExtraField)) continue;
            Assertions.assertNotNull((Object)((Zip64ExtendedInformationExtraField)extraField).getRelativeHeaderOffset());
            Assertions.assertNotNull((Object)((Zip64ExtendedInformationExtraField)extraField).getDiskStartNumber());
        }
    }

    static interface ZipOutputTest {
        public void test(File var1, ZipArchiveOutputStream var2) throws IOException;
    }
}

