/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.tukaani.xz.LZMA2Options;

public class SevenZMethodConfigurationTest {
    @Test
    public void testShouldAllowLZMA2OptionsForLZMA() {
        Assertions.assertNotNull((Object)new SevenZMethodConfiguration(SevenZMethod.LZMA, (Object)new LZMA2Options()).getOptions());
    }

    @Test
    public void testShouldAllowLZMA2OptionsForLZMA2() {
        Assertions.assertNotNull((Object)new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)new LZMA2Options()).getOptions());
    }

    @Test
    public void testShouldAllowNullOptions() {
        Assertions.assertNull((Object)new SevenZMethodConfiguration(SevenZMethod.LZMA2, null).getOptions());
    }

    @Test
    public void testShouldAllowNumberForBzip2() {
        Assertions.assertNotNull((Object)new SevenZMethodConfiguration(SevenZMethod.BZIP2, (Object)42).getOptions());
    }

    @Test
    public void testShouldAllowNumberForDeflate() {
        Assertions.assertNotNull((Object)new SevenZMethodConfiguration(SevenZMethod.DEFLATE, (Object)42).getOptions());
    }

    @Test
    public void testShouldAllowNumberForLZMA() {
        Assertions.assertNotNull((Object)new SevenZMethodConfiguration(SevenZMethod.LZMA, (Object)42).getOptions());
    }

    @Test
    public void testShouldAllowNumberForLZMA2() {
        Assertions.assertNotNull((Object)new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)42).getOptions());
    }

    @Test
    public void testShouldNotAllowStringOptionsForLZMA() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SevenZMethodConfiguration(SevenZMethod.LZMA, (Object)""));
    }

    @Test
    public void testShouldNotAllowStringOptionsForLZMA2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)""));
    }
}

