/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate64;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HuffmanDecoderTest {
    @Test
    public void testDecodeFixedHuffmanBlockWithMemoryLookup() throws Exception {
        byte[] data = new byte[]{-13, 72, -51, -55, -55, 87, 8, -49, 47, -54, 73, -31, 34, -122, 13, -8};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[100];
        int len = decoder.decode(result);
        Assertions.assertEquals((int)48, (int)len);
        Assertions.assertEquals((Object)"Hello World\nHello World\nHello World\nHello World\n", (Object)new String(result, 0, len));
    }

    @Test
    public void testDecodeFixedHuffmanBlockWithMemoryLookupInExactBuffer() throws Exception {
        byte[] data = new byte[]{-13, 72, -51, -55, -55, 87, 8, -49, 47, -54, 73, -31, 34, -122, 13, -8};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[48];
        int len = decoder.decode(result);
        Assertions.assertEquals((int)48, (int)len);
        Assertions.assertEquals((Object)"Hello World\nHello World\nHello World\nHello World\n", (Object)new String(result, 0, len));
        len = decoder.decode(result);
        Assertions.assertEquals((int)-1, (int)len);
    }

    @Test
    public void testDecodeFixedHuffmanBlockWithMemoryLookupInSmallBuffer() throws Exception {
        byte[] data = new byte[]{-13, 72, -51, -55, -55, 87, 8, -49, 47, -54, 73, -31, 34, -122, 13, -8};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[30];
        int len = decoder.decode(result);
        Assertions.assertEquals((int)30, (int)len);
        Assertions.assertEquals((Object)"Hello World\nHello World\nHello ", (Object)new String(result, 0, len));
        len = decoder.decode(result);
        Assertions.assertEquals((int)18, (int)len);
        Assertions.assertEquals((Object)"World\nHello World\n", (Object)new String(result, 0, len));
    }

    @Test
    public void testDecodeSimpleFixedHuffmanBlock() throws Exception {
        byte[] data = new byte[]{-13, 72, -51, -55, -55, 87, 8, -49, 47, -54, 73, 1, -4};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[100];
        int len = decoder.decode(result);
        Assertions.assertEquals((int)11, (int)len);
        Assertions.assertEquals((Object)"Hello World", (Object)new String(result, 0, len));
    }

    @Test
    public void testDecodeSimpleFixedHuffmanBlockToSmallBuffer() throws Exception {
        byte[] data = new byte[]{-13, 72, -51, -55, -55, 87, 8, -49, 47, -54, 73, 1, -4};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[10];
        int len = decoder.decode(result);
        Assertions.assertEquals((int)10, (int)len);
        Assertions.assertEquals((Object)"Hello Worl", (Object)new String(result, 0, len));
        len = decoder.decode(result);
        Assertions.assertEquals((int)1, (int)len);
        Assertions.assertEquals((Object)"d", (Object)new String(result, 0, len));
    }

    @Test
    public void testDecodeUncompressedBlock() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[100];
        int len = decoder.decode(result);
        Assertions.assertEquals((int)11, (int)len);
        Assertions.assertEquals((Object)"Hello World", (Object)new String(result, 0, len));
    }

    @Test
    public void testDecodeUncompressedBlockWithInvalidLenNLenValue() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -2, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[100];
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> {
            int len = decoder.decode(result);
            Assertions.fail((String)("Should have failed but returned " + len + " entries: " + Arrays.toString(Arrays.copyOf(result, len))));
        });
        Assertions.assertEquals((Object)"Illegal LEN / NLEN values", (Object)e.getMessage());
    }
}

