/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOMethodsTest
extends AbstractTest {
    private static final int bytesToTest = 50;
    private static final byte[] byteTest = new byte[50];

    private void compareReads(String archiverName) throws Exception {
        int bytes;
        int b;
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        ByteArrayOutputStream out3 = new ByteArrayOutputStream();
        Path file = this.createSingleEntryArchive(archiverName);
        InputStream is1 = Files.newInputStream(file, new OpenOption[0]);
        ArchiveInputStream ais1 = this.factory.createArchiveInputStream(archiverName, is1);
        ArchiveEntry nextEntry = ais1.getNextEntry();
        Assertions.assertNotNull((Object)nextEntry);
        byte[] buff = new byte[10];
        long size = nextEntry.getSize();
        if (size != -1L) {
            Assertions.assertTrue((size > 0L ? 1 : 0) != 0, (String)("Size should be > 0, found: " + size));
        }
        InputStream is2 = Files.newInputStream(file, new OpenOption[0]);
        ArchiveInputStream ais2 = this.factory.createArchiveInputStream(archiverName, is2);
        ArchiveEntry nextEntry2 = ais2.getNextEntry();
        Assertions.assertNotNull((Object)nextEntry2);
        Assertions.assertEquals((long)size, (long)nextEntry2.getSize(), (String)"Expected same entry size");
        InputStream is3 = Files.newInputStream(file, new OpenOption[0]);
        ArchiveInputStream ais3 = this.factory.createArchiveInputStream(archiverName, is3);
        ArchiveEntry nextEntry3 = ais3.getNextEntry();
        Assertions.assertNotNull((Object)nextEntry3);
        Assertions.assertEquals((long)size, (long)nextEntry3.getSize(), (String)"Expected same entry size");
        while ((b = ais1.read()) != -1) {
            ((OutputStream)out1).write(b);
        }
        ais1.close();
        while ((bytes = ais2.read(buff)) > 0) {
            ((OutputStream)out2).write(buff, 0, bytes);
        }
        ais2.close();
        while ((bytes = ais3.read(buff, 0, buff.length)) > 0) {
            ((OutputStream)out3).write(buff, 0, bytes);
        }
        ais3.close();
        Assertions.assertEquals((int)((Object)out1).toString().length(), (int)((Object)out2).toString().length(), (String)"out1Len!=out2Len");
        Assertions.assertEquals((int)((Object)out1).toString().length(), (int)((Object)out3).toString().length(), (String)"out1Len!=out3Len");
        Assertions.assertEquals((Object)((Object)out1).toString(), (Object)((Object)out2).toString(), (String)"out1!=out2");
        Assertions.assertEquals((Object)((Object)out1).toString(), (Object)((Object)out3).toString(), (String)"out1!=out3");
    }

    private void compareWrites(String archiverName, ArchiveEntry entry) throws Exception {
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        ByteArrayOutputStream out3 = new ByteArrayOutputStream();
        ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream(archiverName, (OutputStream)out1);
        aos1.putArchiveEntry(entry);
        ArchiveOutputStream aos2 = this.factory.createArchiveOutputStream(archiverName, (OutputStream)out2);
        aos2.putArchiveEntry(entry);
        ArchiveOutputStream aos3 = this.factory.createArchiveOutputStream(archiverName, (OutputStream)out3);
        aos3.putArchiveEntry(entry);
        for (byte element : byteTest) {
            aos1.write((int)element);
        }
        aos1.closeArchiveEntry();
        aos1.close();
        aos2.write(byteTest);
        aos2.closeArchiveEntry();
        aos2.close();
        aos3.write(byteTest, 0, byteTest.length);
        aos3.closeArchiveEntry();
        aos3.close();
        Assertions.assertEquals((long)aos1.getBytesWritten(), (long)aos2.getBytesWritten(), (String)"aos1Bytes!=aos2Bytes");
        Assertions.assertEquals((long)aos1.getBytesWritten(), (long)aos3.getBytesWritten(), (String)"aos1Bytes!=aos3Bytes");
        Assertions.assertEquals((int)((Object)out1).toString().length(), (int)((Object)out2).toString().length(), (String)"out1Len!=out2Len");
        Assertions.assertEquals((int)((Object)out1).toString().length(), (int)((Object)out3).toString().length(), (String)"out1Len!=out2Len");
        Assertions.assertEquals((Object)((Object)out1).toString(), (Object)((Object)out2).toString(), (String)"out1!=out2");
        Assertions.assertEquals((Object)((Object)out1).toString(), (Object)((Object)out3).toString(), (String)"out1!=out3");
    }

    @Test
    public void testReadAr() throws Exception {
        this.compareReads("ar");
    }

    @Test
    public void testReadCpio() throws Exception {
        this.compareReads("cpio");
    }

    @Test
    public void testReadJar() throws Exception {
        this.compareReads("jar");
    }

    @Test
    public void testReadTar() throws Exception {
        this.compareReads("tar");
    }

    @Test
    public void testReadZip() throws Exception {
        this.compareReads("zip");
    }

    @Test
    public void testWriteAr() throws Exception {
        this.compareWrites("ar", (ArchiveEntry)new ArArchiveEntry("dummy", 50L));
    }

    @Test
    public void testWriteCpio() throws Exception {
        CpioArchiveEntry entry = new CpioArchiveEntry("dummy", 50L);
        this.compareWrites("cpio", (ArchiveEntry)entry);
    }

    @Test
    public void testWriteJar() throws Exception {
        JarArchiveEntry entry = new JarArchiveEntry("dummy");
        this.compareWrites("jar", (ArchiveEntry)entry);
    }

    @Test
    public void testWriteTar() throws Exception {
        TarArchiveEntry entry = new TarArchiveEntry("dummy");
        entry.setSize(50L);
        this.compareWrites("tar", (ArchiveEntry)entry);
    }

    @Test
    public void testWriteZip() throws Exception {
        ZipArchiveEntry entry = new ZipArchiveEntry("dummy");
        this.compareWrites("zip", (ArchiveEntry)entry);
    }

    static {
        for (int i = 0; i < byteTest.length; i += 2) {
            IOMethodsTest.byteTest[i] = (byte)i;
            IOMethodsTest.byteTest[i + 1] = (byte)(-i);
        }
    }
}

