/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.IOException;
import org.apache.commons.compress.utils.ParsingUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ParsingUtilsTest {
    @ParameterizedTest
    @ValueSource(strings={"-21474836481", "x.x", "9e999", "1.1", "one", "21474836471"})
    public void testParseIntValueInvalidValues(String value) {
        Assertions.assertThrows(IOException.class, () -> ParsingUtils.parseIntValue((String)value, (int)10));
    }

    @ParameterizedTest
    @ValueSource(strings={"-2147483648", "-1", "1", "123456", "2147483647"})
    public void testParseIntValueValidValues(String value) throws Exception {
        Assertions.assertEquals((long)Long.parseLong(value), (long)ParsingUtils.parseIntValue((String)value, (int)10));
    }

    @ParameterizedTest
    @ValueSource(strings={"-92233720368547758081", "x.x", "9e999", "1.1", "one", "92233720368547758071"})
    public void testParseLongValueInvalidValues(String value) {
        Assertions.assertThrows(IOException.class, () -> ParsingUtils.parseLongValue((String)value, (int)10));
    }

    @ParameterizedTest
    @ValueSource(strings={"-9223372036854775808", "-1", "1", "12345678901234", "9223372036854775807"})
    public void testParseLongValueValidValues(String value) throws Exception {
        Assertions.assertEquals((long)Long.parseLong(value), (long)ParsingUtils.parseLongValue((String)value, (int)10));
    }
}

