/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.pack200.PopulationCodec;
import org.apache.commons.compress.harmony.pack200.RunCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class RunCodecTest {
    static Stream<Arguments> runCodec() {
        return Stream.of(Arguments.of((Object[])new Object[]{0, Codec.SIGNED5, Codec.UDELTA5, "Should not allow a k value of 0"}), Arguments.of((Object[])new Object[]{10, null, Codec.UDELTA5, "Should not allow a null codec"}), Arguments.of((Object[])new Object[]{10, Codec.UDELTA5, null, "Should not allow a null codec"}), Arguments.of((Object[])new Object[]{10, null, null, "Should not allow a null codec"}));
    }

    @Test
    public void testDecode() throws Exception {
        RunCodec runCodec = new RunCodec(1, (Codec)Codec.UNSIGNED5, (Codec)Codec.BYTE1);
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[]{-64, 0, -64, 0});
        Assertions.assertEquals((int)192, (int)runCodec.decode((InputStream)bais));
        Assertions.assertEquals((int)192, (int)runCodec.decode((InputStream)bais));
        Assertions.assertEquals((int)0, (int)runCodec.decode((InputStream)bais));
        Assertions.assertEquals((int)0, (int)bais.available());
        runCodec = new RunCodec(1, (Codec)Codec.BYTE1, (Codec)Codec.UNSIGNED5);
        bais = new ByteArrayInputStream(new byte[]{-64, 0, -64, 0});
        Assertions.assertEquals((int)192, (int)runCodec.decode((InputStream)bais));
        Assertions.assertEquals((int)0, (int)runCodec.decode((InputStream)bais));
        Assertions.assertEquals((int)192, (int)runCodec.decode((InputStream)bais));
        Assertions.assertEquals((int)0, (int)bais.available());
    }

    @Test
    public void testDecodeInts() throws Exception {
        int[] band = new int[]{1, -2, -3, 1000, 55, 5, 10, 20};
        byte[] bytes1 = Codec.DELTA5.encode(new int[]{1, -2, -3, 1000, 55});
        byte[] bytes2 = Codec.UNSIGNED5.encode(new int[]{5, 10, 20});
        byte[] bandEncoded = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, bandEncoded, 0, bytes1.length);
        System.arraycopy(bytes2, 0, bandEncoded, bytes1.length, bytes2.length);
        RunCodec runCodec = new RunCodec(5, (Codec)Codec.DELTA5, (Codec)Codec.UNSIGNED5);
        int[] bandDecoded = runCodec.decodeInts(8, (InputStream)new ByteArrayInputStream(bandEncoded));
        Assertions.assertEquals((int)band.length, (int)bandDecoded.length);
        for (int i = 0; i < band.length; ++i) {
            Assertions.assertEquals((int)band[i], (int)bandDecoded[i]);
        }
    }

    @Disabled
    @Test
    public void testRunCodecDecodeIntsOverflow() throws Exception {
        byte[] bytes1 = Codec.DELTA5.encode(new int[]{1, -2, -3, 1000, 55});
        byte[] bytes2 = Codec.UNSIGNED5.encode(new int[]{5, 10, 20});
        byte[] bandEncoded = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, bandEncoded, 0, bytes1.length);
        System.arraycopy(bytes2, 0, bandEncoded, bytes1.length, bytes2.length);
        RunCodec runCodec = new RunCodec(5, (Codec)Codec.DELTA5, (Codec)Codec.UNSIGNED5);
        Assertions.assertThrows(IOException.class, () -> runCodec.decodeInts(0x7FFFFFFE, (InputStream)new ByteArrayInputStream(bandEncoded)));
        Assertions.assertThrows(IOException.class, () -> runCodec.decodeInts(0x7FFFFFFE, (InputStream)new ByteArrayInputStream(bandEncoded), 1));
    }

    @Test
    public void testEncodeSingleValue() {
        Assertions.assertThrows(Pack200Exception.class, () -> new RunCodec(10, (Codec)Codec.SIGNED5, (Codec)Codec.UDELTA5).encode(5), (String)"Should not allow a single value to be encoded as we don't know which codec to use");
        Assertions.assertThrows(Pack200Exception.class, () -> new RunCodec(10, (Codec)Codec.SIGNED5, (Codec)Codec.UDELTA5).encode(5, 8), (String)"Should not allow a single value to be encoded as we don't know which codec to use");
    }

    @Test
    public void testNestedPopulationCodec() throws Exception {
        int[] band = new int[]{11, 12, 33, 4000, -555, 5, 10, 20, 10, 3, 20, 20, 20, 10, 10, 999, 20, 789, 10, 10, 355, 12345};
        byte[] bytes1 = Codec.DELTA5.encode(new int[]{11, 12, 33, 4000, -555});
        PopulationCodec popCodec = new PopulationCodec((Codec)Codec.UNSIGNED5, (Codec)Codec.BYTE1, (Codec)Codec.UNSIGNED5);
        byte[] bytes2 = popCodec.encode(new int[]{10, 20}, new int[]{0, 1, 2, 1, 0, 2, 2, 2, 1, 1, 0, 2, 0, 1, 1, 0, 0}, new int[]{5, 3, 999, 789, 355, 12345});
        byte[] bandEncoded = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, bandEncoded, 0, bytes1.length);
        System.arraycopy(bytes2, 0, bandEncoded, bytes1.length, bytes2.length);
        RunCodec runCodec = new RunCodec(5, (Codec)Codec.DELTA5, (Codec)new PopulationCodec((Codec)Codec.UNSIGNED5, (Codec)Codec.BYTE1, (Codec)Codec.UNSIGNED5));
        int[] bandDecoded = runCodec.decodeInts(band.length, (InputStream)new ByteArrayInputStream(bandEncoded));
        Assertions.assertEquals((int)band.length, (int)bandDecoded.length);
        for (int i = 0; i < band.length; ++i) {
            Assertions.assertEquals((int)band[i], (int)bandDecoded[i]);
        }
    }

    @Disabled
    @Test
    public void testPopulationCodecDecodeIntsOverflow() throws Exception {
        byte[] bytes1 = Codec.DELTA5.encode(new int[]{11, 12, 33, 4000, -555});
        PopulationCodec popCodec = new PopulationCodec((Codec)Codec.UNSIGNED5, (Codec)Codec.BYTE1, (Codec)Codec.UNSIGNED5);
        byte[] bytes2 = popCodec.encode(new int[]{10, 20}, new int[]{0, 1, 2, 1, 0, 2, 2, 2, 1, 1, 0, 2, 0, 1, 1, 0, 0}, new int[]{5, 3, 999, 789, 355, 12345});
        byte[] bandEncoded = new byte[bytes1.length + bytes2.length];
        Assertions.assertThrows(IOException.class, () -> popCodec.decodeInts(0x7FFFFFFE, (InputStream)new ByteArrayInputStream(bandEncoded)));
    }

    @Test
    public void testNestedRunCodec() throws Exception {
        int[] band = new int[]{1, 2, 3, 10, 20, 30, 100, 200, 300};
        byte[] bytes1 = Codec.UDELTA5.encode(new int[]{1, 2, 3});
        byte[] bytes2 = Codec.BYTE1.encode(new int[]{10, 20, 30});
        byte[] bytes3 = Codec.UNSIGNED5.encode(new int[]{100, 200, 300});
        byte[] bandEncoded = new byte[bytes1.length + bytes2.length + bytes3.length];
        System.arraycopy(bytes1, 0, bandEncoded, 0, bytes1.length);
        System.arraycopy(bytes2, 0, bandEncoded, bytes1.length, bytes2.length);
        System.arraycopy(bytes3, 0, bandEncoded, bytes1.length + bytes2.length, bytes3.length);
        RunCodec runCodec = new RunCodec(3, (Codec)Codec.UDELTA5, (Codec)new RunCodec(3, (Codec)Codec.BYTE1, (Codec)Codec.UNSIGNED5));
        int[] bandDecoded = runCodec.decodeInts(9, (InputStream)new ByteArrayInputStream(bandEncoded));
        Assertions.assertEquals((int)band.length, (int)bandDecoded.length);
        for (int i = 0; i < band.length; ++i) {
            Assertions.assertEquals((int)band[i], (int)bandDecoded[i]);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"runCodec"})
    public void testRunCodec(int k, Codec aCodec, Codec bCodec, String failureMessage) {
        Assertions.assertThrows(Pack200Exception.class, () -> new RunCodec(k, aCodec, bCodec), (String)failureMessage);
    }

    @Test
    public void testToString() throws Pack200Exception {
        RunCodec runCodec = new RunCodec(3, (Codec)Codec.UNSIGNED5, (Codec)Codec.BYTE1);
        Assertions.assertEquals((Object)("RunCodec[k=3;aCodec=" + Codec.UNSIGNED5 + "bCodec=" + Codec.BYTE1 + "]"), (Object)runCodec.toString());
    }
}

