/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.zstandard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZstdRoundtripTest
extends AbstractTest {
    private void roundtrip(OutputStreamCreator oc) throws IOException {
        Path input = ZstdRoundtripTest.getPath("bla.tar");
        long start = System.currentTimeMillis();
        File output = this.newTempFile(input.getFileName() + ".zstd");
        try (FileOutputStream os = new FileOutputStream(output);
             ZstdCompressorOutputStream zos = oc.wrap(os);){
            Files.copy(input, (OutputStream)zos);
        }
        start = System.currentTimeMillis();
        try (ZstdCompressorInputStream zis = new ZstdCompressorInputStream(Files.newInputStream(output.toPath(), new OpenOption[0]));){
            byte[] expected = Files.readAllBytes(input);
            byte[] actual = IOUtils.toByteArray((InputStream)zis);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testDirectRoundtrip() throws Exception {
        this.roundtrip(ZstdCompressorOutputStream::new);
    }

    @Test
    public void testFactoryRoundtrip() throws Exception {
        Path input = ZstdRoundtripTest.getPath("bla.tar");
        long start = System.currentTimeMillis();
        File output = this.newTempFile(input.getFileName() + ".zstd");
        try (OutputStream os = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             CompressorOutputStream zos = new CompressorStreamFactory().createCompressorOutputStream("zstd", os);){
            Files.copy(input, (OutputStream)zos);
        }
        start = System.currentTimeMillis();
        try (InputStream inputStream = Files.newInputStream(output.toPath(), new OpenOption[0]);
             CompressorInputStream zis = new CompressorStreamFactory().createCompressorInputStream("zstd", inputStream);){
            byte[] expected = Files.readAllBytes(input);
            byte[] actual = IOUtils.toByteArray((InputStream)zis);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testRoundtripWithChecksum() throws Exception {
        this.roundtrip(os -> new ZstdCompressorOutputStream((OutputStream)os, 3, false, true));
    }

    @Test
    public void testRoundtripWithCloseFrameOnFlush() throws Exception {
        this.roundtrip(os -> new ZstdCompressorOutputStream((OutputStream)os, 3, true));
    }

    @Test
    public void testRoundtripWithCustomLevel() throws Exception {
        this.roundtrip(os -> new ZstdCompressorOutputStream((OutputStream)os, 1));
    }

    private static interface OutputStreamCreator {
        public ZstdCompressorOutputStream wrap(FileOutputStream var1) throws IOException;
    }
}

