/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FramedLZ4CompressorOutputStreamTest {
    @Test
    public void testFinishWithNoWrite() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        FramedLZ4CompressorOutputStream compressor = new FramedLZ4CompressorOutputStream((OutputStream)buffer, new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.K64, true, false, false));
        compressor.close();
        Assertions.assertTrue((buffer.size() == 15 ? 1 : 0) != 0, (String)"Only the trailer gets written.");
    }

    @Test
    public void testWriteByteArrayVsWriteByte() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = "abcdefghijklmnop".getBytes();
        try (FramedLZ4CompressorOutputStream compressor = new FramedLZ4CompressorOutputStream((OutputStream)buffer, new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.K64, true, false, false));){
            compressor.write(bytes);
            compressor.finish();
        }
        byte[] bulkOutput = buffer.toByteArray();
        buffer = new ByteArrayOutputStream();
        try (FramedLZ4CompressorOutputStream compressor = new FramedLZ4CompressorOutputStream((OutputStream)buffer, new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.K64, true, false, false));){
            for (byte element : bytes) {
                compressor.write((int)element);
            }
            compressor.finish();
        }
        Assertions.assertTrue((boolean)Arrays.equals(bulkOutput, buffer.toByteArray()));
    }
}

