/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;
import org.junit.jupiter.api.Test;

public final class DeflateTest
extends AbstractTest {
    @Test
    public void testDeflateCreation() throws Exception {
        File input = DeflateTest.getFile("test1.xml");
        File output = this.newTempFile("test1.xml.deflatez");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("deflate", out);){
            Files.copy(input.toPath(), (OutputStream)cos);
        }
    }

    @Test
    public void testDeflateUnarchive() throws Exception {
        File input = DeflateTest.getFile("bla.tar.deflatez");
        File output = this.newTempFile("bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("deflate", is);){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
        }
    }

    @Test
    public void testRawDeflateCreation() throws Exception {
        File input = DeflateTest.getFile("test1.xml");
        File output = this.newTempFile("test1.xml.deflate");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            DeflateParameters params = new DeflateParameters();
            params.setWithZlibHeader(false);
            try (DeflateCompressorOutputStream cos = new DeflateCompressorOutputStream(out, params);){
                Files.copy(input.toPath(), (OutputStream)cos);
            }
        }
    }

    @Test
    public void testRawDeflateUnarchive() throws Exception {
        File input = DeflateTest.getFile("bla.tar.deflate");
        File output = this.newTempFile("bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            DeflateParameters params = new DeflateParameters();
            params.setWithZlibHeader(false);
            try (DeflateCompressorInputStream in = new DeflateCompressorInputStream(is, params);){
                Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
            }
        }
    }
}

