/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.archivers.zip.FileRandomAccessOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FileRandomAccessOutputStreamTest
extends AbstractTempDirTest {
    @Test
    public void testChannelReturn() throws IOException {
        Path file = this.newTempPath("testChannel");
        try (FileRandomAccessOutputStream stream = new FileRandomAccessOutputStream(file);){
            Assertions.assertNotNull((Object)stream.channel());
        }
    }

    @Test
    public void testWrite() throws IOException {
        FileChannel channel = (FileChannel)Mockito.mock(FileChannel.class);
        FileRandomAccessOutputStream stream = new FileRandomAccessOutputStream(channel);
        Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any())).thenAnswer(answer -> {
            ((ByteBuffer)answer.getArgument(0)).position(5);
            return 5;
        }).thenAnswer(answer -> {
            ((ByteBuffer)answer.getArgument(0)).position(6);
            return 6;
        });
        stream.write("hello".getBytes(StandardCharsets.UTF_8));
        stream.write("world\n".getBytes(StandardCharsets.UTF_8));
        ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)2))).write((ByteBuffer)ArgumentMatchers.any());
        Assertions.assertEquals((long)11L, (long)stream.position());
    }

    @Test
    public void testWriteFullyAt_whenFullAtOnce_thenSucceed() throws IOException {
        FileChannel channel = (FileChannel)Mockito.mock(FileChannel.class);
        FileRandomAccessOutputStream stream = new FileRandomAccessOutputStream(channel);
        Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L))).thenAnswer(answer -> {
            ((ByteBuffer)answer.getArgument(0)).position(5);
            return 5;
        });
        Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)30L))).thenAnswer(answer -> {
            ((ByteBuffer)answer.getArgument(0)).position(6);
            return 6;
        });
        stream.writeFully("hello".getBytes(StandardCharsets.UTF_8), 20L);
        stream.writeFully("world\n".getBytes(StandardCharsets.UTF_8), 30L);
        ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L));
        ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)30L));
        Assertions.assertEquals((long)0L, (long)stream.position());
    }

    @Test
    public void testWriteFullyAt_whenFullButPartial_thenSucceed() throws IOException {
        FileChannel channel = (FileChannel)Mockito.mock(FileChannel.class);
        FileRandomAccessOutputStream stream = new FileRandomAccessOutputStream(channel);
        Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L))).thenAnswer(answer -> {
            ((ByteBuffer)answer.getArgument(0)).position(3);
            return 3;
        });
        Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)23L))).thenAnswer(answer -> {
            ((ByteBuffer)answer.getArgument(0)).position(5);
            return 2;
        });
        Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)30L))).thenAnswer(answer -> {
            ((ByteBuffer)answer.getArgument(0)).position(6);
            return 6;
        });
        stream.writeFully("hello".getBytes(StandardCharsets.UTF_8), 20L);
        stream.writeFully("world\n".getBytes(StandardCharsets.UTF_8), 30L);
        ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L));
        ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)23L));
        ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)30L));
        Assertions.assertEquals((long)0L, (long)stream.position());
    }

    @Test
    public void testWriteFullyAt_whenPartial_thenFail() throws IOException {
        FileChannel channel = (FileChannel)Mockito.mock(FileChannel.class);
        FileRandomAccessOutputStream stream = new FileRandomAccessOutputStream(channel);
        Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L))).thenAnswer(answer -> {
            ((ByteBuffer)answer.getArgument(0)).position(3);
            return 3;
        });
        Mockito.when((Object)channel.write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)23L))).thenAnswer(answer -> 0);
        Assertions.assertThrows(IOException.class, () -> stream.writeFully("hello".getBytes(StandardCharsets.UTF_8), 20L));
        ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)20L));
        ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)23L));
        ((FileChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)0))).write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)25L));
        Assertions.assertEquals((long)0L, (long)stream.position());
    }
}

