/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOUtilsTest {
    private static void readFully(byte[] source, ByteBuffer b) throws IOException {
        try (SeekableInMemoryByteChannel channel = new SeekableInMemoryByteChannel(source);){
            IOUtils.readFully((ReadableByteChannel)channel, (ByteBuffer)b);
        }
    }

    private void skip(StreamWrapper wrapper) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        try (InputStream sut = wrapper.wrap(in);){
            Assertions.assertEquals((long)10L, (long)IOUtils.skip((InputStream)sut, (long)10L));
            Assertions.assertEquals((int)11, (int)sut.read());
        }
    }

    @Test
    public void testCopyRangeDoesntCopyMoreThanAskedFor() throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Assertions.assertEquals((long)3L, (long)IOUtils.copyRange((InputStream)in, (long)3L, (OutputStream)out));
            out.close();
            Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])out.toByteArray());
        }
    }

    @Test
    public void testCopyRangeStopsIfThereIsNothingToCopyAnymore() throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Assertions.assertEquals((long)5L, (long)IOUtils.copyRange((InputStream)in, (long)10L, (OutputStream)out));
            out.close();
            Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])out.toByteArray());
        }
    }

    @Test
    public void testCopyRangeThrowsOnZeroBufferSize() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.copyRange((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY), (long)5L, (OutputStream)new ByteArrayOutputStream(), (int)0));
    }

    @Test
    public void testCopyThrowsOnZeroBufferSize() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.copy((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY), (OutputStream)new ByteArrayOutputStream(), (int)0));
    }

    @Test
    public void testReadFullyOnChannelReadsFully() throws IOException {
        ByteBuffer b = ByteBuffer.allocate(20);
        byte[] source = new byte[20];
        for (int i = 0; i < 20; i = (int)((byte)(i + 1))) {
            source[i] = i;
        }
        IOUtilsTest.readFully(source, b);
        Assertions.assertArrayEquals((byte[])source, (byte[])b.array());
    }

    @Test
    public void testReadFullyOnChannelThrowsEof() {
        ByteBuffer b = ByteBuffer.allocate(21);
        byte[] source = new byte[20];
        for (int i = 0; i < 20; i = (int)((byte)(i + 1))) {
            source[i] = i;
        }
        Assertions.assertThrows(EOFException.class, () -> IOUtilsTest.readFully(source, b));
    }

    @Test
    public void testReadRangeFromChannelDoesntReadMoreThanAskedFor() throws IOException {
        try (SeekableInMemoryByteChannel in = new SeekableInMemoryByteChannel(new byte[]{1, 2, 3, 4, 5});){
            byte[] read = IOUtils.readRange((ReadableByteChannel)in, (int)3);
            Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])read);
            ByteBuffer b = ByteBuffer.allocate(1);
            Assertions.assertEquals((int)1, (int)in.read(b));
            Assertions.assertArrayEquals((byte[])new byte[]{4}, (byte[])b.array());
        }
    }

    @Test
    public void testReadRangeFromChannelDoesntReadMoreThanAskedForWhenItGotLessInFirstReadCall() throws IOException {
        try (SeekableInMemoryByteChannel in = new SeekableInMemoryByteChannel(new byte[]{1, 2, 3, 4, 5, 6, 7}){

            public int read(ByteBuffer buf) throws IOException {
                ByteBuffer temp = ByteBuffer.allocate(Math.min(2, buf.remaining()));
                int read = super.read(temp);
                if (read > 0) {
                    buf.put(temp.array(), 0, read);
                }
                return read;
            }
        };){
            byte[] read = IOUtils.readRange((ReadableByteChannel)in, (int)5);
            Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])read);
        }
    }

    @Test
    public void testReadRangeFromChannelStopsIfThereIsNothingToReadAnymore() throws IOException {
        try (SeekableInMemoryByteChannel in = new SeekableInMemoryByteChannel(new byte[]{1, 2, 3, 4, 5});){
            byte[] read = IOUtils.readRange((ReadableByteChannel)in, (int)10);
            Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])read);
            ByteBuffer b = ByteBuffer.allocate(1);
            Assertions.assertEquals((int)-1, (int)in.read(b));
        }
    }

    @Test
    public void testReadRangeFromStreamDoesntReadMoreThanAskedFor() throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});){
            byte[] read = IOUtils.readRange((InputStream)in, (int)3);
            Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])read);
            Assertions.assertEquals((int)4, (int)in.read());
        }
    }

    @Test
    public void testReadRangeFromStreamStopsIfThereIsNothingToReadAnymore() throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});){
            byte[] read = IOUtils.readRange((InputStream)in, (int)10);
            Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])read);
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testReadRangeMoreThanCopyBufferSize() throws Exception {
        Field COPY_BUF_SIZE = IOUtils.class.getDeclaredField("COPY_BUF_SIZE");
        COPY_BUF_SIZE.setAccessible(true);
        int copyBufSize = (Integer)COPY_BUF_SIZE.get(null);
        byte[] input = new byte[copyBufSize + 10];
        try (SeekableInMemoryByteChannel in = new SeekableInMemoryByteChannel(input);){
            int toRead = copyBufSize + 1;
            byte[] read = IOUtils.readRange((ReadableByteChannel)in, (int)toRead);
            Assertions.assertEquals((int)toRead, (int)read.length);
            Assertions.assertEquals((long)toRead, (long)in.position());
        }
    }

    @Test
    public void testSkipUsingRead() throws Exception {
        this.skip(toWrap -> new FilterInputStream(toWrap){

            @Override
            public long skip(long s) {
                return 0L;
            }
        });
    }

    @Test
    public void testSkipUsingSkip() throws Exception {
        this.skip(toWrap -> toWrap);
    }

    @Test
    public void testSkipUsingSkipAndRead() throws Exception {
        this.skip(toWrap -> new FilterInputStream(toWrap){
            boolean skipped;

            @Override
            public long skip(long s) throws IOException {
                if (!this.skipped) {
                    toWrap.skip(5L);
                    this.skipped = true;
                    return 5L;
                }
                return 0L;
            }
        });
    }

    private static interface StreamWrapper {
        public InputStream wrap(InputStream var1);
    }
}

