/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.util.stream.Stream;
import org.apache.commons.compress.harmony.unpack200.IMatcher;
import org.apache.commons.compress.harmony.unpack200.SegmentUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class SegmentUtilsTest {
    public static final IMatcher even = new MultipleMatches(2);
    public static final IMatcher five = new MultipleMatches(5);

    static Stream<Arguments> countArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{"()V", 0}), Arguments.of((Object[])new Object[]{"(D)V", 1}), Arguments.of((Object[])new Object[]{"([D)V", 1}), Arguments.of((Object[])new Object[]{"([[D)V", 1}), Arguments.of((Object[])new Object[]{"(DD)V", 2}), Arguments.of((Object[])new Object[]{"(DDD)V", 3}), Arguments.of((Object[])new Object[]{"(Lblah/blah;D)V", 2}), Arguments.of((Object[])new Object[]{"(Lblah/blah;DLbLah;)V", 3}));
    }

    static Stream<Arguments> countInvokeInterfaceArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{"(Z)V", 1}), Arguments.of((Object[])new Object[]{"(D)V", 2}), Arguments.of((Object[])new Object[]{"(J)V", 2}), Arguments.of((Object[])new Object[]{"([D)V", 1}), Arguments.of((Object[])new Object[]{"([[D)V", 1}), Arguments.of((Object[])new Object[]{"(DD)V", 4}), Arguments.of((Object[])new Object[]{"(Lblah/blah;D)V", 3}), Arguments.of((Object[])new Object[]{"(Lblah/blah;DLbLah;)V", 4}), Arguments.of((Object[])new Object[]{"([Lblah/blah;DLbLah;)V", 4}));
    }

    @ParameterizedTest
    @MethodSource(value={"countArgs"})
    public void testCountArgs(String descriptor, int expectedArgsCount) {
        Assertions.assertEquals((int)expectedArgsCount, (int)SegmentUtils.countArgs((String)descriptor));
    }

    @ParameterizedTest
    @MethodSource(value={"countInvokeInterfaceArgs"})
    public void testCountInvokeInterfaceArgs(String descriptor, int expectedCountInvokeInterfaceArgs) {
        Assertions.assertEquals((int)expectedCountInvokeInterfaceArgs, (int)SegmentUtils.countInvokeInterfaceArgs((String)descriptor));
    }

    @Test
    public void testMatches() {
        long[] oneToTen = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L};
        Assertions.assertEquals((int)6, (int)SegmentUtils.countMatches((long[][])new long[][]{oneToTen, {5L, 6L, 7L}}, (IMatcher)even));
        Assertions.assertEquals((int)5, (int)SegmentUtils.countMatches((long[][])new long[][]{oneToTen}, (IMatcher)even));
        Assertions.assertEquals((int)5, (int)SegmentUtils.countMatches((long[])oneToTen, (IMatcher)even));
        Assertions.assertEquals((int)3, (int)SegmentUtils.countMatches((long[][])new long[][]{oneToTen, {5L, 6L, 7L}}, (IMatcher)five));
        Assertions.assertEquals((int)2, (int)SegmentUtils.countMatches((long[][])new long[][]{oneToTen}, (IMatcher)five));
        Assertions.assertEquals((int)2, (int)SegmentUtils.countMatches((long[])oneToTen, (IMatcher)five));
    }

    private static final class MultipleMatches
    implements IMatcher {
        private final int divisor;

        public MultipleMatches(int divisor) {
            this.divisor = divisor;
        }

        public boolean matches(long value) {
            return value % (long)this.divisor == 0L;
        }
    }
}

