/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SegmentTest
extends AbstractTempDirTest {
    @Test
    public void testHelloWorld() throws Exception {
        File file = this.createTempFile("hello", "world.jar");
        try (InputStream in = Segment.class.getResourceAsStream("/pack200/HelloWorld.pack");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            new Segment().unpack(in, out);
        }
        try (JarFile jarFile = new JarFile(file);){
            JarEntry entry = jarFile.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
            Assertions.assertNotNull((Object)entry);
            InputStream ours = jarFile.getInputStream(entry);
            JarFile jarFile2 = new JarFile(new File(Segment.class.getResource("/pack200/hw.jar").toURI()));
            JarEntry entry2 = jarFile2.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
            Assertions.assertNotNull((Object)entry2);
            InputStream expected = jarFile2.getInputStream(entry2);
            try (BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
                 BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));){
                String line1 = reader1.readLine();
                String line2 = reader2.readLine();
                int i = 1;
                while (line1 != null || line2 != null) {
                    Assertions.assertEquals((Object)line2, (Object)line1, (String)("Unpacked class files differ ar line " + i));
                    line1 = reader1.readLine();
                    line2 = reader2.readLine();
                    ++i;
                }
            }
        }
    }

    @Test
    public void testInterfaceOnly() throws Exception {
        File file = this.createTempFile("Interface", "Only.jar");
        try (InputStream in = Segment.class.getResourceAsStream("/pack200/InterfaceOnly.pack");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            new Segment().unpack(in, out);
        }
    }

    @Test
    public void testJustResources() throws Exception {
        File file = this.createTempFile("just", "resources.jar");
        try (InputStream in = Segment.class.getResourceAsStream("/pack200/JustResources.pack");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            new Segment().unpack(in, out);
        }
    }
}

