/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.util.List;
import org.apache.commons.compress.harmony.unpack200.SegmentConstantPoolArrayCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SegmentConstantPoolArrayCacheTest {
    @Test
    public void testMultipleArrayMultipleHit() {
        SegmentConstantPoolArrayCache arrayCache = new SegmentConstantPoolArrayCache();
        String[] arrayOne = new String[]{"Zero", "Shared", "Two", "Shared", "Shared"};
        String[] arrayTwo = new String[]{"Shared", "One", "Shared", "Shared", "Shared"};
        List listOne = arrayCache.indexesForArrayKey(arrayOne, "Shared");
        List listTwo = arrayCache.indexesForArrayKey(arrayTwo, "Shared");
        listOne = arrayCache.indexesForArrayKey(arrayOne, "Two");
        listTwo = arrayCache.indexesForArrayKey(arrayTwo, "Shared");
        Assertions.assertEquals((int)1, (int)listOne.size());
        Assertions.assertEquals((int)2, (int)((Integer)listOne.get(0)));
        listOne = arrayCache.indexesForArrayKey(arrayOne, "Shared");
        Assertions.assertEquals((int)3, (int)listOne.size());
        Assertions.assertEquals((int)1, (int)((Integer)listOne.get(0)));
        Assertions.assertEquals((int)3, (int)((Integer)listOne.get(1)));
        Assertions.assertEquals((int)4, (int)((Integer)listOne.get(2)));
        Assertions.assertEquals((int)4, (int)listTwo.size());
        Assertions.assertEquals((int)0, (int)((Integer)listTwo.get(0)));
        Assertions.assertEquals((int)2, (int)((Integer)listTwo.get(1)));
        Assertions.assertEquals((int)3, (int)((Integer)listTwo.get(2)));
        Assertions.assertEquals((int)4, (int)((Integer)listTwo.get(3)));
        List listThree = arrayCache.indexesForArrayKey(arrayOne, "Not found");
        Assertions.assertEquals((int)0, (int)listThree.size());
    }

    @Test
    public void testSingleMultipleHitArray() {
        SegmentConstantPoolArrayCache arrayCache = new SegmentConstantPoolArrayCache();
        String[] array = new String[]{"Zero", "OneThreeFour", "Two", "OneThreeFour", "OneThreeFour"};
        List list = arrayCache.indexesForArrayKey(array, "OneThreeFour");
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((int)1, (int)((Integer)list.get(0)));
        Assertions.assertEquals((int)3, (int)((Integer)list.get(1)));
        Assertions.assertEquals((int)4, (int)((Integer)list.get(2)));
    }

    @Test
    public void testSingleSimpleArray() {
        SegmentConstantPoolArrayCache arrayCache = new SegmentConstantPoolArrayCache();
        String[] array = new String[]{"Zero", "One", "Two", "Three", "Four"};
        List list = arrayCache.indexesForArrayKey(array, "Three");
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((int)3, (int)((Integer)list.get(0)));
    }
}

