/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.harmony.unpack200.Archive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArchiveTest
extends AbstractTempDirTest {
    InputStream in;
    JarOutputStream out;

    @AfterEach
    public void tearDown() throws Exception {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testAlternativeConstructor() throws Exception {
        String inputFile = new File(Archive.class.getResource("/pack200/sql.pack.gz").toURI()).getPath();
        File file = this.createTempFile("sql", ".jar");
        String outputFile = file.getPath();
        Archive archive = new Archive(inputFile, outputFile);
        archive.unpack();
    }

    @Test
    public void testDeflateHint() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        File file = this.createTempFile("sql", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        Archive archive = new Archive(this.in, this.out);
        archive.setDeflateHint(true);
        archive.unpack();
        try (JarFile jarFile = new JarFile(file);){
            Assertions.assertEquals((int)8, (int)jarFile.getEntry("bin/test/org/apache/harmony/sql/tests/internal/rowset/CachedRowSetImplTest.class").getMethod());
            this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
            file = this.createTempFile("sql", ".jar");
            this.out = new JarOutputStream(new FileOutputStream(file));
            archive = new Archive(this.in, this.out);
            archive.setDeflateHint(false);
            archive.unpack();
        }
        jarFile = new JarFile(file);
        try {
            Assertions.assertEquals((int)0, (int)jarFile.getEntry("bin/test/org/apache/harmony/sql/tests/internal/rowset/CachedRowSetImplTest.class").getMethod());
        }
        finally {
            jarFile.close();
        }
    }

    @Test
    public void testJustResourcesGZip() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/JustResources.pack.gz");
        File file = this.createTempFile("Just", "ResourcesGz.jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testLoggingOptions() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        File file = this.createTempFile("logtest", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        Archive archive = new Archive(this.in, this.out);
        File logFile = this.createTempFile("logfile", ".txt");
        archive.setLogFile(logFile.getPath());
        archive.unpack();
        try (FileReader reader = new FileReader(logFile);){
            Assertions.assertFalse((boolean)reader.ready());
        }
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        file = this.createTempFile("logtest", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        archive = new Archive(this.in, this.out);
        logFile = this.createTempFile("logfile", ".txt");
        archive.setLogFile(logFile.getPath());
        archive.setVerbose(true);
        archive.unpack();
        reader = new FileReader(logFile);
        try {
            Assertions.assertTrue((boolean)reader.ready());
        }
        finally {
            reader.close();
        }
        long length = logFile.length();
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        file = this.createTempFile("logtest", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        archive = new Archive(this.in, this.out);
        archive.setLogFile(logFile.getPath(), true);
        archive.setVerbose(true);
        archive.unpack();
        Assertions.assertTrue((logFile.length() > length ? 1 : 0) != 0);
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        file = this.createTempFile("logtest", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        archive = new Archive(this.in, this.out);
        archive.setLogFile(logFile.getPath(), false);
        archive.setVerbose(true);
        archive.unpack();
        Assertions.assertEquals((long)logFile.length(), (long)length);
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        file = this.createTempFile("logtest", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        archive = new Archive(this.in, this.out);
        logFile = this.createTempFile("logfile", ".txt");
        archive.setLogFile(logFile.getPath());
        archive.setQuiet(true);
        archive.unpack();
        try (FileReader reader = new FileReader(logFile);){
            Assertions.assertFalse((boolean)reader.ready());
        }
    }

    @Test
    public void testRemovePackFile() throws Exception {
        File original = new File(Archive.class.getResource("/pack200/sql.pack.gz").toURI());
        File copy = this.createTempFile("sqlcopy", ".pack.gz");
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(original));
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(copy));){
            byte[] bytes = new byte[256];
            int read = inputStream.read(bytes);
            while (read > 0) {
                outputStream.write(bytes, 0, read);
                read = inputStream.read(bytes);
            }
        }
        String inputFile = copy.getPath();
        File file = this.createTempFile("sqlout", ".jar");
        String outputFile = file.getPath();
        Archive archive = new Archive(inputFile, outputFile);
        archive.setRemovePackFile(true);
        archive.unpack();
        Assertions.assertFalse((boolean)copy.exists());
    }

    @Test
    public void testWithAnnotations() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/annotations.pack.gz");
        File file = this.createTempFile("annotations", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithE0() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/simple-E0.pack.gz");
        File file = this.createTempFile("simple-e0", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithJNDIE1() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/jndi-e1.pack.gz");
        File file = this.createTempFile("jndi-e1", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithLargeClass() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/LargeClass.pack.gz");
        File file = this.createTempFile("largeClass", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithPack200() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/pack200.pack.gz");
        File file = this.createTempFile("p200", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithPack200E1() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/pack200-e1.pack.gz");
        File file = this.createTempFile("p200-e1", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithSql() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        File file = this.createTempFile("sql", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        try (JarFile jarFile = new JarFile(file);
             JarFile jarFile2 = new JarFile(compareFile);){
            long differenceInJarSizes = Math.abs(compareFile.length() - file.length());
            Assertions.assertTrue((differenceInJarSizes < 100L ? 1 : 0) != 0, (String)("Expected jar files to be a similar size, difference was " + differenceInJarSizes + " bytes"));
            Enumeration<JarEntry> entries = jarFile.entries();
            Enumeration<JarEntry> entries2 = jarFile2.entries();
            while (entries.hasMoreElements() && entries2.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                Assertions.assertNotNull((Object)entry);
                String name = entry.getName();
                JarEntry entry2 = entries2.nextElement();
                Assertions.assertNotNull((Object)entry2);
                String name2 = entry2.getName();
                Assertions.assertEquals((Object)name, (Object)name2);
                InputStream ours = jarFile.getInputStream(entry);
                try {
                    InputStream expected = jarFile2.getInputStream(entry2);
                    try (BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
                         BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));){
                        String line1 = reader1.readLine();
                        String line2 = reader2.readLine();
                        int i = 1;
                        while (line1 != null || line2 != null) {
                            Assertions.assertEquals((Object)line2, (Object)line1, (String)("Unpacked class files differ for " + name));
                            line1 = reader1.readLine();
                            line2 = reader2.readLine();
                            ++i;
                        }
                        Assertions.assertTrue((i > 0 ? 1 : 0) != 0);
                    }
                    finally {
                        if (expected == null) continue;
                        expected.close();
                    }
                }
                finally {
                    if (ours == null) continue;
                    ours.close();
                }
            }
        }
    }

    @Test
    public void testWithSqlE1() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/sql-e1.pack.gz");
        File file = this.createTempFile("sql-e1", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }
}

