/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.pack200.PopulationCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class PopulationCodecTest {
    static Stream<Arguments> populationCodec() {
        return Stream.of(Arguments.of((Object[])new Object[]{new byte[]{4, 5, 6, 4, 2, 1, 3, 0, 7}, new long[]{5L, 4L, 6L, 7L}, Codec.BYTE1}), Arguments.of((Object[])new Object[]{new byte[]{8, 7, 12, 8, 4, 2, 6, 0, 14}, new long[]{-4L, 4L, 6L, 7L}, Codec.SIGNED5}), Arguments.of((Object[])new Object[]{new byte[]{7, 8, 12, 8, 4, 2, 6, 0, 14}, new long[]{4L, -4L, 6L, 7L}, Codec.SIGNED5}), Arguments.of((Object[])new Object[]{new byte[]{1, 1, 1}, new long[]{1L}, Codec.BYTE1}), Arguments.of((Object[])new Object[]{new byte[]{2, 2, 1}, new long[]{2L}, Codec.BYTE1}), Arguments.of((Object[])new Object[]{new byte[]{1, 1, 2}, new long[]{-1L}, Codec.SIGNED5}), Arguments.of((Object[])new Object[]{new byte[]{2, 2, 0, 1, 3}, new long[]{3L, 2L}, Codec.BYTE1}), Arguments.of((Object[])new Object[]{new byte[]{1, 2, 3, 4, 4, 2, 3, 4, 0, 1}, new long[]{2L, 3L, 4L, 1L}, Codec.BYTE1}), Arguments.of((Object[])new Object[]{new byte[]{3, 2, 1, 4, 4, 2, 3, 4, 0, 1}, new long[]{2L, 1L, 4L, 1L}, Codec.BYTE1}), Arguments.of((Object[])new Object[]{new byte[]{3, 2, 1, 4, 1, 2, 3, 4, 0, 1}, new long[]{2L, 1L, 4L, 1L}, Codec.BYTE1}));
    }

    @Test
    public void testEncodeSingleValue() {
        Assertions.assertThrows(Pack200Exception.class, () -> new PopulationCodec((Codec)Codec.SIGNED5, (Codec)Codec.SIGNED5, (Codec)Codec.UDELTA5).encode(5), (String)"Should not allow a single value to be encoded as we don't know which codec to use");
        Assertions.assertThrows(Pack200Exception.class, () -> new PopulationCodec((Codec)Codec.SIGNED5, (Codec)Codec.SIGNED5, (Codec)Codec.UDELTA5).encode(5, 8), (String)"Should not allow a single value to be encoded as we don't know which codec to use");
    }

    @ParameterizedTest
    @MethodSource(value={"populationCodec"})
    public void testPopulationCodec(byte[] data, long[] expectedResult, Codec codec) throws IOException, Pack200Exception {
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            int[] result = new PopulationCodec(codec, codec, codec).decodeInts(expectedResult.length, (InputStream)in);
            Assertions.assertEquals((int)expectedResult.length, (int)result.length);
            for (int i = 0; i < expectedResult.length; ++i) {
                Assertions.assertEquals((long)expectedResult[i], (long)result[i]);
            }
            Assertions.assertEquals((int)0, (int)((InputStream)in).available());
        }
    }
}

