/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.snappy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyDialect;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class FramedSnappyCompressorInputStreamTest
extends AbstractTest {
    private long mask(long x) {
        return (x >>> 15 | x << 17) + 2726488792L & 0xFFFFFFFFL;
    }

    @Test
    public void testAvailable() throws Exception {
        try (InputStream isSz = FramedSnappyCompressorInputStreamTest.newInputStream("mixed.txt.sz");
             FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(isSz);){
            Assertions.assertEquals((int)0, (int)in.available());
            Assertions.assertEquals((int)49, (int)in.read());
            Assertions.assertEquals((int)3, (int)in.available());
            Assertions.assertEquals((int)3, (int)in.read(new byte[5], 0, 3));
            Assertions.assertEquals((int)53, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.available());
            Assertions.assertEquals((int)4, (int)in.read(new byte[5], 0, 4));
            Assertions.assertEquals((int)53, (int)in.read());
        }
    }

    @Test
    public void testChecksumUnmasking() {
        this.testChecksumUnmasking(51031L);
        this.testChecksumUnmasking(4294952791L);
    }

    private void testChecksumUnmasking(long x) {
        Assertions.assertEquals((Object)Long.toHexString(x), (Object)Long.toHexString(FramedSnappyCompressorInputStream.unmask((long)this.mask(x))));
    }

    @Test
    public void testLoremIpsum() throws Exception {
        File outputSz = this.newTempFile("lorem-ipsum.1");
        File outputGz = this.newTempFile("lorem-ipsum.2");
        try (InputStream isSz = FramedSnappyCompressorInputStreamTest.newInputStream("lorem-ipsum.txt.sz");){
            try (FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(isSz);){
                Files.copy((InputStream)in, outputSz.toPath(), new CopyOption[0]);
            }
            try (InputStream isGz = FramedSnappyCompressorInputStreamTest.newInputStream("lorem-ipsum.txt.gz");
                 GzipCompressorInputStream in = new GzipCompressorInputStream(isGz);){
                Files.copy((InputStream)in, outputGz.toPath(), new CopyOption[0]);
            }
        }
        Assertions.assertArrayEquals((byte[])Files.readAllBytes(outputSz.toPath()), (byte[])Files.readAllBytes(outputGz.toPath()));
    }

    @Test
    public void testMatches() throws IOException {
        Assertions.assertFalse((boolean)FramedSnappyCompressorInputStream.matches((byte[])new byte[10], (int)10));
        byte[] b = new byte[12];
        IOUtils.read((File)FramedSnappyCompressorInputStreamTest.getFile("bla.tar.sz"), (byte[])b);
        Assertions.assertFalse((boolean)FramedSnappyCompressorInputStream.matches((byte[])b, (int)9));
        Assertions.assertTrue((boolean)FramedSnappyCompressorInputStream.matches((byte[])b, (int)10));
        Assertions.assertTrue((boolean)FramedSnappyCompressorInputStream.matches((byte[])b, (int)12));
    }

    @Test
    public void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = FramedSnappyCompressorInputStreamTest.getFile("bla.tar.sz");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    public void testReadIWAFile() throws Exception {
        try (ZipFile zip = new ZipFile(FramedSnappyCompressorInputStreamTest.getFile("testNumbersNew.numbers"));
             InputStream is = zip.getInputStream(zip.getEntry("Index/Document.iwa"));
             FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(is, FramedSnappyDialect.IWORK_ARCHIVE);){
            Files.copy((InputStream)in, this.newTempFile("snappyIWATest.raw").toPath(), new CopyOption[0]);
        }
    }

    @Test
    public void testReadIWAFileWithBiggerOffset() throws Exception {
        File o = this.newTempFile("COMPRESS-358.raw");
        try (InputStream is = FramedSnappyCompressorInputStreamTest.newInputStream("COMPRESS-358.iwa");
             FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(is, 65536, FramedSnappyDialect.IWORK_ARCHIVE);){
            Files.copy((InputStream)in, o.toPath(), new CopyOption[0]);
        }
        try (InputStream a = Files.newInputStream(o.toPath(), new OpenOption[0]);
             InputStream e = FramedSnappyCompressorInputStreamTest.newInputStream("COMPRESS-358.uncompressed");){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testRemainingChunkTypes() throws Exception {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             InputStream isSz = FramedSnappyCompressorInputStreamTest.newInputStream("mixed.txt.sz");
             FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(isSz);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
            Assertions.assertArrayEquals((byte[])new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 10, 49, 50, 51, 52, 49, 50, 51, 52}, (byte[])out.toByteArray());
        }
    }

    @Test
    public void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = FramedSnappyCompressorInputStreamTest.getFile("bla.tar.sz");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testUnskippableChunk() {
        byte[] input = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 2, 2, 0, 0, 1, 1};
        try (FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            IOException exception = (IOException)Assertions.assertThrows(IOException.class, () -> in.read());
            Assertions.assertTrue((boolean)exception.getMessage().contains("Unskippable chunk"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

