/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FactoryTest
extends AbstractTest {
    private void roundtripViaFactory(String format) throws Exception {
        Path input = FactoryTest.getPath("bla.tar");
        long start = System.currentTimeMillis();
        Path outputSz = this.getTempDirFile().toPath().resolve(input.getFileName() + "." + format + ".lz4");
        try (OutputStream os = Files.newOutputStream(outputSz, new OpenOption[0]);
             CompressorOutputStream los = new CompressorStreamFactory().createCompressorOutputStream(format, os);){
            Files.copy(input, (OutputStream)los);
        }
        start = System.currentTimeMillis();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             CompressorInputStream sis = new CompressorStreamFactory().createCompressorInputStream(format, Files.newInputStream(outputSz, new OpenOption[0]));){
            byte[] expected = IOUtils.toByteArray((InputStream)is);
            byte[] actual = IOUtils.toByteArray((InputStream)sis);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testBlockRoundtripViaFactory() throws Exception {
        this.roundtripViaFactory(CompressorStreamFactory.getLZ4Block());
    }

    @Test
    public void testFrameRoundtripViaFactory() throws Exception {
        this.roundtripViaFactory(CompressorStreamFactory.getLZ4Framed());
    }
}

