/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class LZMATest
extends AbstractTest {
    @Test
    public void testLzmaRoundtrip() throws Exception {
        byte[] uncompressed;
        File input = LZMATest.getFile("test1.xml");
        File compressed = this.newTempFile("test1.xml.xz");
        try (OutputStream out = Files.newOutputStream(compressed.toPath(), new OpenOption[0]);
             CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("lzma", out);){
            Files.copy(input.toPath(), (OutputStream)cos);
        }
        byte[] orig = Files.readAllBytes(input.toPath());
        try (InputStream is = Files.newInputStream(compressed.toPath(), new OpenOption[0]);
             LZMACompressorInputStream in = new LZMACompressorInputStream(is);){
            uncompressed = IOUtils.toByteArray((InputStream)in);
        }
        Assertions.assertArrayEquals((byte[])orig, (byte[])uncompressed);
    }

    @Test
    public void testLZMAUnarchive() throws Exception {
        File input = LZMATest.getFile("bla.tar.lzma");
        File output = this.newTempFile("bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             LZMACompressorInputStream in = new LZMACompressorInputStream(is);){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
        }
    }

    @Test
    public void testLZMAUnarchiveWithAutodetection() throws Exception {
        File input = LZMATest.getFile("bla.tar.lzma");
        File output = this.newTempFile("bla.tar");
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(input.toPath(), new OpenOption[0]));
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream((InputStream)is);){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
        }
    }

    @Test
    public void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = LZMATest.getFile("bla.tar.lzma");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             LZMACompressorInputStream in = new LZMACompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    public void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = LZMATest.getFile("bla.tar.lzma");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             LZMACompressorInputStream in = new LZMACompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }
}

