/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Random;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class FramedSnappyTest
extends AbstractTest {
    @Test
    public void testDefaultExtraction() throws Exception {
        this.testUnarchive(FramedSnappyCompressorInputStream::new);
    }

    @Test
    public void testDefaultExtractionViaFactory() throws Exception {
        this.testUnarchive(is -> new CompressorStreamFactory().createCompressorInputStream("snappy-framed", is));
    }

    @Test
    public void testDefaultExtractionViaFactoryAutodetection() throws Exception {
        this.testUnarchive(is -> new CompressorStreamFactory().createCompressorInputStream(is));
    }

    @Test
    public void testRoundtrip() throws Exception {
        this.testRoundtrip(FramedSnappyTest.getFile("test.txt"));
        this.testRoundtrip(FramedSnappyTest.getFile("bla.tar"));
        this.testRoundtrip(FramedSnappyTest.getFile("COMPRESS-256.7z"));
    }

    private void testRoundtrip(File input) throws Exception {
        long start = System.currentTimeMillis();
        File outputSz = this.newTempFile(input.getName() + ".sz");
        try (OutputStream os = Files.newOutputStream(outputSz.toPath(), new OpenOption[0]);
             CompressorOutputStream sos = new CompressorStreamFactory().createCompressorOutputStream("snappy-framed", os);){
            Files.copy(input.toPath(), (OutputStream)sos);
        }
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream sis = new CompressorStreamFactory().createCompressorInputStream("snappy-framed", Files.newInputStream(outputSz.toPath(), new OpenOption[0]));){
            byte[] expected = IOUtils.toByteArray((InputStream)is);
            byte[] actual = IOUtils.toByteArray((InputStream)sis);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testRoundtripWithOneBigWrite() throws Exception {
        Random r = new Random();
        File input = this.newTempFile("bigChunkTest");
        try (OutputStream fs = Files.newOutputStream(input.toPath(), new OpenOption[0]);){
            for (int i = 0; i < 131072; ++i) {
                fs.write(r.nextInt(256));
            }
        }
        long start = System.currentTimeMillis();
        File outputSz = this.newTempFile(input.getName() + ".sz");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             OutputStream os = Files.newOutputStream(outputSz.toPath(), new OpenOption[0]);
             CompressorOutputStream sos = new CompressorStreamFactory().createCompressorOutputStream("snappy-framed", os);){
            byte[] b = IOUtils.toByteArray((InputStream)is);
            sos.write((int)b[0]);
            sos.write(b, 1, b.length - 1);
        }
        is = Files.newInputStream(input.toPath(), new OpenOption[0]);
        try (CompressorInputStream sis = new CompressorStreamFactory().createCompressorInputStream("snappy-framed", Files.newInputStream(outputSz.toPath(), new OpenOption[0]));){
            byte[] expected = IOUtils.toByteArray((InputStream)is);
            byte[] actual = IOUtils.toByteArray((InputStream)sis);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private void testUnarchive(AbstractTest.StreamWrapper<CompressorInputStream> wrapper) throws Exception {
        File input = FramedSnappyTest.getFile("bla.tar.sz");
        File output = this.newTempFile("bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = wrapper.wrap(new BufferedInputStream(is));){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
            Assertions.assertEquals((long)995L, (long)in.getBytesRead());
        }
        File original = FramedSnappyTest.getFile("bla.tar");
        try (InputStream written = Files.newInputStream(output.toPath(), new OpenOption[0]);
             InputStream orig = Files.newInputStream(original.toPath(), new OpenOption[0]);){
            Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)written), (byte[])IOUtils.toByteArray((InputStream)orig));
        }
    }
}

