/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import com.github.marschall.memoryfilesystem.MemoryFileSystemBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipSplitReadOnlySeekableByteChannel;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ZipMemoryFileSystemTest {
    private Path dir;

    static void println(String x) {
    }

    private InputStreamSupplier createPayloadSupplier(ByteArrayInputStream payload) {
        return () -> payload;
    }

    @BeforeEach
    public void setup() throws IOException {
        this.dir = Files.createTempDirectory(UUID.randomUUID().toString(), new FileAttribute[0]);
    }

    @AfterEach
    public void tearDown() throws IOException {
        try (Stream<Path> walk = Files.walk(this.dir, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).peek(path -> ZipMemoryFileSystemTest.println("Deleting: " + path.toAbsolutePath())).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    @Test
    public void testForPathsReturnCorrectClassInMemory() throws IOException {
        Path firstFile = AbstractTest.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        Path secondFile = AbstractTest.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        Path lastFile = AbstractTest.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        byte[] firstBytes = Files.readAllBytes(firstFile);
        byte[] secondBytes = Files.readAllBytes(secondFile);
        byte[] lastBytes = Files.readAllBytes(lastFile);
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Files.write(fileSystem.getPath("split_zip_created_by_zip.z01", new String[0]), firstBytes, new OpenOption[0]);
            Files.write(fileSystem.getPath("split_zip_created_by_zip.z02", new String[0]), secondBytes, new OpenOption[0]);
            Files.write(fileSystem.getPath("split_zip_created_by_zip.zip", new String[0]), lastBytes, new OpenOption[0]);
            ArrayList<Path> list = new ArrayList<Path>();
            list.add(firstFile);
            list.add(secondFile);
            try (SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.forPaths((Path)lastFile, list);){
                Assertions.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
            }
            channel = ZipSplitReadOnlySeekableByteChannel.forPaths((Path[])new Path[]{firstFile, secondFile, lastFile});
            try {
                Assertions.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
            }
            finally {
                if (channel != null) {
                    channel.close();
                }
            }
        }
    }

    @Test
    public void testPositionToSomeZipSplitSegmentInMemory() throws IOException {
        Path firstFile = AbstractTest.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        Path secondFile = AbstractTest.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        Path lastFile = AbstractTest.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        byte[] firstBytes = Files.readAllBytes(firstFile);
        byte[] secondBytes = Files.readAllBytes(secondFile);
        byte[] lastBytes = Files.readAllBytes(lastFile);
        int firstFileSize = firstBytes.length;
        int secondFileSize = secondBytes.length;
        int lastFileSize = lastBytes.length;
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path lastMemoryPath = fileSystem.getPath("split_zip_created_by_zip.zip", new String[0]);
            Files.write(fileSystem.getPath("split_zip_created_by_zip.z01", new String[0]), firstBytes, new OpenOption[0]);
            Files.write(fileSystem.getPath("split_zip_created_by_zip.z02", new String[0]), secondBytes, new OpenOption[0]);
            Files.write(lastMemoryPath, lastBytes, new OpenOption[0]);
            Random random = new Random();
            int randomDiskNumber = random.nextInt(3);
            int randomOffset = randomDiskNumber < 2 ? random.nextInt(firstFileSize) : random.nextInt(lastFileSize);
            try (ZipSplitReadOnlySeekableByteChannel channel = (ZipSplitReadOnlySeekableByteChannel)ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((Path)lastMemoryPath);){
                channel.position((long)randomDiskNumber, (long)randomOffset);
                long expectedPosition = randomOffset;
                expectedPosition += randomDiskNumber > 0 ? (long)firstFileSize : 0L;
                Assertions.assertEquals((long)(expectedPosition += randomDiskNumber > 1 ? (long)secondFileSize : 0L), (long)channel.position());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScatterFileInMemory() throws IOException {
        byte[] B_PAYLOAD = "RBBBBBBS".getBytes();
        byte[] A_PAYLOAD = "XAAY".getBytes();
        Path target = Files.createTempFile(this.dir, "scattertest", ".zip", new FileAttribute[0]);
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path scatterFile = fileSystem.getPath("scattertest.notzip", new String[0]);
            try (ScatterZipOutputStream scatterZipOutputStream = ScatterZipOutputStream.pathBased((Path)scatterFile);){
                ZipArchiveEntry zab = new ZipArchiveEntry("b.txt");
                zab.setMethod(8);
                ByteArrayInputStream payload = new ByteArrayInputStream(B_PAYLOAD);
                scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zab, (InputStreamSupplier)this.createPayloadSupplier(payload)));
                ZipArchiveEntry zae = new ZipArchiveEntry("a.txt");
                zae.setMethod(8);
                ByteArrayInputStream payload1 = new ByteArrayInputStream(A_PAYLOAD);
                scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zae, (InputStreamSupplier)this.createPayloadSupplier(payload1)));
                try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(target, new OpenOption[0]);){
                    scatterZipOutputStream.writeTo(outputStream);
                }
            }
            try (ZipFile zf = new ZipFile(target.toFile());){
                ZipArchiveEntry b_entry = (ZipArchiveEntry)zf.getEntries("b.txt").iterator().next();
                Assertions.assertEquals((long)8L, (long)b_entry.getSize());
                try (InputStream inputStream = zf.getInputStream(b_entry);){
                    Assertions.assertArrayEquals((byte[])B_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
                }
                ZipArchiveEntry a_entry = (ZipArchiveEntry)zf.getEntries("a.txt").iterator().next();
                Assertions.assertEquals((long)4L, (long)a_entry.getSize());
                try (InputStream inputStream = zf.getInputStream(a_entry);){
                    Assertions.assertArrayEquals((byte[])A_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
                }
            }
        }
        finally {
            PathUtils.delete((Path)target);
        }
    }

    @Test
    public void testScatterFileWithCompressionAndTargetInMemory() throws IOException {
        byte[] B_PAYLOAD = "RBBBBBBS".getBytes();
        byte[] A_PAYLOAD = "XAAY".getBytes();
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path target = fileSystem.getPath("scattertest.zip", new String[0]);
            Path scatterFile = fileSystem.getPath("scattertest.notzip", new String[0]);
            try (ScatterZipOutputStream scatterZipOutputStream = ScatterZipOutputStream.pathBased((Path)scatterFile, (int)9);){
                ZipArchiveEntry zab = new ZipArchiveEntry("b.txt");
                zab.setMethod(8);
                ByteArrayInputStream payload = new ByteArrayInputStream(B_PAYLOAD);
                scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zab, (InputStreamSupplier)this.createPayloadSupplier(payload)));
                ZipArchiveEntry zae = new ZipArchiveEntry("a.txt");
                zae.setMethod(8);
                ByteArrayInputStream payload1 = new ByteArrayInputStream(A_PAYLOAD);
                scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zae, (InputStreamSupplier)this.createPayloadSupplier(payload1)));
                try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(target, new OpenOption[0]);){
                    scatterZipOutputStream.writeTo(outputStream);
                }
            }
            try (ZipFile zf = new ZipFile(Files.newByteChannel(target, StandardOpenOption.READ), target.getFileName().toString(), "UTF-8", true);){
                ZipArchiveEntry b_entry = (ZipArchiveEntry)zf.getEntries("b.txt").iterator().next();
                Assertions.assertEquals((long)8L, (long)b_entry.getSize());
                try (InputStream inputStream = zf.getInputStream(b_entry);){
                    Assertions.assertArrayEquals((byte[])B_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
                }
                ZipArchiveEntry a_entry = (ZipArchiveEntry)zf.getEntries("a.txt").iterator().next();
                Assertions.assertEquals((long)4L, (long)a_entry.getSize());
                try (InputStream inputStream = zf.getInputStream(a_entry);){
                    Assertions.assertArrayEquals((byte[])A_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
                }
            }
        }
    }

    @Test
    public void testScatterFileWithCompressionInMemory() throws IOException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path scatterFile = fileSystem.getPath("scattertest.notzip", new String[0]);
            Path target = Files.createTempFile(this.dir, "scattertest", ".zip", new FileAttribute[0]);
            byte[] B_PAYLOAD = "RBBBBBBS".getBytes();
            byte[] A_PAYLOAD = "XAAY".getBytes();
            try (ScatterZipOutputStream scatterZipOutputStream = ScatterZipOutputStream.pathBased((Path)scatterFile, (int)9);){
                ZipArchiveEntry zab = new ZipArchiveEntry("b.txt");
                zab.setMethod(8);
                ByteArrayInputStream payload = new ByteArrayInputStream(B_PAYLOAD);
                scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zab, (InputStreamSupplier)this.createPayloadSupplier(payload)));
                ZipArchiveEntry zae = new ZipArchiveEntry("a.txt");
                zae.setMethod(8);
                ByteArrayInputStream payload1 = new ByteArrayInputStream(A_PAYLOAD);
                scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zae, (InputStreamSupplier)this.createPayloadSupplier(payload1)));
                try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(target, new OpenOption[0]);){
                    scatterZipOutputStream.writeTo(outputStream);
                }
            }
            try (ZipFile zf = new ZipFile(target.toFile());){
                ZipArchiveEntry b_entry = (ZipArchiveEntry)zf.getEntries("b.txt").iterator().next();
                Assertions.assertEquals((long)8L, (long)b_entry.getSize());
                try (InputStream inputStream = zf.getInputStream(b_entry);){
                    Assertions.assertArrayEquals((byte[])B_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
                }
                ZipArchiveEntry a_entry = (ZipArchiveEntry)zf.getEntries("a.txt").iterator().next();
                Assertions.assertEquals((long)4L, (long)a_entry.getSize());
                try (InputStream inputStream = zf.getInputStream(a_entry);){
                    Assertions.assertArrayEquals((byte[])A_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
                }
            }
        }
    }

    @Test
    public void testZipFileInMemory() throws IOException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path scatterFile = fileSystem.getPath("scattertest.notzip", new String[0]);
            Path target = fileSystem.getPath("scattertest.zip", new String[0]);
            byte[] B_PAYLOAD = "RBBBBBBS".getBytes();
            byte[] A_PAYLOAD = "XAAY".getBytes();
            try (ScatterZipOutputStream scatterZipOutputStream = ScatterZipOutputStream.pathBased((Path)scatterFile, (int)9);){
                ZipArchiveEntry zab = new ZipArchiveEntry("b.txt");
                zab.setMethod(8);
                ByteArrayInputStream payload = new ByteArrayInputStream(B_PAYLOAD);
                scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zab, (InputStreamSupplier)this.createPayloadSupplier(payload)));
                ZipArchiveEntry zae = new ZipArchiveEntry("a.txt");
                zae.setMethod(8);
                ByteArrayInputStream payload1 = new ByteArrayInputStream(A_PAYLOAD);
                scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zae, (InputStreamSupplier)this.createPayloadSupplier(payload1)));
                try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(target, new OpenOption[0]);){
                    scatterZipOutputStream.writeTo(outputStream);
                }
            }
            try (ZipFile zf = new ZipFile(target);){
                ZipArchiveEntry b_entry = (ZipArchiveEntry)zf.getEntries("b.txt").iterator().next();
                Assertions.assertEquals((long)8L, (long)b_entry.getSize());
                try (InputStream inputStream = zf.getInputStream(b_entry);){
                    Assertions.assertArrayEquals((byte[])B_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
                }
                ZipArchiveEntry a_entry = (ZipArchiveEntry)zf.getEntries("a.txt").iterator().next();
                Assertions.assertEquals((long)4L, (long)a_entry.getSize());
                try (InputStream inputStream = zf.getInputStream(a_entry);){
                    Assertions.assertArrayEquals((byte[])A_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
                }
            }
        }
    }

    @Test
    public void testZipFromMemoryFileSystemFile() throws IOException, NoSuchAlgorithmException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path textFileInMemSys = fileSystem.getPath("test.txt", new String[0]);
            byte[] bytes = new byte[102400];
            SecureRandom.getInstanceStrong().nextBytes(bytes);
            Files.write(textFileInMemSys, bytes, new OpenOption[0]);
            Path zipInLocalSys = Files.createTempFile(this.dir, "commons-compress-memoryfs", ".zip", new FileAttribute[0]);
            try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(zipInLocalSys.toFile());){
                ZipArchiveEntry entry = new ZipArchiveEntry(textFileInMemSys, textFileInMemSys.getFileName().toString(), new LinkOption[0]);
                entry.setSize(Files.size(textFileInMemSys));
                zipOut.putArchiveEntry(entry);
                Files.copy(textFileInMemSys, (OutputStream)zipOut);
                zipOut.closeArchiveEntry();
                zipOut.finish();
                Assertions.assertEquals((long)Files.size(zipInLocalSys), (long)zipOut.getBytesWritten());
            }
        }
    }

    @Test
    public void testZipFromMemoryFileSystemOutputStream() throws IOException, ArchiveException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path p = fileSystem.getPath("test.txt", new String[0]);
            Files.write(p, "Test".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Path f = Files.createTempFile(this.dir, "commons-compress-memoryfs", ".zip", new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(f, new OpenOption[0]);
                 ArchiveOutputStream zipOut = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("zip", out);){
                ZipArchiveEntry entry = new ZipArchiveEntry(p, p.getFileName().toString(), new LinkOption[0]);
                entry.setSize(Files.size(p));
                zipOut.putArchiveEntry((ArchiveEntry)entry);
                Files.copy(p, (OutputStream)zipOut);
                zipOut.closeArchiveEntry();
                Assertions.assertEquals((long)Files.size(f), (long)zipOut.getBytesWritten());
            }
        }
    }

    @Test
    public void testZipFromMemoryFileSystemPath() throws IOException, NoSuchAlgorithmException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path textFileInMemSys = fileSystem.getPath("test.txt", new String[0]);
            byte[] bytes = new byte[102400];
            SecureRandom.getInstanceStrong().nextBytes(bytes);
            Files.write(textFileInMemSys, bytes, new OpenOption[0]);
            Path zipInLocalSys = Files.createTempFile(this.dir, "commons-compress-memoryfs", ".zip", new FileAttribute[0]);
            try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(zipInLocalSys, new OpenOption[0]);){
                ZipArchiveEntry entry = new ZipArchiveEntry(textFileInMemSys, textFileInMemSys.getFileName().toString(), new LinkOption[0]);
                entry.setSize(Files.size(textFileInMemSys));
                zipOut.putArchiveEntry(entry);
                Files.copy(textFileInMemSys, (OutputStream)zipOut);
                zipOut.closeArchiveEntry();
                zipOut.finish();
                Assertions.assertEquals((long)Files.size(zipInLocalSys), (long)zipOut.getBytesWritten());
            }
        }
    }

    @Test
    public void testZipFromMemoryFileSystemSeekableByteChannel() throws IOException, NoSuchAlgorithmException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path textFileInMemSys = fileSystem.getPath("test.txt", new String[0]);
            byte[] bytes = new byte[102400];
            SecureRandom.getInstanceStrong().nextBytes(bytes);
            Files.write(textFileInMemSys, bytes, new OpenOption[0]);
            Path zipInLocalSys = Files.createTempFile(this.dir, "commons-compress-memoryfs", ".zip", new FileAttribute[0]);
            try (SeekableByteChannel byteChannel = Files.newByteChannel(zipInLocalSys, EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING), new FileAttribute[0]);
                 ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(byteChannel);){
                ZipArchiveEntry entry = new ZipArchiveEntry(textFileInMemSys, textFileInMemSys.getFileName().toString(), new LinkOption[0]);
                entry.setSize(Files.size(textFileInMemSys));
                zipOut.putArchiveEntry(entry);
                Files.copy(textFileInMemSys, (OutputStream)zipOut);
                zipOut.closeArchiveEntry();
                zipOut.finish();
                Assertions.assertEquals((long)Files.size(zipInLocalSys), (long)zipOut.getBytesWritten());
            }
        }
    }

    @Test
    public void testZipFromMemoryFileSystemSplitFile() throws IOException, NoSuchAlgorithmException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path textFileInMemSys = fileSystem.getPath("test.txt", new String[0]);
            byte[] bytes = new byte[102400];
            SecureRandom.getInstanceStrong().nextBytes(bytes);
            Files.write(textFileInMemSys, bytes, new OpenOption[0]);
            Path zipInLocalSys = Files.createTempFile(this.dir, "commons-compress-memoryfs", ".zip", new FileAttribute[0]);
            try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(zipInLocalSys.toFile(), 65536L);){
                List splitZips;
                ZipArchiveEntry entry = new ZipArchiveEntry(textFileInMemSys, textFileInMemSys.getFileName().toString(), new LinkOption[0]);
                entry.setSize(Files.size(textFileInMemSys));
                zipOut.putArchiveEntry(entry);
                Files.copy(textFileInMemSys, (OutputStream)zipOut);
                zipOut.closeArchiveEntry();
                zipOut.finish();
                try (Stream<Path> paths = Files.walk(this.dir, 1, new FileVisitOption[0]);){
                    splitZips = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).peek(path -> ZipMemoryFileSystemTest.println("Found: " + path.toAbsolutePath())).collect(Collectors.toList());
                }
                Assertions.assertEquals((int)splitZips.size(), (int)2);
                Assertions.assertEquals((long)(Files.size((Path)splitZips.get(0)) + Files.size((Path)splitZips.get(1)) - 4L), (long)zipOut.getBytesWritten());
            }
        }
    }

    @Test
    public void testZipToMemoryFileSystemOutputStream() throws IOException, ArchiveException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path p = fileSystem.getPath("target.zip", new String[0]);
            try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);
                 ArchiveOutputStream zipOut = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("zip", out);){
                String content = "Test";
                ZipArchiveEntry entry = new ZipArchiveEntry("test.txt");
                entry.setSize((long)"Test".length());
                zipOut.putArchiveEntry((ArchiveEntry)entry);
                zipOut.write("Test".getBytes(StandardCharsets.UTF_8));
                zipOut.closeArchiveEntry();
                Assertions.assertTrue((boolean)Files.exists(p, new LinkOption[0]));
                Assertions.assertEquals((long)Files.size(p), (long)zipOut.getBytesWritten());
            }
        }
    }

    @Test
    public void testZipToMemoryFileSystemPath() throws IOException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path zipInMemSys = fileSystem.getPath("target.zip", new String[0]);
            try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(zipInMemSys, new OpenOption[0]);){
                String content = "Test";
                ZipArchiveEntry entry = new ZipArchiveEntry("test.txt");
                entry.setSize((long)"Test".length());
                zipOut.putArchiveEntry(entry);
                zipOut.write("Test".getBytes(StandardCharsets.UTF_8));
                zipOut.closeArchiveEntry();
                Assertions.assertTrue((boolean)Files.exists(zipInMemSys, new LinkOption[0]));
                Assertions.assertEquals((long)Files.size(zipInMemSys), (long)zipOut.getBytesWritten());
            }
        }
    }

    @Test
    public void testZipToMemoryFileSystemSeekableByteChannel() throws IOException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path zipInMemSys = fileSystem.getPath("target.zip", new String[0]);
            try (SeekableByteChannel byteChannel = Files.newByteChannel(zipInMemSys, EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE_NEW), new FileAttribute[0]);
                 ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(byteChannel);){
                String content = "Test";
                ZipArchiveEntry entry = new ZipArchiveEntry("test.txt");
                entry.setSize((long)"Test".length());
                zipOut.putArchiveEntry(entry);
                zipOut.write("Test".getBytes(StandardCharsets.UTF_8));
                zipOut.closeArchiveEntry();
                Assertions.assertTrue((boolean)Files.exists(zipInMemSys, new LinkOption[0]));
                Assertions.assertEquals((long)Files.size(zipInMemSys), (long)zipOut.getBytesWritten());
            }
        }
    }

    @Test
    public void testZipToMemoryFileSystemSplitPath() throws IOException, NoSuchAlgorithmException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path zipInMemSys = fileSystem.getPath("target.zip", new String[0]);
            byte[] bytes = new byte[102400];
            SecureRandom.getInstanceStrong().nextBytes(bytes);
            try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(zipInMemSys, 65536L);){
                List splitZips;
                ZipArchiveEntry entry = new ZipArchiveEntry("test.txt");
                entry.setSize((long)bytes.length);
                zipOut.putArchiveEntry(entry);
                zipOut.write(bytes);
                zipOut.closeArchiveEntry();
                zipOut.finish();
                try (Stream<Path> paths = Files.walk(fileSystem.getPath(".", new String[0]), 1, new FileVisitOption[0]);){
                    splitZips = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).peek(path -> ZipMemoryFileSystemTest.println("Found: " + path.toAbsolutePath())).collect(Collectors.toList());
                }
                Assertions.assertEquals((int)splitZips.size(), (int)2);
                Assertions.assertEquals((long)(Files.size((Path)splitZips.get(0)) + Files.size((Path)splitZips.get(1)) - 4L), (long)zipOut.getBytesWritten());
            }
        }
    }
}

