/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.NoSuchElementException;
import java.util.zip.ZipException;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.ExtraFieldParsingBehavior;
import org.apache.commons.compress.archivers.zip.ExtraFieldUtilsTest;
import org.apache.commons.compress.archivers.zip.UnparseableExtraFieldData;
import org.apache.commons.compress.archivers.zip.UnrecognizedExtraField;
import org.apache.commons.compress.archivers.zip.X000A_NTFS;
import org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;
import org.apache.commons.compress.archivers.zip.ZipUtilTest;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.TimeUtils;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZipArchiveEntryTest {
    @Test
    public void bestEffortIncludesUnparseableExtraData() throws Exception {
        ZipExtraField[] extraFields = this.parsingModeBehaviorTestData();
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setExtraFields(extraFields);
        ZipExtraField[] read = ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.BEST_EFFORT);
        Assertions.assertEquals((int)extraFields.length, (int)read.length);
    }

    private ZipExtraField[] parsingModeBehaviorTestData() {
        AsiExtraField a = new AsiExtraField();
        a.setDirectory(true);
        a.setMode(493);
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u.setLocalFileDataData(ByteUtils.EMPTY_BYTE_ARRAY);
        UnparseableExtraFieldData x = new UnparseableExtraFieldData();
        byte[] unparseable = new byte[]{0, 0, -1, -1, 0, 0, 0};
        x.parseFromLocalFileData(unparseable, 0, unparseable.length);
        return new ZipExtraField[]{a, u, x};
    }

    @Test
    public void testAddAsFirstExtraField() {
        AsiExtraField a = new AsiExtraField();
        a.setDirectory(true);
        a.setMode(493);
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u.setLocalFileDataData(ByteUtils.EMPTY_BYTE_ARRAY);
        ZipArchiveEntry ze = new ZipArchiveEntry("test/");
        ze.setExtraFields(new ZipExtraField[]{a, u});
        byte[] data1 = ze.getExtra();
        UnrecognizedExtraField u2 = new UnrecognizedExtraField();
        u2.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u2.setLocalFileDataData(new byte[]{1});
        ze.addAsFirstExtraField((ZipExtraField)u2);
        byte[] data2 = ze.getExtra();
        ZipExtraField[] result = ze.getExtraFields();
        Assertions.assertEquals((int)2, (int)result.length, (String)"second pass");
        Assertions.assertSame((Object)u2, (Object)result[0]);
        Assertions.assertSame((Object)a, (Object)result[1]);
        Assertions.assertEquals((int)(data1.length + 1), (int)data2.length, (String)"length second pass");
        UnrecognizedExtraField u3 = new UnrecognizedExtraField();
        u3.setHeaderId(new ZipShort(2));
        u3.setLocalFileDataData(new byte[]{1});
        ze.addAsFirstExtraField((ZipExtraField)u3);
        result = ze.getExtraFields();
        Assertions.assertEquals((int)3, (int)result.length, (String)"third pass");
        Assertions.assertSame((Object)u3, (Object)result[0]);
        Assertions.assertSame((Object)u2, (Object)result[1]);
        Assertions.assertSame((Object)a, (Object)result[2]);
    }

    @Test
    public void testCompressionMethod() throws Exception {
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)new ByteArrayOutputStream());){
            ZipArchiveEntry entry = new ZipArchiveEntry("foo");
            Assertions.assertEquals((int)-1, (int)entry.getMethod());
            Assertions.assertFalse((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
            entry.setMethod(0);
            Assertions.assertEquals((int)0, (int)entry.getMethod());
            Assertions.assertTrue((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
            entry.setMethod(8);
            Assertions.assertEquals((int)8, (int)entry.getMethod());
            Assertions.assertTrue((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
            entry.setMethod(6);
            Assertions.assertEquals((int)6, (int)entry.getMethod());
            Assertions.assertFalse((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
        }
    }

    @Test
    public void testCopyConstructor() throws Exception {
        ZipArchiveEntry archiveEntry = new ZipArchiveEntry("fred");
        archiveEntry.setUnixMode(436);
        archiveEntry.setMethod(8);
        archiveEntry.getGeneralPurposeBit().useStrongEncryption(true);
        ZipArchiveEntry copy = new ZipArchiveEntry(archiveEntry);
        Assertions.assertEquals((Object)archiveEntry, (Object)copy);
    }

    @Test
    public void testDraconicThrowsOnUnparseableExtraData() throws Exception {
        ZipExtraField[] extraFields = this.parsingModeBehaviorTestData();
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setExtraFields(extraFields);
        Assertions.assertThrows(ZipException.class, () -> ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.DRACONIC));
    }

    @Test
    public void testExtraFieldMerging() {
        AsiExtraField a = new AsiExtraField();
        a.setDirectory(true);
        a.setMode(493);
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u.setLocalFileDataData(ByteUtils.EMPTY_BYTE_ARRAY);
        ZipArchiveEntry ze = new ZipArchiveEntry("test/");
        ze.setExtraFields(new ZipExtraField[]{a, u});
        byte[] b = ExtraFieldUtilsTest.UNRECOGNIZED_HEADER.getBytes();
        ze.setCentralDirectoryExtra(new byte[]{b[0], b[1], 1, 0, 127});
        ZipExtraField[] result = ze.getExtraFields();
        Assertions.assertEquals((int)2, (int)result.length, (String)"first pass");
        Assertions.assertSame((Object)a, (Object)result[0]);
        Assertions.assertEquals((Object)ExtraFieldUtilsTest.UNRECOGNIZED_HEADER, (Object)result[1].getHeaderId());
        Assertions.assertEquals((Object)new ZipShort(0), (Object)result[1].getLocalFileDataLength());
        Assertions.assertEquals((Object)new ZipShort(1), (Object)result[1].getCentralDirectoryLength());
        ze.setCentralDirectoryExtra(new byte[]{2, 0, 0, 0});
        result = ze.getExtraFields();
        Assertions.assertEquals((int)3, (int)result.length, (String)"second pass");
        ze.setExtra(new byte[]{2, 0, 1, 0, 127});
        result = ze.getExtraFields();
        Assertions.assertEquals((int)3, (int)result.length, (String)"third pass");
        Assertions.assertSame((Object)a, (Object)result[0]);
        Assertions.assertEquals((Object)new ZipShort(2), (Object)result[2].getHeaderId());
        Assertions.assertEquals((Object)new ZipShort(1), (Object)result[2].getLocalFileDataLength());
        Assertions.assertEquals((Object)new ZipShort(0), (Object)result[2].getCentralDirectoryLength());
    }

    @Test
    public void testExtraFields() {
        AsiExtraField a = new AsiExtraField();
        a.setDirectory(true);
        a.setMode(493);
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u.setLocalFileDataData(ByteUtils.EMPTY_BYTE_ARRAY);
        ZipArchiveEntry ze = new ZipArchiveEntry("test/");
        ze.setExtraFields(new ZipExtraField[]{a, u});
        byte[] data1 = ze.getExtra();
        ZipExtraField[] result = ze.getExtraFields();
        Assertions.assertEquals((int)2, (int)result.length, (String)"first pass");
        Assertions.assertSame((Object)a, (Object)result[0]);
        Assertions.assertSame((Object)u, (Object)result[1]);
        UnrecognizedExtraField u2 = new UnrecognizedExtraField();
        u2.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u2.setLocalFileDataData(new byte[]{1});
        ze.addExtraField((ZipExtraField)u2);
        byte[] data2 = ze.getExtra();
        result = ze.getExtraFields();
        Assertions.assertEquals((int)2, (int)result.length, (String)"second pass");
        Assertions.assertSame((Object)a, (Object)result[0]);
        Assertions.assertSame((Object)u2, (Object)result[1]);
        Assertions.assertEquals((int)(data1.length + 1), (int)data2.length, (String)"length second pass");
        UnrecognizedExtraField u3 = new UnrecognizedExtraField();
        u3.setHeaderId(new ZipShort(2));
        u3.setLocalFileDataData(new byte[]{1});
        ze.addExtraField((ZipExtraField)u3);
        result = ze.getExtraFields();
        Assertions.assertEquals((int)3, (int)result.length, (String)"third pass");
        ze.removeExtraField(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        byte[] data3 = ze.getExtra();
        result = ze.getExtraFields();
        Assertions.assertEquals((int)2, (int)result.length, (String)"fourth pass");
        Assertions.assertSame((Object)a, (Object)result[0]);
        Assertions.assertSame((Object)u3, (Object)result[1]);
        Assertions.assertEquals((int)data2.length, (int)data3.length, (String)"length fourth pass");
        Assertions.assertThrows(NoSuchElementException.class, () -> ze.removeExtraField(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER), (String)"should be no such element");
    }

    @Test
    public void testIsUnixSymlink() {
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setUnixMode(40960);
        Assertions.assertTrue((boolean)ze.isUnixSymlink());
        ze.setUnixMode(57344);
        Assertions.assertFalse((boolean)ze.isUnixSymlink());
    }

    @Test
    public void testIsUnixSymlinkIsFalseIfMoreThanOneFlagIsSet() throws Exception {
        try (ZipFile zf = new ZipFile(AbstractTest.getFile("COMPRESS-379.jar"));){
            ZipArchiveEntry ze = zf.getEntry("META-INF/maven/");
            Assertions.assertFalse((boolean)ze.isUnixSymlink());
        }
    }

    @Test
    public void testNotEquals() {
        ZipArchiveEntry entry1 = new ZipArchiveEntry("foo");
        ZipArchiveEntry entry2 = new ZipArchiveEntry("bar");
        Assertions.assertNotEquals((Object)entry1, (Object)entry2);
    }

    @Test
    public void testNullCommentEqualsEmptyComment() {
        ZipArchiveEntry entry1 = new ZipArchiveEntry("foo");
        ZipArchiveEntry entry2 = new ZipArchiveEntry("foo");
        ZipArchiveEntry entry3 = new ZipArchiveEntry("foo");
        entry1.setComment(null);
        entry2.setComment("");
        entry3.setComment("bar");
        Assertions.assertEquals((Object)entry1, (Object)entry2);
        Assertions.assertNotEquals((Object)entry1, (Object)entry3);
        Assertions.assertNotEquals((Object)entry2, (Object)entry3);
    }

    @Test
    public void testOnlyParseableLenientExcludesUnparseableExtraData() throws Exception {
        ZipExtraField[] extraFields = this.parsingModeBehaviorTestData();
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setExtraFields(extraFields);
        ZipExtraField[] read = ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.ONLY_PARSEABLE_LENIENT);
        Assertions.assertEquals((int)extraFields.length, (int)(read.length + 1));
    }

    @Test
    public void testOnlyParseableStrictExcludesUnparseableExtraData() throws Exception {
        ZipExtraField[] extraFields = this.parsingModeBehaviorTestData();
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setExtraFields(extraFields);
        ZipExtraField[] read = ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.ONLY_PARSEABLE_STRICT);
        Assertions.assertEquals((int)extraFields.length, (int)(read.length + 1));
    }

    @Test
    public void testReparsingUnicodeExtraWithUnsupportedversionThrowsInStrictMode() throws Exception {
        try (ZipFile zf = new ZipFile(AbstractTest.getFile("COMPRESS-479.zip"));){
            ZipArchiveEntry ze = zf.getEntry("%U20AC_for_Dollar.txt");
            Assertions.assertThrows(ZipException.class, () -> ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.STRICT_FOR_KNOW_EXTRA_FIELDS));
        }
    }

    @Test
    public void testShouldNotSetExtraDateFieldsIfDateFitsInDosDates() {
        ZipArchiveEntry ze = new ZipArchiveEntry();
        FileTime time = FileTime.from(ZipUtilTest.toLocalInstant("2022-12-28T20:39:33.1234567"));
        ze.setTime(time);
        Assertions.assertEquals((long)time.toMillis(), (long)ze.getTime());
        Assertions.assertEquals((long)time.toMillis(), (long)ze.getLastModifiedTime().toMillis());
        Assert.assertNull((Object)ze.getExtraField(X5455_ExtendedTimestamp.HEADER_ID));
        Assert.assertNull((Object)ze.getExtraField(X000A_NTFS.HEADER_ID));
        long dosTime = ZipLong.getValue((byte[])ZipUtil.toDosTime((long)ze.getTime()));
        ZipUtilTest.assertDosDate(dosTime, 2022, 12, 28, 20, 39, 32);
    }

    @Test
    public void testShouldNotSetInfoZipFieldIfAnyDatesExceedUnixTime() {
        ZipArchiveEntry ze = new ZipArchiveEntry();
        FileTime accessTime = FileTime.from(Instant.parse("2022-12-29T21:40:34.1234567Z"));
        FileTime creationTime = FileTime.from(Instant.parse("2038-12-28T20:39:33.1234567Z"));
        long time = Instant.parse("2020-03-04T12:34:56.1234567Z").toEpochMilli();
        ze.setTime(time);
        ze.setLastAccessTime(accessTime);
        ze.setCreationTime(creationTime);
        Assertions.assertEquals((long)time, (long)ze.getTime());
        Assertions.assertEquals((long)time, (long)ze.getLastModifiedTime().toMillis());
        Assert.assertNull((Object)ze.getExtraField(X5455_ExtendedTimestamp.HEADER_ID));
        X000A_NTFS ntfs = (X000A_NTFS)ze.getExtraField(X000A_NTFS.HEADER_ID);
        Assertions.assertNotNull((Object)ntfs);
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((long)time), (long)ntfs.getModifyTime().getLongValue());
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((FileTime)accessTime), (long)ntfs.getAccessTime().getLongValue());
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((FileTime)creationTime), (long)ntfs.getCreateTime().getLongValue());
    }

    @Test
    public void testShouldNotSetInfoZipFieldIfDateExceedsUnixTime() {
        ZipArchiveEntry ze = new ZipArchiveEntry();
        FileTime time = FileTime.from(ZipUtilTest.toLocalInstant("2138-11-27T00:00:00"));
        ze.setTime(time.toMillis());
        Assertions.assertEquals((long)time.toMillis(), (long)ze.getTime());
        Assertions.assertEquals((Object)time, (Object)ze.getLastModifiedTime());
        Assert.assertNull((Object)ze.getExtraField(X5455_ExtendedTimestamp.HEADER_ID));
        X000A_NTFS ntfs = (X000A_NTFS)ze.getExtraField(X000A_NTFS.HEADER_ID);
        Assertions.assertNotNull((Object)ntfs);
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((FileTime)time), (long)ntfs.getModifyTime().getLongValue());
        Assertions.assertEquals((long)0L, (long)ntfs.getAccessTime().getLongValue());
        Assertions.assertEquals((long)0L, (long)ntfs.getCreateTime().getLongValue());
    }

    @Test
    public void testShouldSetExtraDateFieldsIfAccessDateIsSet() {
        ZipArchiveEntry ze = new ZipArchiveEntry();
        FileTime lastAccessTime = FileTime.from(Instant.parse("2022-12-28T20:39:33.1234567Z"));
        long time = Instant.parse("2020-03-04T12:34:56.1234567Z").toEpochMilli();
        ze.setTime(time);
        ze.setLastAccessTime(lastAccessTime);
        Assertions.assertEquals((long)time, (long)ze.getTime());
        Assertions.assertEquals((long)time, (long)ze.getLastModifiedTime().toMillis());
        X5455_ExtendedTimestamp extendedTimestamp = (X5455_ExtendedTimestamp)ze.getExtraField(X5455_ExtendedTimestamp.HEADER_ID);
        Assertions.assertNotNull((Object)extendedTimestamp);
        Assertions.assertEquals((long)TimeUtils.toUnixTime((FileTime)lastAccessTime), (long)extendedTimestamp.getAccessTime().getValue());
        Assert.assertNull((Object)extendedTimestamp.getCreateTime());
        X000A_NTFS ntfs = (X000A_NTFS)ze.getExtraField(X000A_NTFS.HEADER_ID);
        Assertions.assertNotNull((Object)ntfs);
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((long)time), (long)ntfs.getModifyTime().getLongValue());
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((FileTime)lastAccessTime), (long)ntfs.getAccessTime().getLongValue());
        Assertions.assertEquals((long)0L, (long)ntfs.getCreateTime().getLongValue());
    }

    @Test
    public void testShouldSetExtraDateFieldsIfAllDatesAreSet() {
        ZipArchiveEntry ze = new ZipArchiveEntry();
        FileTime accessTime = FileTime.from(Instant.parse("2022-12-29T21:40:34.1234567Z"));
        FileTime creationTime = FileTime.from(Instant.parse("2022-12-28T20:39:33.1234567Z"));
        long time = Instant.parse("2020-03-04T12:34:56.1234567Z").toEpochMilli();
        ze.setTime(time);
        ze.setLastAccessTime(accessTime);
        ze.setCreationTime(creationTime);
        Assertions.assertEquals((long)time, (long)ze.getTime());
        Assertions.assertEquals((long)time, (long)ze.getLastModifiedTime().toMillis());
        X5455_ExtendedTimestamp extendedTimestamp = (X5455_ExtendedTimestamp)ze.getExtraField(X5455_ExtendedTimestamp.HEADER_ID);
        Assertions.assertNotNull((Object)extendedTimestamp);
        Assertions.assertEquals((long)TimeUtils.toUnixTime((FileTime)accessTime), (long)extendedTimestamp.getAccessTime().getValue());
        Assertions.assertEquals((long)TimeUtils.toUnixTime((FileTime)creationTime), (long)extendedTimestamp.getCreateTime().getValue());
        X000A_NTFS ntfs = (X000A_NTFS)ze.getExtraField(X000A_NTFS.HEADER_ID);
        Assertions.assertNotNull((Object)ntfs);
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((long)time), (long)ntfs.getModifyTime().getLongValue());
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((FileTime)accessTime), (long)ntfs.getAccessTime().getLongValue());
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((FileTime)creationTime), (long)ntfs.getCreateTime().getLongValue());
    }

    @Test
    public void testShouldSetExtraDateFieldsIfCreationDateIsSet() {
        ZipArchiveEntry ze = new ZipArchiveEntry();
        FileTime creationTime = FileTime.from(Instant.parse("2022-12-28T20:39:33.1234567Z"));
        long time = Instant.parse("2020-03-04T12:34:56.1234567Z").toEpochMilli();
        ze.setTime(time);
        ze.setCreationTime(creationTime);
        Assertions.assertEquals((long)time, (long)ze.getTime());
        Assertions.assertEquals((long)time, (long)ze.getLastModifiedTime().toMillis());
        X5455_ExtendedTimestamp extendedTimestamp = (X5455_ExtendedTimestamp)ze.getExtraField(X5455_ExtendedTimestamp.HEADER_ID);
        Assertions.assertNotNull((Object)extendedTimestamp);
        Assert.assertNull((Object)extendedTimestamp.getAccessTime());
        Assertions.assertEquals((long)TimeUtils.toUnixTime((FileTime)creationTime), (long)extendedTimestamp.getCreateTime().getValue());
        X000A_NTFS ntfs = (X000A_NTFS)ze.getExtraField(X000A_NTFS.HEADER_ID);
        Assertions.assertNotNull((Object)ntfs);
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((long)time), (long)ntfs.getModifyTime().getLongValue());
        Assertions.assertEquals((long)0L, (long)ntfs.getAccessTime().getLongValue());
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((FileTime)creationTime), (long)ntfs.getCreateTime().getLongValue());
    }

    @Test
    public void testShouldSetExtraDateFieldsIfDateExceedsDosDate() {
        ZipArchiveEntry ze = new ZipArchiveEntry();
        FileTime time = FileTime.from(ZipUtilTest.toLocalInstant("1975-11-27T00:00:00"));
        ze.setTime(time.toMillis());
        Assertions.assertEquals((long)time.toMillis(), (long)ze.getTime());
        Assertions.assertEquals((Object)time, (Object)ze.getLastModifiedTime());
        X5455_ExtendedTimestamp extendedTimestamp = (X5455_ExtendedTimestamp)ze.getExtraField(X5455_ExtendedTimestamp.HEADER_ID);
        Assertions.assertNotNull((Object)extendedTimestamp);
        Assertions.assertEquals((long)TimeUtils.toUnixTime((FileTime)time), (long)extendedTimestamp.getModifyTime().getValue());
        Assert.assertNull((Object)extendedTimestamp.getAccessTime());
        Assert.assertNull((Object)extendedTimestamp.getCreateTime());
        X000A_NTFS ntfs = (X000A_NTFS)ze.getExtraField(X000A_NTFS.HEADER_ID);
        Assertions.assertNotNull((Object)ntfs);
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((FileTime)time), (long)ntfs.getModifyTime().getLongValue());
        Assertions.assertEquals((long)0L, (long)ntfs.getAccessTime().getLongValue());
        Assertions.assertEquals((long)0L, (long)ntfs.getCreateTime().getLongValue());
    }

    @Test
    public void testShouldSetExtraDateFieldsIfModifyDateIsExplicitlySet() {
        ZipArchiveEntry ze = new ZipArchiveEntry();
        FileTime time = FileTime.from(Instant.parse("2022-12-28T20:39:33.1234567Z"));
        ze.setLastModifiedTime(time);
        Assertions.assertEquals((long)time.toMillis(), (long)ze.getTime());
        Assertions.assertEquals((Object)time, (Object)ze.getLastModifiedTime());
        X5455_ExtendedTimestamp extendedTimestamp = (X5455_ExtendedTimestamp)ze.getExtraField(X5455_ExtendedTimestamp.HEADER_ID);
        Assertions.assertNotNull((Object)extendedTimestamp);
        Assertions.assertEquals((long)TimeUtils.toUnixTime((FileTime)time), (long)extendedTimestamp.getModifyTime().getValue());
        Assert.assertNull((Object)extendedTimestamp.getAccessTime());
        Assert.assertNull((Object)extendedTimestamp.getCreateTime());
        X000A_NTFS ntfs = (X000A_NTFS)ze.getExtraField(X000A_NTFS.HEADER_ID);
        Assertions.assertNotNull((Object)ntfs);
        Assertions.assertEquals((long)TimeUtils.toNtfsTime((FileTime)time), (long)ntfs.getModifyTime().getLongValue());
        Assertions.assertEquals((long)0L, (long)ntfs.getAccessTime().getLongValue());
        Assertions.assertEquals((long)0L, (long)ntfs.getCreateTime().getLongValue());
    }

    @Test
    public void testStrictForKnowExtraFieldsIncludesUnparseableExtraData() throws Exception {
        ZipExtraField[] extraFields = this.parsingModeBehaviorTestData();
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setExtraFields(extraFields);
        ZipExtraField[] read = ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.STRICT_FOR_KNOW_EXTRA_FIELDS);
        Assertions.assertEquals((int)extraFields.length, (int)read.length);
    }

    @Test
    public void testUnixMode() {
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        Assertions.assertEquals((int)0, (int)ze.getPlatform());
        ze.setUnixMode(493);
        Assertions.assertEquals((int)3, (int)ze.getPlatform());
        Assertions.assertEquals((long)493L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        Assertions.assertEquals((long)0L, (long)(ze.getExternalAttributes() & 0xFFFFL));
        ze.setUnixMode(292);
        Assertions.assertEquals((int)3, (int)ze.getPlatform());
        Assertions.assertEquals((long)292L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        Assertions.assertEquals((long)1L, (long)(ze.getExternalAttributes() & 0xFFFFL));
        ze = new ZipArchiveEntry("foo/");
        Assertions.assertEquals((int)0, (int)ze.getPlatform());
        ze.setUnixMode(511);
        Assertions.assertEquals((int)3, (int)ze.getPlatform());
        Assertions.assertEquals((long)511L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        Assertions.assertEquals((long)16L, (long)(ze.getExternalAttributes() & 0xFFFFL));
        ze.setUnixMode(383);
        Assertions.assertEquals((int)3, (int)ze.getPlatform());
        Assertions.assertEquals((long)383L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        Assertions.assertEquals((long)17L, (long)(ze.getExternalAttributes() & 0xFFFFL));
    }

    @Test
    public void testZipArchiveClone() throws Exception {
        try (ZipFile zf = new ZipFile(AbstractTest.getFile("COMPRESS-479.zip"));){
            ZipArchiveEntry ze = zf.getEntry("%U20AC_for_Dollar.txt");
            ZipArchiveEntry clonedZe = (ZipArchiveEntry)ze.clone();
            Assertions.assertEquals((Object)ze, (Object)clonedZe);
        }
    }
}

