/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.archivers.zip.ScatterSample;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScatterSampleTest
extends AbstractTempDirTest {
    private void checkFile(File result) throws IOException {
        try (ZipFile zipFile = new ZipFile(result);){
            ZipArchiveEntry archiveEntry1 = (ZipArchiveEntry)zipFile.getEntries().nextElement();
            Assertions.assertEquals((Object)"test1.xml", (Object)archiveEntry1.getName());
            try (InputStream inputStream = zipFile.getInputStream(archiveEntry1);){
                byte[] b = new byte[6];
                int i = IOUtils.readFully((InputStream)inputStream, (byte[])b);
                Assertions.assertEquals((int)5, (int)i);
                Assertions.assertEquals((int)72, (int)b[0]);
                Assertions.assertEquals((int)111, (int)b[4]);
            }
        }
        Assertions.assertTrue((boolean)result.delete());
    }

    private void createFile(File result) throws IOException, ExecutionException, InterruptedException {
        ScatterSample scatterSample = new ScatterSample(this);
        ZipArchiveEntry archiveEntry = new ZipArchiveEntry("test1.xml");
        archiveEntry.setMethod(8);
        InputStreamSupplier supp = () -> new ByteArrayInputStream("Hello".getBytes());
        scatterSample.addEntry(archiveEntry, supp);
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(result);){
            scatterSample.writeTo(zipArchiveOutputStream);
        }
    }

    @Test
    public void testSample() throws Exception {
        File result = this.createTempFile("testSample", "fe");
        this.createFile(result);
        this.checkFile(result);
    }
}

