/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ExplodingInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.utils.BoundedInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExplodeSupportTest {
    private void testArchiveWithImplodeCompression(String fileName, String entryName) throws IOException {
        try (ZipFile zip = new ZipFile(new File(fileName));){
            ZipArchiveEntry entry = (ZipArchiveEntry)zip.getEntries().nextElement();
            Assertions.assertEquals((Object)entryName, (Object)entry.getName(), (String)"entry name");
            Assertions.assertTrue((boolean)zip.canReadEntryData(entry), (String)"entry can't be read");
            Assertions.assertEquals((int)ZipMethod.IMPLODING.getCode(), (int)entry.getMethod(), (String)"method");
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            CheckedOutputStream out = new CheckedOutputStream(bout, new CRC32());
            try (InputStream inputStream = zip.getInputStream(entry);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)out);
                out.flush();
            }
            Assertions.assertEquals((long)entry.getCrc(), (long)out.getChecksum().getValue(), (String)"CRC32");
        }
    }

    @Test
    public void testArchiveWithImplodeCompression4K2Trees() throws IOException {
        this.testArchiveWithImplodeCompression("target/test-classes/imploding-4Kdict-2trees.zip", "HEADER.TXT");
    }

    @Test
    public void testArchiveWithImplodeCompression8K3Trees() throws IOException {
        this.testArchiveWithImplodeCompression("target/test-classes/imploding-8Kdict-3trees.zip", "LICENSE.TXT");
    }

    @Test
    public void testConstructorThrowsExceptions() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ExplodingInputStream(4095, 2, (InputStream)new ByteArrayInputStream(new byte[0])), (String)"should have failed with illegal argument exception");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ExplodingInputStream(4096, 4, (InputStream)new ByteArrayInputStream(new byte[0])), (String)"should have failed with illegal argument exception");
    }

    @Test
    public void testTikaTestArchive() throws IOException {
        this.testArchiveWithImplodeCompression("target/test-classes/moby-imploded.zip", "README");
    }

    @Test
    public void testTikaTestStream() throws IOException {
        this.testZipStreamWithImplodeCompression("target/test-classes/moby-imploded.zip", "README");
    }

    private void testZipStreamWithImplodeCompression(String fileName, String entryName) throws IOException {
        try (ZipArchiveInputStream zin = new ZipArchiveInputStream(Files.newInputStream(new File(fileName).toPath(), new OpenOption[0]));){
            ZipArchiveEntry entry = zin.getNextZipEntry();
            Assertions.assertEquals((Object)entryName, (Object)entry.getName(), (String)"entry name");
            Assertions.assertTrue((boolean)zin.canReadEntryData((ArchiveEntry)entry), (String)"entry can't be read");
            Assertions.assertEquals((int)ZipMethod.IMPLODING.getCode(), (int)entry.getMethod(), (String)"method");
            try (BoundedInputStream bio = new BoundedInputStream((InputStream)zin, entry.getSize());){
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                CheckedOutputStream out = new CheckedOutputStream(bout, new CRC32());
                IOUtils.copy((InputStream)bio, (OutputStream)out);
                out.flush();
                Assertions.assertEquals((long)entry.getCrc(), (long)out.getChecksum().getValue(), (String)"CRC32");
            }
        }
    }

    @Test
    public void testZipStreamWithImplodeCompression4K2Trees() throws IOException {
        this.testZipStreamWithImplodeCompression("target/test-classes/imploding-4Kdict-2trees.zip", "HEADER.TXT");
    }

    @Test
    public void testZipStreamWithImplodeCompression8K3Trees() throws IOException {
        this.testZipStreamWithImplodeCompression("target/test-classes/imploding-8Kdict-3trees.zip", "LICENSE.TXT");
    }
}

