/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EncryptedArchiveTest {
    @Test
    public void testReadPasswordEncryptedEntryViaStream() throws IOException {
        File file = AbstractTest.getFile("password-encrypted.zip");
        try (ZipArchiveInputStream zin = new ZipArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            ZipArchiveEntry zae = zin.getNextZipEntry();
            Assertions.assertEquals((Object)"LICENSE.txt", (Object)zae.getName());
            Assertions.assertTrue((boolean)zae.getGeneralPurposeBit().usesEncryption());
            Assertions.assertFalse((boolean)zae.getGeneralPurposeBit().usesStrongEncryption());
            Assertions.assertFalse((boolean)zin.canReadEntryData((ArchiveEntry)zae));
            UnsupportedZipFeatureException ex = (UnsupportedZipFeatureException)Assertions.assertThrows(UnsupportedZipFeatureException.class, () -> {
                byte[] buf = new byte[1024];
                zin.read(buf, 0, buf.length);
            }, (String)"expected an exception");
            Assertions.assertSame((Object)UnsupportedZipFeatureException.Feature.ENCRYPTION, (Object)ex.getFeature());
        }
    }

    @Test
    public void testReadPasswordEncryptedEntryViaZipFile() throws IOException {
        File file = AbstractTest.getFile("password-encrypted.zip");
        try (ZipFile zf = new ZipFile(file);){
            ZipArchiveEntry zae = zf.getEntry("LICENSE.txt");
            Assertions.assertTrue((boolean)zae.getGeneralPurposeBit().usesEncryption());
            Assertions.assertFalse((boolean)zae.getGeneralPurposeBit().usesStrongEncryption());
            Assertions.assertFalse((boolean)zf.canReadEntryData(zae));
            UnsupportedZipFeatureException ex = (UnsupportedZipFeatureException)Assertions.assertThrows(UnsupportedZipFeatureException.class, () -> zf.getInputStream(zae), (String)"expected an exception");
            Assertions.assertSame((Object)UnsupportedZipFeatureException.Feature.ENCRYPTION, (Object)ex.getFeature());
        }
    }
}

