/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveStructSparse;
import org.apache.commons.compress.archivers.tar.TarUtils;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TarUtilsTest
extends AbstractTest {
    private void checkName(String string) {
        byte[] buff = new byte[100];
        int len = TarUtils.formatNameBytes((String)string, (byte[])buff, (int)0, (int)buff.length);
        Assertions.assertEquals((Object)string, (Object)TarUtils.parseName((byte[])buff, (int)0, (int)len));
    }

    private void checkRoundTripOctal(long value) {
        this.checkRoundTripOctal(value, 12);
    }

    private void checkRoundTripOctal(long value, int bufsize) {
        byte[] buffer = new byte[bufsize];
        TarUtils.formatLongOctalBytes((long)value, (byte[])buffer, (int)0, (int)buffer.length);
        long parseValue = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((long)value, (long)parseValue);
    }

    private void checkRoundTripOctalOrBinary(long value, int bufsize) {
        byte[] buffer = new byte[bufsize];
        TarUtils.formatLongOctalOrBinaryBytes((long)value, (byte[])buffer, (int)0, (int)buffer.length);
        long parseValue = TarUtils.parseOctalOrBinary((byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((long)value, (long)parseValue);
    }

    @Test
    public void testName() {
        byte[] buff = new byte[20];
        String sb1 = "abcdefghijklmnopqrstuvwxyz";
        int off = TarUtils.formatNameBytes((String)"abcdefghijklmnopqrstuvwxyz", (byte[])buff, (int)1, (int)(buff.length - 1));
        Assertions.assertEquals((int)off, (int)20);
        String sb2 = TarUtils.parseName((byte[])buff, (int)1, (int)10);
        Assertions.assertEquals((Object)sb2, (Object)"abcdefghijklmnopqrstuvwxyz".substring(0, 10));
        sb2 = TarUtils.parseName((byte[])buff, (int)1, (int)19);
        Assertions.assertEquals((Object)sb2, (Object)"abcdefghijklmnopqrstuvwxyz".substring(0, 19));
        buff = new byte[30];
        off = TarUtils.formatNameBytes((String)"abcdefghijklmnopqrstuvwxyz", (byte[])buff, (int)1, (int)(buff.length - 1));
        Assertions.assertEquals((int)off, (int)30);
        sb2 = TarUtils.parseName((byte[])buff, (int)1, (int)(buff.length - 1));
        Assertions.assertEquals((Object)"abcdefghijklmnopqrstuvwxyz", (Object)sb2);
        buff = new byte[]{0, 1, 0};
        sb2 = TarUtils.parseName((byte[])buff, (int)0, (int)3);
        Assertions.assertEquals((Object)"", (Object)sb2);
    }

    @Test
    public void testNegative() {
        byte[] buffer = new byte[22];
        TarUtils.formatUnsignedOctalString((long)-1L, (byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((Object)"1777777777777777777777", (Object)new String(buffer, StandardCharsets.UTF_8));
    }

    @Test
    public void testOverflow() {
        byte[] buffer = new byte[7];
        TarUtils.formatUnsignedOctalString((long)0x1FFFFFL, (byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((Object)"7777777", (Object)new String(buffer, StandardCharsets.UTF_8));
        Assertions.assertThrows(IllegalArgumentException.class, () -> TarUtils.formatUnsignedOctalString((long)0x3FFFFFL, (byte[])buffer, (int)0, (int)buffer.length), (String)"Should have cause IllegalArgumentException");
    }

    @Test
    public void testParseFromPAX01SparseHeaders() throws Exception {
        String map = "0,10,20,0,20,5";
        List sparse = TarUtils.parseFromPAX01SparseHeaders((String)"0,10,20,0,20,5");
        Assertions.assertEquals((int)3, (int)sparse.size());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparse.get(0)).getOffset());
        Assertions.assertEquals((long)10L, (long)((TarArchiveStructSparse)sparse.get(0)).getNumbytes());
        Assertions.assertEquals((long)20L, (long)((TarArchiveStructSparse)sparse.get(1)).getOffset());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparse.get(1)).getNumbytes());
        Assertions.assertEquals((long)20L, (long)((TarArchiveStructSparse)sparse.get(2)).getOffset());
        Assertions.assertEquals((long)5L, (long)((TarArchiveStructSparse)sparse.get(2)).getNumbytes());
    }

    @Test
    public void testParseFromPAX01SparseHeadersRejectsNegativeNumbytes() throws Exception {
        Assertions.assertThrows(IOException.class, () -> TarUtils.parseFromPAX01SparseHeaders((String)"0,10,20,0,20,-5"));
    }

    @Test
    public void testParseFromPAX01SparseHeadersRejectsNegativeOffset() throws Exception {
        Assertions.assertThrows(IOException.class, () -> TarUtils.parseFromPAX01SparseHeaders((String)"0,10,20,0,-2,5"));
    }

    @Test
    public void testParseFromPAX01SparseHeadersRejectsNonNumericNumbytes() throws Exception {
        Assertions.assertThrows(IOException.class, () -> TarUtils.parseFromPAX01SparseHeaders((String)"0,10,20,0,20,b"));
    }

    @Test
    public void testParseFromPAX01SparseHeadersRejectsNonNumericOffset() throws Exception {
        Assertions.assertThrows(IOException.class, () -> TarUtils.parseFromPAX01SparseHeaders((String)"0,10,20,0,2a,5"));
    }

    @Test
    public void testParseFromPAX01SparseHeadersRejectsOddNumberOfEntries() throws Exception {
        String map = "0,10,20,0,20";
        Assertions.assertThrows(IOException.class, () -> TarUtils.parseFromPAX01SparseHeaders((String)"0,10,20,0,20"));
    }

    @Test
    public void testParseOctal() {
        long MAX_OCTAL = 0x1FFFFFFFFL;
        long MAX_OCTAL_OVERFLOW = 0xFFFFFFFFFL;
        String maxOctal = "777777777777";
        byte[] buffer = "777777777777".getBytes(StandardCharsets.UTF_8);
        long value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((long)0xFFFFFFFFFL, (long)value);
        buffer[buffer.length - 1] = 32;
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((long)0x1FFFFFFFFL, (long)value);
        buffer[buffer.length - 1] = 0;
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((long)0x1FFFFFFFFL, (long)value);
        buffer = new byte[]{0, 0};
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((long)0L, (long)value);
        buffer = new byte[]{0, 32};
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((long)0L, (long)value);
        buffer = new byte[]{32, 0};
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((long)0L, (long)value);
    }

    @Test
    public void testParseOctalCompress330() {
        long expected = 32768L;
        byte[] buffer = new byte[]{32, 32, 32, 32, 32, 49, 48, 48, 48, 48, 48, 32};
        Assertions.assertEquals((long)32768L, (long)TarUtils.parseOctalOrBinary((byte[])buffer, (int)0, (int)buffer.length));
    }

    @Test
    public void testParseOctalInvalid() {
        byte[] buffer1 = ByteUtils.EMPTY_BYTE_ARRAY;
        Assertions.assertThrows(IllegalArgumentException.class, () -> TarUtils.parseOctal((byte[])buffer1, (int)0, (int)buffer1.length), (String)"Expected IllegalArgumentException - should be at least 2 bytes long");
        byte[] buffer2 = new byte[]{0};
        Assertions.assertThrows(IllegalArgumentException.class, () -> TarUtils.parseOctal((byte[])buffer2, (int)0, (int)buffer2.length), (String)"Expected IllegalArgumentException - should be at least 2 bytes long");
        byte[] buffer3 = "abcdef ".getBytes(StandardCharsets.UTF_8);
        Assertions.assertThrows(IllegalArgumentException.class, () -> TarUtils.parseOctal((byte[])buffer3, (int)0, (int)buffer3.length), (String)"Expected IllegalArgumentException");
        byte[] buffer4 = " 0 07 ".getBytes(StandardCharsets.UTF_8);
        Assertions.assertThrows(IllegalArgumentException.class, () -> TarUtils.parseOctal((byte[])buffer3, (int)0, (int)buffer3.length), (String)"Expected IllegalArgumentException - embedded space");
        byte[] buffer5 = " 0\u000007 ".getBytes(StandardCharsets.UTF_8);
        Assertions.assertThrows(IllegalArgumentException.class, () -> TarUtils.parseOctal((byte[])buffer5, (int)0, (int)buffer5.length), (String)"Expected IllegalArgumentException - embedded NUL");
    }

    @Test
    public void testParsePAX01SparseHeadersRejectsOddNumberOfEntries() {
        String map = "0,10,20,0,20";
        Assertions.assertThrows(UncheckedIOException.class, () -> TarUtils.parsePAX01SparseHeaders((String)"0,10,20,0,20"));
    }

    @Test
    public void testParsePAX1XSparseHeaders() throws Exception {
        byte[] header = "1\n0\n20\n".getBytes();
        byte[] block = new byte[512];
        System.arraycopy(header, 0, block, 0, header.length);
        try (ByteArrayInputStream in = new ByteArrayInputStream(block);){
            List sparse = TarUtils.parsePAX1XSparseHeaders((InputStream)in, (int)512);
            Assertions.assertEquals((int)1, (int)sparse.size());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparse.get(0)).getOffset());
            Assertions.assertEquals((long)20L, (long)((TarArchiveStructSparse)sparse.get(0)).getNumbytes());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testParsePAX1XSparseHeadersRejectsIncompleteLastLine() throws Exception {
        byte[] header = "1\n0\n20".getBytes();
        try (ByteArrayInputStream in = new ByteArrayInputStream(header);){
            Assertions.assertThrows(IOException.class, () -> TarUtils.parsePAX1XSparseHeaders((InputStream)in, (int)512));
        }
    }

    @Test
    public void testParsePAX1XSparseHeadersRejectsNegativeNumberOfEntries() throws Exception {
        byte[] header = "111111111111111111111111111111111111111111111111111111111111111\n0\n20\n".getBytes();
        byte[] block = new byte[512];
        System.arraycopy(header, 0, block, 0, header.length);
        try (ByteArrayInputStream in = new ByteArrayInputStream(block);){
            Assertions.assertThrows(IOException.class, () -> TarUtils.parsePAX1XSparseHeaders((InputStream)in, (int)512));
        }
    }

    @Test
    public void testParsePAX1XSparseHeadersRejectsNegativeNumbytes() throws Exception {
        byte[] header = "1\n0\n111111111111111111111111111111111111111111111111111111111111111\n".getBytes();
        byte[] block = new byte[512];
        System.arraycopy(header, 0, block, 0, header.length);
        try (ByteArrayInputStream in = new ByteArrayInputStream(block);){
            Assertions.assertThrows(IOException.class, () -> TarUtils.parsePAX1XSparseHeaders((InputStream)in, (int)512));
        }
    }

    @Test
    public void testParsePAX1XSparseHeadersRejectsNegativeOffset() throws Exception {
        byte[] header = "1\n111111111111111111111111111111111111111111111111111111111111111\n20\n".getBytes();
        byte[] block = new byte[512];
        System.arraycopy(header, 0, block, 0, header.length);
        try (ByteArrayInputStream in = new ByteArrayInputStream(block);){
            Assertions.assertThrows(IOException.class, () -> TarUtils.parsePAX1XSparseHeaders((InputStream)in, (int)512));
        }
    }

    @Test
    public void testParsePAX1XSparseHeadersRejectsNonNumericNumberOfEntries() throws Exception {
        byte[] header = "x\n0\n20\n".getBytes();
        byte[] block = new byte[512];
        System.arraycopy(header, 0, block, 0, header.length);
        try (ByteArrayInputStream in = new ByteArrayInputStream(block);){
            Assertions.assertThrows(IOException.class, () -> TarUtils.parsePAX1XSparseHeaders((InputStream)in, (int)512));
        }
    }

    @Test
    public void testParsePAX1XSparseHeadersRejectsNonNumericNumbytes() throws Exception {
        byte[] header = "1\n0\n2x\n".getBytes();
        byte[] block = new byte[512];
        System.arraycopy(header, 0, block, 0, header.length);
        try (ByteArrayInputStream in = new ByteArrayInputStream(block);){
            Assertions.assertThrows(IOException.class, () -> TarUtils.parsePAX1XSparseHeaders((InputStream)in, (int)512));
        }
    }

    @Test
    public void testParsePAX1XSparseHeadersRejectsNonNumericOffset() throws Exception {
        byte[] header = "1\nx\n20\n".getBytes();
        byte[] block = new byte[512];
        System.arraycopy(header, 0, block, 0, header.length);
        try (ByteArrayInputStream in = new ByteArrayInputStream(block);){
            Assertions.assertThrows(IOException.class, () -> TarUtils.parsePAX1XSparseHeaders((InputStream)in, (int)512));
        }
    }

    @Test
    public void testParseSparse() {
        long expectedOffset = 32768L;
        long expectedNumbytes = 37376L;
        byte[] buffer = new byte[]{32, 32, 32, 32, 32, 48, 49, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 48, 49, 49, 49, 48, 48, 48};
        TarArchiveStructSparse sparse = TarUtils.parseSparse((byte[])buffer, (int)0);
        Assertions.assertEquals((long)sparse.getOffset(), (long)32768L);
        Assertions.assertEquals((long)sparse.getNumbytes(), (long)37376L);
    }

    @Test
    public void testParseTarWithSpecialPaxHeaders() throws IOException {
        try (InputStream in = TarUtilsTest.newInputStream("COMPRESS-530.tar");
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            Assertions.assertThrows(IOException.class, () -> archive.getNextEntry());
        }
    }

    @Test
    public void testPaxHeaderEntryWithEmptyValueRemovesKey() throws Exception {
        Map headers = TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("11 foo=bar\n7 foo=\n".getBytes(StandardCharsets.UTF_8)), null, new HashMap());
        Assertions.assertEquals((int)0, (int)headers.size());
    }

    @Test
    public void testReadNegativeBinary12Byte() {
        byte[] b = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -15, -17};
        Assertions.assertEquals((long)-3601L, (long)TarUtils.parseOctalOrBinary((byte[])b, (int)0, (int)12));
    }

    @Test
    public void testReadNegativeBinary8Byte() {
        byte[] b = new byte[]{-1, -1, -1, -1, -1, -1, -15, -17};
        Assertions.assertEquals((long)-3601L, (long)TarUtils.parseOctalOrBinary((byte[])b, (int)0, (int)8));
    }

    @Test
    public void testReadNonAsciiPaxHeader() throws Exception {
        String ae = "\u00e4";
        String line = "11 path=\u00e4\n";
        Assertions.assertEquals((int)11, (int)"11 path=\u00e4\n".getBytes(StandardCharsets.UTF_8).length);
        Map headers = TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("11 path=\u00e4\n".getBytes(StandardCharsets.UTF_8)), null, new HashMap());
        Assertions.assertEquals((int)1, (int)headers.size());
        Assertions.assertEquals((Object)"\u00e4", headers.get("path"));
    }

    @Test
    public void testReadPax00SparseHeader() throws Exception {
        String header = "23 GNU.sparse.offset=0\n26 GNU.sparse.numbytes=10\n";
        ArrayList sparseHeaders = new ArrayList();
        TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("23 GNU.sparse.offset=0\n26 GNU.sparse.numbytes=10\n".getBytes(StandardCharsets.UTF_8)), sparseHeaders, Collections.emptyMap());
        Assertions.assertEquals((int)1, (int)sparseHeaders.size());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
        Assertions.assertEquals((long)10L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
    }

    @Test
    public void testReadPax00SparseHeaderMakesNumbytesOptional() throws Exception {
        String header = "23 GNU.sparse.offset=0\n24 GNU.sparse.offset=10\n";
        ArrayList sparseHeaders = new ArrayList();
        TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("23 GNU.sparse.offset=0\n24 GNU.sparse.offset=10\n".getBytes(StandardCharsets.UTF_8)), sparseHeaders, Collections.emptyMap());
        Assertions.assertEquals((int)2, (int)sparseHeaders.size());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
        Assertions.assertEquals((long)10L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
    }

    @Test
    public void testReadPax00SparseHeaderRejectsNegativeNumbytes() throws Exception {
        String header = "23 GNU.sparse.offset=0\n26 GNU.sparse.numbytes=-1\n";
        Assertions.assertThrows(IOException.class, () -> TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("23 GNU.sparse.offset=0\n26 GNU.sparse.numbytes=-1\n".getBytes(StandardCharsets.UTF_8)), null, Collections.emptyMap()));
    }

    @Test
    public void testReadPax00SparseHeaderRejectsNegativeOffset() throws Exception {
        String header = "24 GNU.sparse.offset=-1\n26 GNU.sparse.numbytes=10\n";
        Assertions.assertThrows(IOException.class, () -> TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("24 GNU.sparse.offset=-1\n26 GNU.sparse.numbytes=10\n".getBytes(StandardCharsets.UTF_8)), null, Collections.emptyMap()));
    }

    @Test
    public void testReadPax00SparseHeaderRejectsNonNumericNumbytes() throws Exception {
        String header = "23 GNU.sparse.offset=0\n26 GNU.sparse.numbytes=1a\n";
        Assertions.assertThrows(IOException.class, () -> TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("23 GNU.sparse.offset=0\n26 GNU.sparse.numbytes=1a\n".getBytes(StandardCharsets.UTF_8)), null, Collections.emptyMap()));
    }

    @Test
    public void testReadPax00SparseHeaderRejectsNonNumericOffset() throws Exception {
        String header = "23 GNU.sparse.offset=a\n26 GNU.sparse.numbytes=10\n";
        Assertions.assertThrows(IOException.class, () -> TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("23 GNU.sparse.offset=a\n26 GNU.sparse.numbytes=10\n".getBytes(StandardCharsets.UTF_8)), null, Collections.emptyMap()));
    }

    @Test
    public void testReadPaxHeaderWithEmbeddedNewline() throws Exception {
        Map headers = TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("28 comment=line1\nline2\nand3\n".getBytes(StandardCharsets.UTF_8)), null, new HashMap());
        Assertions.assertEquals((int)1, (int)headers.size());
        Assertions.assertEquals((Object)"line1\nline2\nand3", headers.get("comment"));
    }

    @Test
    public void testReadPaxHeaderWithoutTrailingNewline() throws Exception {
        Assertions.assertThrows(IOException.class, () -> TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("30 atime=1321711775.9720594634".getBytes(StandardCharsets.UTF_8)), null, Collections.emptyMap()));
    }

    @Test
    public void testReadSimplePaxHeader() throws Exception {
        Map headers = TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("30 atime=1321711775.972059463\n".getBytes(StandardCharsets.UTF_8)), null, new HashMap());
        Assertions.assertEquals((int)1, (int)headers.size());
        Assertions.assertEquals((Object)"1321711775.972059463", headers.get("atime"));
    }

    @Test
    public void testReadSparseStructsBinary() throws Exception {
        byte[] header = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7};
        Assertions.assertEquals((int)24, (int)header.length);
        List sparse = TarUtils.readSparseStructs((byte[])header, (int)0, (int)1);
        Assertions.assertEquals((int)1, (int)sparse.size());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparse.get(0)).getOffset());
        Assertions.assertEquals((long)7L, (long)((TarArchiveStructSparse)sparse.get(0)).getNumbytes());
    }

    @Test
    public void testReadSparseStructsOctal() throws Exception {
        byte[] header = "00000000000 00000000007 ".getBytes();
        Assertions.assertEquals((int)24, (int)header.length);
        List sparse = TarUtils.readSparseStructs((byte[])header, (int)0, (int)1);
        Assertions.assertEquals((int)1, (int)sparse.size());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparse.get(0)).getOffset());
        Assertions.assertEquals((long)7L, (long)((TarArchiveStructSparse)sparse.get(0)).getNumbytes());
    }

    @Test
    public void testReadSparseStructsRejectsNegativeNumbytes() throws Exception {
        byte[] header = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        Assertions.assertThrows(IOException.class, () -> TarUtils.readSparseStructs((byte[])header, (int)0, (int)1));
    }

    @Test
    public void testReadSparseStructsRejectsNegativeOffset() throws Exception {
        byte[] header = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7};
        Assertions.assertThrows(IOException.class, () -> TarUtils.readSparseStructs((byte[])header, (int)0, (int)1));
    }

    @Test
    public void testReadSparseStructsRejectsNonNumericNumbytes() throws Exception {
        byte[] header = "00000000000 0000000000x ".getBytes();
        Assertions.assertThrows(IOException.class, () -> TarUtils.readSparseStructs((byte[])header, (int)0, (int)1));
    }

    @Test
    public void testReadSparseStructsRejectsNonNumericOffset() throws Exception {
        byte[] header = "0000000000x 00000000007 ".getBytes();
        Assertions.assertThrows(IOException.class, () -> TarUtils.readSparseStructs((byte[])header, (int)0, (int)1));
    }

    @Test
    public void testRoundEncoding() throws Exception {
        ZipEncoding enc = ZipEncodingHelper.getZipEncoding((String)"ISO-8859-1");
        String s = "0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W220\u00b1ZB\u00b1LALALA\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1CAN\u00b1\u00b1DC\u00b1\u00b1\u00b104\u00b1060302\u00b1MOE.model";
        byte[] buff = new byte[100];
        int len = TarUtils.formatNameBytes((String)"0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W220\u00b1ZB\u00b1LALALA\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1CAN\u00b1\u00b1DC\u00b1\u00b1\u00b104\u00b1060302\u00b1MOE.model", (byte[])buff, (int)0, (int)buff.length, (ZipEncoding)enc);
        Assertions.assertEquals((Object)"0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W220\u00b1ZB\u00b1LALALA\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1CAN\u00b1\u00b1DC\u00b1\u00b1\u00b104\u00b1060302\u00b1MOE.model", (Object)TarUtils.parseName((byte[])buff, (int)0, (int)len, (ZipEncoding)enc));
    }

    @Test
    public void testRoundTripNames() {
        this.checkName("");
        this.checkName("The quick brown fox\n");
        this.checkName("\u007f");
    }

    @Test
    public void testRoundTripOctal() {
        this.checkRoundTripOctal(0L);
        this.checkRoundTripOctal(1L);
        this.checkRoundTripOctal(0x1FFFFFFFFL);
        this.checkRoundTripOctal(0L, 8);
        this.checkRoundTripOctal(1L, 8);
        this.checkRoundTripOctal(0x1FFFFFL, 8);
    }

    private void testRoundTripOctalOrBinary(int length) {
        this.checkRoundTripOctalOrBinary(0L, length);
        this.checkRoundTripOctalOrBinary(1L, length);
        this.checkRoundTripOctalOrBinary(0x1FFFFFFFFL, length);
        this.checkRoundTripOctalOrBinary(-1L, length);
        this.checkRoundTripOctalOrBinary(0xFFFFFFFFFFFFFFL, length);
        this.checkRoundTripOctalOrBinary(-72057594037927935L, length);
    }

    @Test
    public void testRoundTripOctalOrBinary12() {
        this.testRoundTripOctalOrBinary(12);
        this.checkRoundTripOctalOrBinary(Long.MAX_VALUE, 12);
        this.checkRoundTripOctalOrBinary(-9223372036854775807L, 12);
    }

    @Test
    public void testRoundTripOctalOrBinary8() {
        this.testRoundTripOctalOrBinary(8);
    }

    @Test
    public void testRoundTripOctalOrBinary8_ValueTooBigForBinary() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.checkRoundTripOctalOrBinary(Long.MAX_VALUE, 8), (String)"Should throw exception - value is too long to fit buffer of this len");
        Assertions.assertEquals((Object)"Value 9223372036854775807 is too large for 8 byte field.", (Object)e.getMessage());
    }

    @Test
    public void testSecondEntryWinsWhenPaxHeaderContainsDuplicateKey() throws Exception {
        Map headers = TarUtils.parsePaxHeaders((InputStream)new ByteArrayInputStream("11 foo=bar\n11 foo=baz\n".getBytes(StandardCharsets.UTF_8)), null, new HashMap());
        Assertions.assertEquals((int)1, (int)headers.size());
        Assertions.assertEquals((Object)"baz", headers.get("foo"));
    }

    @Test
    public void testTrailers() {
        byte[] buffer = new byte[12];
        TarUtils.formatLongOctalBytes((long)123L, (byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((int)32, (int)buffer[buffer.length - 1]);
        Assertions.assertEquals((int)51, (int)buffer[buffer.length - 2]);
        TarUtils.formatOctalBytes((long)123L, (byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((int)0, (int)buffer[buffer.length - 1]);
        Assertions.assertEquals((int)32, (int)buffer[buffer.length - 2]);
        Assertions.assertEquals((int)51, (int)buffer[buffer.length - 3]);
        TarUtils.formatCheckSumOctalBytes((long)123L, (byte[])buffer, (int)0, (int)buffer.length);
        Assertions.assertEquals((int)32, (int)buffer[buffer.length - 1]);
        Assertions.assertEquals((int)0, (int)buffer[buffer.length - 2]);
        Assertions.assertEquals((int)51, (int)buffer[buffer.length - 3]);
    }

    @Test
    public void testVerifyHeaderCheckSum() {
        byte[] valid = new byte[]{116, 101, 115, 116, 49, 46, 120, 109, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 48, 48, 48, 54, 52, 52, 0, 48, 48, 48, 48, 55, 54, 53, 0, 48, 48, 48, 48, 55, 54, 53, 0, 48, 48, 48, 48, 48, 48, 48, 49, 49, 52, 50, 0, 49, 48, 55, 49, 54, 53, 52, 53, 54, 50, 54, 0, 48, 49, 50, 50, 54, 48, 0, 32, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 115, 116, 97, 114, 32, 32, 0, 116, 99, 117, 114, 100, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 99, 117, 114, 100, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Assertions.assertTrue((boolean)TarUtils.verifyCheckSum((byte[])valid));
        byte[] compress117 = new byte[]{55, 122, 67, 46, 116, 120, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 48, 48, 55, 55, 55, 32, 0, 32, 32, 32, 32, 32, 48, 32, 0, 32, 32, 32, 32, 32, 48, 32, 0, 32, 32, 32, 32, 32, 32, 49, 51, 48, 51, 51, 32, 49, 49, 49, 49, 53, 49, 54, 54, 48, 49, 54, 32, 32, 32, 53, 52, 49, 55, 32, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Assertions.assertTrue((boolean)TarUtils.verifyCheckSum((byte[])compress117));
        byte[] invalid = new byte[]{70, 79, 82, 77, 0, 0, 15, 46, 65, 73, 70, 70, 67, 79, 77, 77, 0, 0, 0, 18, 0, 2, 0, 0, 3, -64, 0, 16, 64, 14, -84, 68, 0, 0, 0, 0, 0, 0, 83, 83, 78, 68, 0, 0, 15, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 1, -1, -2, 0, 1, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 1, -1, -1, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 1, -1, -1, 0, 0, 0, 1, -1, -1, 0, 0, 0, 1, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, -1, -1, 0, 2, -1, -2, 0, 2, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 2, -1, -2, 0, 1, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 1, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Assertions.assertFalse((boolean)TarUtils.verifyCheckSum((byte[])invalid));
    }

    @Test
    public void testWriteNegativeBinary8Byte() {
        byte[] b = new byte[]{-1, -1, -1, -1, -1, -1, -15, -17};
        Assertions.assertEquals((long)-3601L, (long)TarUtils.parseOctalOrBinary((byte[])b, (int)0, (int)8));
    }
}

