/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveStructSparse;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class SparseFilesTest
extends AbstractTest {
    private void assertPaxGNUEntry(TarArchiveEntry entry, String suffix) {
        Assertions.assertEquals((Object)("sparsefile-" + suffix), (Object)entry.getName());
        Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
        Assertions.assertTrue((boolean)entry.isGNUSparse());
        Assertions.assertTrue((boolean)entry.isPaxGNUSparse());
        Assertions.assertFalse((boolean)entry.isOldGNUSparse());
        List sparseHeaders = entry.getSparseHeaders();
        Assertions.assertEquals((int)3, (int)sparseHeaders.size());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
        Assertions.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
        Assertions.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
        Assertions.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
        Assertions.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
    }

    private void assertPaxGNUEntry(TarArchiveInputStream tin, String suffix) throws Throwable {
        TarArchiveEntry ae = tin.getNextTarEntry();
        Assertions.assertEquals((Object)("sparsefile-" + suffix), (Object)ae.getName());
        Assertions.assertEquals((byte)48, (byte)ae.getLinkFlag());
        Assertions.assertTrue((boolean)ae.isGNUSparse());
        Assertions.assertTrue((boolean)ae.isPaxGNUSparse());
        Assertions.assertFalse((boolean)ae.isOldGNUSparse());
        Assertions.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)ae));
        List sparseHeaders = ae.getSparseHeaders();
        Assertions.assertEquals((int)3, (int)sparseHeaders.size());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
        Assertions.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
        Assertions.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
        Assertions.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
        Assertions.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
        Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
    }

    private InputStream extractTarAndGetInputStream(File tarFile, String sparseFileName) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder("tar", "-xf", tarFile.getPath(), "-C", this.tempResultDir.getPath());
        pb.redirectErrorStream(true);
        Process process = pb.start();
        try (InputStream inputStream = process.getInputStream();){
            Assertions.assertEquals((int)0, (int)process.waitFor(), (String)new String(IOUtils.toByteArray((InputStream)inputStream)));
        }
        for (File file : this.tempResultDir.listFiles()) {
            if (!file.getName().equals(sparseFileName)) continue;
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        Assertions.fail((String)("didn't find " + sparseFileName + " after extracting " + tarFile));
        return null;
    }

    private String getTarBinaryHelp() throws IOException {
        ProcessBuilder pb = new ProcessBuilder("tar", "--version");
        pb.redirectErrorStream(true);
        Process process = pb.start();
        try (InputStream inputStream = process.getInputStream();){
            String string = new String(IOUtils.toByteArray((InputStream)inputStream));
            return string;
        }
    }

    @Test
    public void testCompareTarArchiveInputStreamWithTarFile() throws IOException {
        Path file = SparseFilesTest.getPath("oldgnu_sparse.tar");
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));
             TarFile tarFile = new TarFile(file);){
            Assertions.assertNotNull((Object)tarIn.getNextTarEntry());
            try (InputStream inputStream = tarFile.getInputStream((TarArchiveEntry)tarFile.getEntries().get(0));){
                Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tarIn), (byte[])IOUtils.toByteArray((InputStream)inputStream));
            }
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testExtractExtendedOldGNU() throws IOException, InterruptedException {
        File file = SparseFilesTest.getFile("oldgnu_extended_sparse.tar");
        try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparse6");
             TarArchiveInputStream tin = new TarArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            TarArchiveEntry ae = tin.getNextTarEntry();
            Assertions.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)ae));
            Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            List sparseHeaders = ae.getOrderedSparseHeaders();
            Assertions.assertEquals((int)7, (int)sparseHeaders.size());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
            Assertions.assertEquals((long)10240L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
            Assertions.assertEquals((long)16384L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
            Assertions.assertEquals((long)24576L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getNumbytes());
            Assertions.assertEquals((long)29696L, (long)((TarArchiveStructSparse)sparseHeaders.get(4)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(4)).getNumbytes());
            Assertions.assertEquals((long)36864L, (long)((TarArchiveStructSparse)sparseHeaders.get(5)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(5)).getNumbytes());
            Assertions.assertEquals((long)51200L, (long)((TarArchiveStructSparse)sparseHeaders.get(6)).getOffset());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(6)).getNumbytes());
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testExtractOldGNU() throws IOException, InterruptedException {
        try {
            File file = SparseFilesTest.getFile("oldgnu_sparse.tar");
            try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile");
                 TarArchiveInputStream tin = new TarArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                TarArchiveEntry entry = tin.getNextTarEntry();
                Assertions.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)entry));
                Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
        }
        catch (IOException | RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testExtractPaxGNU() throws IOException, InterruptedException {
        Assumptions.assumeFalse((boolean)this.getTarBinaryHelp().startsWith("tar (GNU tar) 1.28"), (String)"This test should be ignored if GNU tar is version 1.28");
        File file = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarArchiveInputStream tin = new TarArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            TarArchiveEntry paxGNUEntry = tin.getNextTarEntry();
            Assertions.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)paxGNUEntry));
            try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-0.0");){
                Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
            paxGNUEntry = tin.getNextTarEntry();
            Assertions.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)paxGNUEntry));
            sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-0.1");
            try {
                Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
            finally {
                if (sparseFileInputStream != null) {
                    sparseFileInputStream.close();
                }
            }
            paxGNUEntry = tin.getNextTarEntry();
            Assertions.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)paxGNUEntry));
            sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-1.0");
            try {
                Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
            finally {
                if (sparseFileInputStream != null) {
                    sparseFileInputStream.close();
                }
            }
        }
    }

    @Test
    @EnabledOnOs(value={OS.WINDOWS})
    public void testExtractSparseTarsOnWindows() throws IOException {
        File oldGNUSparseTar = SparseFilesTest.getFile("oldgnu_sparse.tar");
        File paxGNUSparseTar = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarArchiveInputStream paxGNUSparseInputStream = new TarArchiveInputStream(Files.newInputStream(paxGNUSparseTar.toPath(), new OpenOption[0]));){
            TarArchiveEntry oldGNUEntry;
            TarArchiveEntry paxGNUEntry = paxGNUSparseInputStream.getNextTarEntry();
            Assertions.assertTrue((boolean)paxGNUSparseInputStream.canReadEntryData((ArchiveEntry)paxGNUEntry));
            try (TarArchiveInputStream oldGNUSparseInputStream = new TarArchiveInputStream(Files.newInputStream(oldGNUSparseTar.toPath(), new OpenOption[0]));){
                oldGNUEntry = oldGNUSparseInputStream.getNextTarEntry();
                Assertions.assertTrue((boolean)oldGNUSparseInputStream.canReadEntryData((ArchiveEntry)oldGNUEntry));
                Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)oldGNUSparseInputStream), (byte[])IOUtils.toByteArray((InputStream)paxGNUSparseInputStream));
            }
            paxGNUEntry = paxGNUSparseInputStream.getNextTarEntry();
            Assertions.assertTrue((boolean)paxGNUSparseInputStream.canReadEntryData((ArchiveEntry)paxGNUEntry));
            oldGNUSparseInputStream = new TarArchiveInputStream(Files.newInputStream(oldGNUSparseTar.toPath(), new OpenOption[0]));
            try {
                oldGNUEntry = oldGNUSparseInputStream.getNextTarEntry();
                Assertions.assertTrue((boolean)oldGNUSparseInputStream.canReadEntryData((ArchiveEntry)oldGNUEntry));
                Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)oldGNUSparseInputStream), (byte[])IOUtils.toByteArray((InputStream)paxGNUSparseInputStream));
            }
            finally {
                oldGNUSparseInputStream.close();
            }
            paxGNUEntry = paxGNUSparseInputStream.getNextTarEntry();
            Assertions.assertTrue((boolean)paxGNUSparseInputStream.canReadEntryData((ArchiveEntry)paxGNUEntry));
            oldGNUSparseInputStream = new TarArchiveInputStream(Files.newInputStream(oldGNUSparseTar.toPath(), new OpenOption[0]));
            try {
                oldGNUEntry = oldGNUSparseInputStream.getNextTarEntry();
                Assertions.assertTrue((boolean)oldGNUSparseInputStream.canReadEntryData((ArchiveEntry)oldGNUEntry));
                Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)oldGNUSparseInputStream), (byte[])IOUtils.toByteArray((InputStream)paxGNUSparseInputStream));
            }
            finally {
                oldGNUSparseInputStream.close();
            }
        }
    }

    @Test
    public void testOldGNU() throws Throwable {
        File file = SparseFilesTest.getFile("oldgnu_sparse.tar");
        try (TarArchiveInputStream tin = new TarArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            TarArchiveEntry ae = tin.getNextTarEntry();
            Assertions.assertEquals((Object)"sparsefile", (Object)ae.getName());
            Assertions.assertEquals((byte)83, (byte)ae.getLinkFlag());
            Assertions.assertTrue((boolean)ae.isOldGNUSparse());
            Assertions.assertTrue((boolean)ae.isGNUSparse());
            Assertions.assertFalse((boolean)ae.isPaxGNUSparse());
            Assertions.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)ae));
            List sparseHeaders = ae.getSparseHeaders();
            Assertions.assertEquals((int)4, (int)sparseHeaders.size());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
            Assertions.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
            Assertions.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
            Assertions.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
            Assertions.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getOffset());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getNumbytes());
            List sparseOrderedHeaders = ae.getOrderedSparseHeaders();
            Assertions.assertEquals((int)3, (int)sparseOrderedHeaders.size());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(0)).getOffset());
            Assertions.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(0)).getNumbytes());
            Assertions.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(1)).getOffset());
            Assertions.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(1)).getNumbytes());
            Assertions.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(2)).getOffset());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(2)).getNumbytes());
        }
    }

    @Test
    public void testPaxGNU() throws Throwable {
        File file = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarArchiveInputStream tin = new TarArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            this.assertPaxGNUEntry(tin, "0.0");
            this.assertPaxGNUEntry(tin, "0.1");
            this.assertPaxGNUEntry(tin, "1.0");
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testTarFileExtractExtendedOldGNU() throws IOException, InterruptedException {
        File file = SparseFilesTest.getFile("oldgnu_extended_sparse.tar");
        try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparse6");
             TarFile tarFile = new TarFile(file);){
            TarArchiveEntry ae = (TarArchiveEntry)tarFile.getEntries().get(0);
            try (InputStream tarInput = tarFile.getInputStream(ae);){
                Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tarInput), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
            List sparseHeaders = ae.getOrderedSparseHeaders();
            Assertions.assertEquals((int)7, (int)sparseHeaders.size());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
            Assertions.assertEquals((long)10240L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
            Assertions.assertEquals((long)16384L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
            Assertions.assertEquals((long)24576L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getNumbytes());
            Assertions.assertEquals((long)29696L, (long)((TarArchiveStructSparse)sparseHeaders.get(4)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(4)).getNumbytes());
            Assertions.assertEquals((long)36864L, (long)((TarArchiveStructSparse)sparseHeaders.get(5)).getOffset());
            Assertions.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(5)).getNumbytes());
            Assertions.assertEquals((long)51200L, (long)((TarArchiveStructSparse)sparseHeaders.get(6)).getOffset());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(6)).getNumbytes());
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testTarFileExtractOldGNU() throws IOException, InterruptedException {
        File file = SparseFilesTest.getFile("oldgnu_sparse.tar");
        try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile");
             TarFile tarFile = new TarFile(file);){
            TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
            try (InputStream tarInput = tarFile.getInputStream(entry);){
                Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tarInput), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testTarFileExtractPaxGNU() throws IOException, InterruptedException {
        Assumptions.assumeFalse((boolean)this.getTarBinaryHelp().startsWith("tar (GNU tar) 1.28"), (String)"This test should be ignored if GNU tar is version 1.28");
        File file = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarFile paxGnu = new TarFile(file);){
            InputStream paxInput;
            List entries = paxGnu.getEntries();
            TarArchiveEntry entry = (TarArchiveEntry)entries.get(0);
            try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-0.0");){
                paxInput = paxGnu.getInputStream(entry);
                try {
                    Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)paxInput), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
                }
                finally {
                    if (paxInput != null) {
                        paxInput.close();
                    }
                }
            }
            entry = (TarArchiveEntry)entries.get(1);
            sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-0.1");
            try {
                paxInput = paxGnu.getInputStream(entry);
                try {
                    Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)paxInput), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
                }
                finally {
                    if (paxInput != null) {
                        paxInput.close();
                    }
                }
            }
            finally {
                if (sparseFileInputStream != null) {
                    sparseFileInputStream.close();
                }
            }
            entry = (TarArchiveEntry)entries.get(2);
            sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-1.0");
            try {
                paxInput = paxGnu.getInputStream(entry);
                try {
                    Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)paxInput), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
                }
                finally {
                    if (paxInput != null) {
                        paxInput.close();
                    }
                }
            }
            finally {
                if (sparseFileInputStream != null) {
                    sparseFileInputStream.close();
                }
            }
        }
    }

    @Test
    @EnabledOnOs(value={OS.WINDOWS})
    public void testTarFileExtractSparseTarsOnWindows() throws IOException {
        File oldGNUSparseTar = SparseFilesTest.getFile("oldgnu_sparse.tar");
        File paxGNUSparseTar = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarFile paxGnu = new TarFile(paxGNUSparseTar);){
            InputStream pax;
            InputStream old;
            TarArchiveEntry oldGnuEntry;
            List entries = paxGnu.getEntries();
            TarArchiveEntry paxGnuEntry = (TarArchiveEntry)entries.get(0);
            try (TarFile oldGnu = new TarFile(oldGNUSparseTar);){
                oldGnuEntry = (TarArchiveEntry)oldGnu.getEntries().get(0);
                old = oldGnu.getInputStream(oldGnuEntry);
                try {
                    pax = paxGnu.getInputStream(paxGnuEntry);
                    try {
                        Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)old), (byte[])IOUtils.toByteArray((InputStream)pax));
                    }
                    finally {
                        if (pax != null) {
                            pax.close();
                        }
                    }
                }
                finally {
                    if (old != null) {
                        old.close();
                    }
                }
            }
            paxGnuEntry = (TarArchiveEntry)entries.get(1);
            oldGnu = new TarFile(oldGNUSparseTar);
            try {
                oldGnuEntry = (TarArchiveEntry)oldGnu.getEntries().get(0);
                old = oldGnu.getInputStream(oldGnuEntry);
                try {
                    pax = paxGnu.getInputStream(paxGnuEntry);
                    try {
                        Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)old), (byte[])IOUtils.toByteArray((InputStream)pax));
                    }
                    finally {
                        if (pax != null) {
                            pax.close();
                        }
                    }
                }
                finally {
                    if (old != null) {
                        old.close();
                    }
                }
            }
            finally {
                oldGnu.close();
            }
            paxGnuEntry = (TarArchiveEntry)entries.get(2);
            oldGnu = new TarFile(oldGNUSparseTar);
            try {
                oldGnuEntry = (TarArchiveEntry)oldGnu.getEntries().get(0);
                old = oldGnu.getInputStream(oldGnuEntry);
                try {
                    pax = paxGnu.getInputStream(paxGnuEntry);
                    try {
                        Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)old), (byte[])IOUtils.toByteArray((InputStream)pax));
                    }
                    finally {
                        if (pax != null) {
                            pax.close();
                        }
                    }
                }
                finally {
                    if (old != null) {
                        old.close();
                    }
                }
            }
            finally {
                oldGnu.close();
            }
        }
    }

    @Test
    public void testTarFileOldGNU() throws Throwable {
        File file = SparseFilesTest.getFile("oldgnu_sparse.tar");
        try (TarFile tarFile = new TarFile(file);){
            TarArchiveEntry ae = (TarArchiveEntry)tarFile.getEntries().get(0);
            Assertions.assertEquals((Object)"sparsefile", (Object)ae.getName());
            Assertions.assertEquals((byte)83, (byte)ae.getLinkFlag());
            Assertions.assertTrue((boolean)ae.isOldGNUSparse());
            Assertions.assertTrue((boolean)ae.isGNUSparse());
            Assertions.assertFalse((boolean)ae.isPaxGNUSparse());
            List sparseHeaders = ae.getSparseHeaders();
            Assertions.assertEquals((int)4, (int)sparseHeaders.size());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
            Assertions.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
            Assertions.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
            Assertions.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
            Assertions.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getOffset());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getNumbytes());
            List sparseOrderedHeaders = ae.getOrderedSparseHeaders();
            Assertions.assertEquals((int)3, (int)sparseOrderedHeaders.size());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(0)).getOffset());
            Assertions.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(0)).getNumbytes());
            Assertions.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(1)).getOffset());
            Assertions.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(1)).getNumbytes());
            Assertions.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(2)).getOffset());
            Assertions.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(2)).getNumbytes());
        }
    }

    @Test
    public void testTarFilePaxGNU() throws IOException {
        File file = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarFile tarFile = new TarFile(file);){
            List entries = tarFile.getEntries();
            this.assertPaxGNUEntry((TarArchiveEntry)entries.get(0), "0.0");
            this.assertPaxGNUEntry((TarArchiveEntry)entries.get(1), "0.1");
            this.assertPaxGNUEntry((TarArchiveEntry)entries.get(2), "1.0");
        }
    }
}

