/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.examples.Expander;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class ExpanderTest
extends AbstractTest {
    private File archive;

    private void assertHelloWorld(String fileName, String suffix) throws IOException {
        Assertions.assertTrue((boolean)new File(this.tempResultDir, fileName).isFile(), (String)(fileName + " does not exist"));
        byte[] expected = ("Hello, world " + suffix).getBytes(StandardCharsets.UTF_8);
        try (InputStream is = Files.newInputStream(new File(this.tempResultDir, fileName).toPath(), new OpenOption[0]);){
            byte[] actual = IOUtils.toByteArray((InputStream)is);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    private void setup7z() throws IOException {
        this.archive = this.newTempFile("test.7z");
        File dummy = this.newTempFile("x");
        try (OutputStream o = Files.newOutputStream(dummy.toPath(), new OpenOption[0]);){
            o.write(new byte[14]);
        }
        try (SevenZOutputFile aos = new SevenZOutputFile(this.archive);){
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "a"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "a/b"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "a/b/c"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/d.txt"));
            aos.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/c/e.txt"));
            aos.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.finish();
        }
    }

    private void setupTar() throws IOException, ArchiveException {
        this.archive = this.newTempFile("test.tar");
        File dummy = this.newTempFile("x");
        try (OutputStream o = Files.newOutputStream(dummy.toPath(), new OpenOption[0]);){
            o.write(new byte[14]);
        }
        try (ArchiveOutputStream aos = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", Files.newOutputStream(this.archive.toPath(), new OpenOption[0]));){
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "a"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "a/b"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "a/b/c"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/d.txt"));
            aos.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/c/e.txt"));
            aos.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.finish();
        }
    }

    private void setupTarForCompress603() throws IOException, ArchiveException {
        this.archive = this.newTempFile("test.tar");
        File dummy = this.newTempFile("x");
        try (OutputStream o = Files.newOutputStream(dummy.toPath(), new OpenOption[0]);){
            o.write(new byte[14]);
        }
        try (ArchiveOutputStream aos = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", Files.newOutputStream(this.archive.toPath(), new OpenOption[0]));){
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "./"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "./a"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "./a/b"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "./a/b/c"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "./a/b/d.txt"));
            aos.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "./a/b/c/e.txt"));
            aos.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.finish();
        }
    }

    private void setupZip() throws IOException, ArchiveException {
        this.archive = this.newTempFile("test.zip");
        File dummy = this.newTempFile("x");
        try (OutputStream o = Files.newOutputStream(dummy.toPath(), new OpenOption[0]);){
            o.write(new byte[14]);
        }
        try (ArchiveOutputStream aos = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("zip", Files.newOutputStream(this.archive.toPath(), new OpenOption[0]));){
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "a"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "a/b"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "a/b/c"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/d.txt"));
            aos.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/c/e.txt"));
            aos.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.finish();
        }
    }

    private void setupZip(String entry) throws IOException, ArchiveException {
        this.archive = this.newTempFile("test.zip");
        File dummy = this.newTempFile("x");
        try (OutputStream o = Files.newOutputStream(dummy.toPath(), new OpenOption[0]);){
            o.write(new byte[14]);
        }
        try (ArchiveOutputStream aos = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("zip", Files.newOutputStream(this.archive.toPath(), new OpenOption[0]));){
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, entry));
            aos.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.finish();
        }
    }

    @Test
    public void testCompress603Tar() throws IOException, ArchiveException {
        this.setupTarForCompress603();
        try (TarFile f = new TarFile(this.archive);){
            new Expander().expand(f, this.tempResultDir);
        }
        this.verifyTargetDir();
    }

    @Test
    public void testFileCantEscapeDoubleDotPath() throws IOException, ArchiveException {
        this.setupZip("../foo");
        try (ZipFile f = new ZipFile(this.archive);){
            Assertions.assertThrows(IOException.class, () -> new Expander().expand(f, this.tempResultDir));
        }
    }

    @Test
    public void testFileCantEscapeDoubleDotPathWithSimilarSibling() throws IOException, ArchiveException {
        String sibling = this.tempResultDir.getName() + "x";
        File s = new File(this.tempResultDir.getParentFile(), sibling);
        Assumptions.assumeFalse((boolean)s.exists());
        s.mkdirs();
        Assumptions.assumeTrue((boolean)s.exists());
        this.setupZip("../" + sibling + "/a");
        try (ZipFile f = new ZipFile(this.archive);){
            Assertions.assertThrows(IOException.class, () -> new Expander().expand(f, this.tempResultDir));
        }
    }

    @Test
    public void testFileCantEscapeViaAbsolutePath() throws IOException, ArchiveException {
        this.setupZip("/tmp/foo");
        try (ZipFile f = new ZipFile(this.archive);){
            Assertions.assertThrows(IOException.class, () -> new Expander().expand(f, this.tempResultDir));
        }
        Assertions.assertFalse((boolean)new File(this.tempResultDir, "tmp/foo").isFile());
    }

    @Test
    public void testSevenZChannelVersion() throws IOException, ArchiveException {
        this.setup7z();
        try (FileChannel c = FileChannel.open(this.archive.toPath(), StandardOpenOption.READ);){
            new Expander().expand("7z", (SeekableByteChannel)c, this.tempResultDir);
        }
        this.verifyTargetDir();
    }

    @Test
    public void testSevenZFileVersion() throws IOException {
        this.setup7z();
        try (SevenZFile f = new SevenZFile(this.archive);){
            new Expander().expand(f, this.tempResultDir);
        }
        this.verifyTargetDir();
    }

    @Test
    public void testSevenZInputStreamVersion() throws IOException {
        this.setup7z();
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(this.archive.toPath(), new OpenOption[0]));){
            Assertions.assertThrows(StreamingNotSupportedException.class, () -> new Expander().expand("7z", i, this.tempResultDir));
        }
    }

    @Test
    public void testSevenZInputStreamVersionWithAutoDetection() throws IOException {
        this.setup7z();
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(this.archive.toPath(), new OpenOption[0]));){
            Assertions.assertThrows(StreamingNotSupportedException.class, () -> new Expander().expand(i, this.tempResultDir));
        }
    }

    @Test
    public void testSevenZTwoFileVersion() throws IOException, ArchiveException {
        this.setup7z();
        new Expander().expand("7z", this.archive, this.tempResultDir);
        this.verifyTargetDir();
    }

    @Test
    public void testSevenZTwoFileVersionWithAutoDetection() throws IOException, ArchiveException {
        this.setup7z();
        new Expander().expand(this.archive, this.tempResultDir);
        this.verifyTargetDir();
    }

    @Test
    public void testTarFileVersion() throws IOException, ArchiveException {
        this.setupTar();
        try (TarFile f = new TarFile(this.archive);){
            new Expander().expand(f, this.tempResultDir);
        }
        this.verifyTargetDir();
    }

    @Test
    public void testZipFileVersion() throws IOException, ArchiveException {
        this.setupZip();
        try (ZipFile f = new ZipFile(this.archive);){
            new Expander().expand(f, this.tempResultDir);
        }
        this.verifyTargetDir();
    }

    private void verifyTargetDir() throws IOException {
        Assertions.assertTrue((boolean)new File(this.tempResultDir, "a").isDirectory(), (String)"a has not been created");
        Assertions.assertTrue((boolean)new File(this.tempResultDir, "a/b").isDirectory(), (String)"a/b has not been created");
        Assertions.assertTrue((boolean)new File(this.tempResultDir, "a/b/c").isDirectory(), (String)"a/b/c has not been created");
        this.assertHelloWorld("a/b/d.txt", "1");
        this.assertHelloWorld("a/b/c/e.txt", "2");
    }
}

