/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CpioArchiveTest {
    public static Stream<Arguments> factory() {
        return Stream.of(Arguments.of((Object[])new Object[]{(short)1}), Arguments.of((Object[])new Object[]{(short)2}), Arguments.of((Object[])new Object[]{(short)4}), Arguments.of((Object[])new Object[]{(short)8}));
    }

    @ParameterizedTest
    @MethodSource(value={"factory"})
    public void utf18RoundtripTest(short format) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (CpioArchiveOutputStream os = new CpioArchiveOutputStream((OutputStream)baos, format, 512, "UTF-16LE");){
                CpioArchiveEntry entry = new CpioArchiveEntry(format, "T\u00e4st.txt", 4L);
                if (format == 2) {
                    entry.setChksum(10L);
                }
                os.putArchiveEntry(entry);
                os.write(new byte[]{1, 2, 3, 4});
                os.closeArchiveEntry();
            }
            baos.close();
            try (ByteArrayInputStream bin = new ByteArrayInputStream(baos.toByteArray());
                 CpioArchiveInputStream in = new CpioArchiveInputStream((InputStream)bin, "UTF-16LE");){
                CpioArchiveEntry entry = in.getNextEntry();
                Assertions.assertNotNull((Object)entry);
                Assertions.assertEquals((Object)"T\u00e4st.txt", (Object)entry.getName());
                Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])IOUtils.toByteArray((InputStream)in));
            }
        }
    }
}

