/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArArchiveInputStreamTest
extends AbstractTest {
    private void checkLongNameEntry(String archive) throws Exception {
        try (InputStream fis = ArArchiveInputStreamTest.newInputStream(archive);
             ArArchiveInputStream s = new ArArchiveInputStream((InputStream)new BufferedInputStream(fis));){
            ArArchiveEntry e = s.getNextEntry();
            Assertions.assertEquals((Object)"this_is_a_long_file_name.txt", (Object)e.getName());
            Assertions.assertEquals((long)14L, (long)e.getSize());
            byte[] hello = new byte[14];
            s.read(hello);
            Assertions.assertEquals((Object)"Hello, world!\n", (Object)ArchiveUtils.toAsciiString((byte[])hello));
            e = s.getNextEntry();
            Assertions.assertEquals((Object)"this_is_a_long_file_name_as_well.txt", (Object)e.getName());
            Assertions.assertEquals((long)4L, (long)e.getSize());
            byte[] bye = new byte[4];
            s.read(bye);
            Assertions.assertEquals((Object)"Bye\n", (Object)ArchiveUtils.toAsciiString((byte[])bye));
            Assertions.assertNull((Object)s.getNextEntry());
        }
    }

    @Test
    public void testCantReadAfterClose() throws Exception {
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("bla.ar");
             ArArchiveInputStream archive = new ArArchiveInputStream(in);){
            archive.close();
            Assertions.assertThrows(IllegalStateException.class, () -> archive.read());
        }
    }

    @Test
    public void testCantReadWithoutOpeningAnEntry() throws Exception {
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("bla.ar");
             ArArchiveInputStream archive = new ArArchiveInputStream(in);){
            Assertions.assertThrows(IllegalStateException.class, () -> archive.read());
        }
    }

    @Test
    public void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("bla.ar");
             ArArchiveInputStream archive = new ArArchiveInputStream(in);){
            ArArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
        }
    }

    @Test
    public void testReadLongNamesBSD() throws Exception {
        this.checkLongNameEntry("longfile_bsd.ar");
    }

    @Test
    public void testReadLongNamesGNU() throws Exception {
        this.checkLongNameEntry("longfile_gnu.ar");
    }

    @Test
    public void testSimpleInputStream() throws IOException {
        try (final InputStream fileInputStream = ArArchiveInputStreamTest.newInputStream("bla.ar");){
            InputStream simpleInputStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return fileInputStream.read();
                }
            };
            try (ArArchiveInputStream archiveInputStream = new ArArchiveInputStream(simpleInputStream);){
                ArArchiveEntry entry1 = archiveInputStream.getNextArEntry();
                MatcherAssert.assertThat((Object)entry1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)entry1.getName(), (Matcher)CoreMatchers.equalTo((Object)"test1.xml"));
                MatcherAssert.assertThat((Object)entry1.getLength(), (Matcher)CoreMatchers.equalTo((Object)610L));
                ArArchiveEntry entry2 = archiveInputStream.getNextArEntry();
                MatcherAssert.assertThat((Object)entry2.getName(), (Matcher)CoreMatchers.equalTo((Object)"test2.xml"));
                MatcherAssert.assertThat((Object)entry2.getLength(), (Matcher)CoreMatchers.equalTo((Object)82L));
                MatcherAssert.assertThat((Object)archiveInputStream.getNextArEntry(), (Matcher)CoreMatchers.nullValue());
            }
        }
    }

    @Test
    public void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("bla.ar");
             ArArchiveInputStream archive = new ArArchiveInputStream(in);){
            ArArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read());
            Assertions.assertEquals((int)-1, (int)archive.read());
        }
    }
}

