/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryPredicate;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipSplitReadOnlySeekableByteChannel;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class ZipTest
extends AbstractTest {
    final String first_payload = "ABBA";
    final String second_payload = "AAAAAAAAAAAA";
    final ZipArchiveEntryPredicate allFilesPredicate = zipArchiveEntry -> true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFilesToZip(ZipArchiveOutputStream zipArchiveOutputStream, File fileToAdd) throws IOException {
        if (fileToAdd.isDirectory()) {
            for (File file : fileToAdd.listFiles()) {
                this.addFilesToZip(zipArchiveOutputStream, file);
            }
        } else {
            ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(fileToAdd.getPath());
            zipArchiveEntry.setMethod(8);
            zipArchiveOutputStream.putArchiveEntry(zipArchiveEntry);
            try {
                Files.copy(fileToAdd.toPath(), (OutputStream)zipArchiveOutputStream);
            }
            finally {
                zipArchiveOutputStream.closeArchiveEntry();
            }
        }
    }

    private void assertSameFileContents(File expectedFile, File actualFile) throws IOException {
        int size = (int)Math.max(expectedFile.length(), actualFile.length());
        try (ZipFile expected = new ZipFile(expectedFile);
             ZipFile actual = new ZipFile(actualFile);){
            byte[] expectedBuf = new byte[size];
            byte[] actualBuf = new byte[size];
            Enumeration actualInOrder = actual.getEntriesInPhysicalOrder();
            Enumeration expectedInOrder = expected.getEntriesInPhysicalOrder();
            while (actualInOrder.hasMoreElements()) {
                ZipArchiveEntry actualElement = (ZipArchiveEntry)actualInOrder.nextElement();
                ZipArchiveEntry expectedElement = (ZipArchiveEntry)expectedInOrder.nextElement();
                Assertions.assertEquals((Object)expectedElement.getName(), (Object)actualElement.getName());
                Assertions.assertEquals((int)expectedElement.getMethod(), (int)actualElement.getMethod());
                Assertions.assertEquals((Object)expectedElement.getGeneralPurposeBit(), (Object)actualElement.getGeneralPurposeBit());
                Assertions.assertEquals((long)expectedElement.getCrc(), (long)actualElement.getCrc());
                Assertions.assertEquals((long)expectedElement.getCompressedSize(), (long)actualElement.getCompressedSize());
                Assertions.assertEquals((long)expectedElement.getSize(), (long)actualElement.getSize());
                Assertions.assertEquals((long)expectedElement.getExternalAttributes(), (long)actualElement.getExternalAttributes());
                Assertions.assertEquals((int)expectedElement.getInternalAttributes(), (int)actualElement.getInternalAttributes());
                try (InputStream actualIs = actual.getInputStream(actualElement);
                     InputStream expectedIs = expected.getInputStream(expectedElement);){
                    IOUtils.readFully((InputStream)expectedIs, (byte[])expectedBuf);
                    IOUtils.readFully((InputStream)actualIs, (byte[])actualBuf);
                }
                Assertions.assertArrayEquals((byte[])expectedBuf, (byte[])actualBuf);
            }
        }
    }

    private int countNonDirectories(File file) {
        if (!file.isDirectory()) {
            return 1;
        }
        int result = 0;
        for (File fileInDirectory : file.listFiles()) {
            result += this.countNonDirectories(fileInDirectory);
        }
        return result;
    }

    private void createArchiveEntry(String payload, ZipArchiveOutputStream zos, String name) throws IOException {
        ZipArchiveEntry in = new ZipArchiveEntry(name);
        zos.putArchiveEntry(in);
        zos.write(payload.getBytes());
        zos.closeArchiveEntry();
    }

    private ZipArchiveOutputStream createFirstEntry(ZipArchiveOutputStream zos) throws IOException {
        this.createArchiveEntry("ABBA", zos, "file1.txt");
        return zos;
    }

    private File createReferenceFile(Zip64Mode zipMode, String prefix) throws IOException {
        File reference = this.createTempFile(prefix, ".zip");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(reference);){
            zos.setUseZip64(zipMode);
            this.createFirstEntry(zos);
            this.createSecondEntry(zos);
        }
        return reference;
    }

    private ZipArchiveOutputStream createSecondEntry(ZipArchiveOutputStream zos) throws IOException {
        this.createArchiveEntry("AAAAAAAAAAAA", zos, "file2.txt");
        return zos;
    }

    private void createTestSplitZipSegments() throws IOException {
        File directoryToZip = this.getFilesToZip();
        File outputZipFile = this.newTempFile("splitZip.zip");
        long splitSize = 102400L;
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(outputZipFile, 102400L);){
            this.addFilesToZip(zipArchiveOutputStream, directoryToZip);
        }
    }

    private File getFilesToZip() throws IOException {
        File originalZipFile = ZipTest.getFile("COMPRESS-477/split_zip_created_by_zip/zip_to_compare_created_by_zip.zip");
        try (ZipFile zipFile = new ZipFile(originalZipFile);){
            Enumeration zipEntries = zipFile.getEntries();
            while (zipEntries.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)zipEntries.nextElement();
                if (zipEntry.isDirectory()) continue;
                File outputFile = this.newTempFile(zipEntry.getName());
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                outputFile = this.newTempFile(zipEntry.getName());
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    OutputStream outputStream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);
                    try {
                        int readLen;
                        byte[] buffer = new byte[(int)zipEntry.getSize()];
                        while ((readLen = inputStream.read(buffer)) > 0) {
                            outputStream.write(buffer, 0, readLen);
                        }
                    }
                    finally {
                        if (outputStream == null) continue;
                        outputStream.close();
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        return this.getTempDirFile().listFiles()[0];
    }

    private void readStream(InputStream in, ArchiveEntry entry, Map<String, List<List<Long>>> map) throws IOException {
        byte[] buf = new byte[4096];
        InputStreamStatistics stats = (InputStreamStatistics)in;
        while (in.read(buf) != -1) {
        }
        String name = entry.getName();
        List list = map.computeIfAbsent(name, k -> new ArrayList());
        long t = stats.getUncompressedCount();
        long b = stats.getCompressedCount();
        list.add(Arrays.asList(t, b));
    }

    @Test
    public void testBuildSplitZipTest() throws IOException {
        File directoryToZip = this.getFilesToZip();
        this.createTestSplitZipSegments();
        File lastFile = this.newTempFile("splitZip.zip");
        try (SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
             InputStream inputStream = Channels.newInputStream(channel);
             ZipArchiveInputStream splitInputStream = new ZipArchiveInputStream(inputStream, StandardCharsets.UTF_8.toString(), true, false, true);){
            ZipArchiveEntry entry;
            int filesNum = this.countNonDirectories(directoryToZip);
            int filesCount = 0;
            while ((entry = splitInputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File fileToCompare = new File(entry.getName());
                try (InputStream inputStreamToCompare = Files.newInputStream(fileToCompare.toPath(), new OpenOption[0]);){
                    Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)splitInputStream), (byte[])IOUtils.toByteArray((InputStream)inputStreamToCompare));
                }
                ++filesCount;
            }
            Assertions.assertEquals((int)filesCount, (int)filesNum);
        }
    }

    @Test
    public void testBuildSplitZipWithSegmentAlreadyExistThrowsException() throws IOException {
        File directoryToZip = this.getFilesToZip();
        File outputZipFile = this.newTempFile("splitZip.zip");
        long splitSize = 102400L;
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(outputZipFile, 102400L);){
            File sameNameFile = this.newTempFile("splitZip.z01");
            sameNameFile.createNewFile();
            Assertions.assertThrows(IOException.class, () -> this.addFilesToZip(zipArchiveOutputStream, directoryToZip));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testBuildSplitZipWithTooLargeSizeThrowsException() throws IOException {
        Path file = Files.createTempFile("temp", "zip", new FileAttribute[0]);
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ZipArchiveOutputStream(file, 0x100000000L));
        }
        finally {
            Files.delete(file);
        }
    }

    @Test
    public void testBuildSplitZipWithTooSmallSizeThrowsException() throws IOException {
        this.createTempFile("temp", "zip").toPath();
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ZipArchiveOutputStream(this.createTempFile("temp", "zip"), 65535L));
    }

    @Test
    public void testCopyRawEntriesFromFile() throws IOException {
        File reference = this.createReferenceFile(Zip64Mode.Never, "expected.");
        File file1 = this.createTempFile("src1.", ".zip");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(file1);){
            zos.setUseZip64(Zip64Mode.Never);
            this.createFirstEntry(zos).close();
        }
        File file2 = this.createTempFile("src2.", ".zip");
        try (ZipArchiveOutputStream zos1 = new ZipArchiveOutputStream(file2);){
            zos1.setUseZip64(Zip64Mode.Never);
            this.createSecondEntry(zos1).close();
        }
        try (ZipFile zipFile1 = new ZipFile(file1);
             ZipFile zipFile2 = new ZipFile(file2);){
            File fileResult = this.createTempFile("file-actual.", ".zip");
            try (ZipArchiveOutputStream zos2 = new ZipArchiveOutputStream(fileResult);){
                zipFile1.copyRawEntries(zos2, this.allFilesPredicate);
                zipFile2.copyRawEntries(zos2, this.allFilesPredicate);
            }
            this.assertSameFileContents(reference, fileResult);
        }
    }

    @Test
    public void testCopyRawZip64EntryFromFile() throws IOException {
        File reference = this.createTempFile("z64reference.", ".zip");
        try (ZipArchiveOutputStream zos1 = new ZipArchiveOutputStream(reference);){
            zos1.setUseZip64(Zip64Mode.Always);
            this.createFirstEntry(zos1);
        }
        File file1 = this.createTempFile("zip64src.", ".zip");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(file1);){
            zos.setUseZip64(Zip64Mode.Always);
            this.createFirstEntry(zos).close();
        }
        File fileResult = this.createTempFile("file-actual.", ".zip");
        try (ZipFile zipFile1 = new ZipFile(file1);){
            try (ZipArchiveOutputStream zos2 = new ZipArchiveOutputStream(fileResult);){
                zos2.setUseZip64(Zip64Mode.Always);
                zipFile1.copyRawEntries(zos2, this.allFilesPredicate);
            }
            this.assertSameFileContents(reference, fileResult);
        }
    }

    @Test
    public void testDirectoryEntryFromFile() throws Exception {
        long beforeArchiveWrite;
        File tmp = this.getTempDirFile();
        File archive = this.createTempFile("test.", ".zip");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(archive);){
            beforeArchiveWrite = tmp.lastModified();
            ZipArchiveEntry in = new ZipArchiveEntry(tmp, "foo");
            zos.putArchiveEntry(in);
            zos.closeArchiveEntry();
        }
        try (ZipFile zf = new ZipFile(archive);){
            ZipArchiveEntry out = zf.getEntry("foo/");
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo/", (Object)out.getName());
            Assertions.assertEquals((long)0L, (long)out.getSize());
            Assertions.assertEquals((long)(beforeArchiveWrite / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            Assertions.assertTrue((boolean)out.isDirectory());
        }
    }

    @Test
    public void testExplicitDirectoryEntry() throws Exception {
        long beforeArchiveWrite;
        File archive = this.createTempFile("test.", ".zip");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(archive);){
            beforeArchiveWrite = this.getTempDirFile().lastModified();
            ZipArchiveEntry in = new ZipArchiveEntry("foo/");
            in.setTime(beforeArchiveWrite);
            zos.putArchiveEntry(in);
            zos.closeArchiveEntry();
        }
        try (ZipFile zf = new ZipFile(archive);){
            ZipArchiveEntry out = zf.getEntry("foo/");
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo/", (Object)out.getName());
            Assertions.assertEquals((long)0L, (long)out.getSize());
            Assertions.assertEquals((long)(beforeArchiveWrite / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            Assertions.assertTrue((boolean)out.isDirectory());
        }
    }

    @Test
    public void testExplicitFileEntry() throws Exception {
        File tmp = this.createTempFile();
        File archive = this.createTempFile("test.", ".zip");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(archive);){
            ZipArchiveEntry in = new ZipArchiveEntry("foo");
            in.setTime(tmp.lastModified());
            in.setSize(tmp.length());
            zos.putArchiveEntry(in);
            byte[] b = new byte[(int)tmp.length()];
            try (InputStream fis = Files.newInputStream(tmp.toPath(), new OpenOption[0]);){
                while (fis.read(b) > 0) {
                    zos.write(b);
                }
            }
            zos.closeArchiveEntry();
        }
        try (ZipFile zf = new ZipFile(archive);){
            ZipArchiveEntry out = zf.getEntry("foo");
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo", (Object)out.getName());
            Assertions.assertEquals((long)tmp.length(), (long)out.getSize());
            Assertions.assertEquals((long)(tmp.lastModified() / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            Assertions.assertFalse((boolean)out.isDirectory());
        }
    }

    @Test
    public void testFileEntryFromFile() throws Exception {
        File tmpFile = this.createTempFile();
        File archive = this.createTempFile("test.", ".zip");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(archive);){
            ZipArchiveEntry in = new ZipArchiveEntry(tmpFile, "foo");
            zos.putArchiveEntry(in);
            byte[] b = new byte[(int)tmpFile.length()];
            try (InputStream fis = Files.newInputStream(tmpFile.toPath(), new OpenOption[0]);){
                while (fis.read(b) > 0) {
                    zos.write(b);
                }
            }
            zos.closeArchiveEntry();
        }
        try (ZipFile zf = new ZipFile(archive);){
            ZipArchiveEntry out = zf.getEntry("foo");
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo", (Object)out.getName());
            Assertions.assertEquals((long)tmpFile.length(), (long)out.getSize());
            Assertions.assertEquals((long)(tmpFile.lastModified() / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            Assertions.assertFalse((boolean)out.isDirectory());
        }
    }

    private void testInputStreamStatistics(String fileName, Map<String, List<Long>> expectedStatistics) throws IOException, ArchiveException {
        File input = ZipTest.getFile(fileName);
        HashMap<String, List<List<Long>>> actualStatistics = new HashMap<String, List<List<Long>>>();
        try (InputStream fis = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("zip", fis);){
            ArchiveEntry entry;
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                this.readStream((InputStream)archiveInputStream, entry, actualStatistics);
            }
        }
        try (ZipFile zf = new ZipFile(input);){
            Enumeration enumeration = zf.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipArchiveEntry zae = (ZipArchiveEntry)enumeration.nextElement();
                InputStream in = zf.getInputStream(zae);
                try {
                    this.readStream(in, (ArchiveEntry)zae, actualStatistics);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        for (Map.Entry entry : actualStatistics.entrySet()) {
            Assertions.assertEquals(((List)entry.getValue()).get(0), ((List)entry.getValue()).get(1), (String)("Mismatch of stats for: " + (String)entry.getKey()));
        }
        for (Map.Entry<Object, Object> entry : expectedStatistics.entrySet()) {
            Assertions.assertEquals((Object)entry.getValue(), ((List)actualStatistics.get(entry.getKey())).get(0), (String)("Mismatch of stats with expected value for: " + (String)entry.getKey()));
        }
    }

    @Test
    public void testInputStreamStatisticsForBzip2Entry() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>();
        expected.put("lots-of-as", Arrays.asList(42L, 39L));
        this.testInputStreamStatistics("bzip2-zip.zip", expected);
    }

    @Test
    public void testInputStreamStatisticsForDeflate64Entry() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>();
        expected.put("input2", Arrays.asList(3072L, 2111L));
        this.testInputStreamStatistics("COMPRESS-380/COMPRESS-380.zip", expected);
    }

    @Test
    public void testInputStreamStatisticsForImplodedEntry() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>();
        expected.put("LICENSE.TXT", Arrays.asList(11560L, 4131L));
        this.testInputStreamStatistics("imploding-8Kdict-3trees.zip", expected);
    }

    @Test
    public void testInputStreamStatisticsForShrunkEntry() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>();
        expected.put("TEST1.XML", Arrays.asList(76L, 66L));
        expected.put("TEST2.XML", Arrays.asList(81L, 76L));
        this.testInputStreamStatistics("SHRUNK.ZIP", expected);
    }

    @Test
    public void testInputStreamStatisticsForStoredEntry() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>();
        expected.put("test.txt", Arrays.asList(5L, 5L));
        this.testInputStreamStatistics("COMPRESS-264.zip", expected);
    }

    @Test
    public void testInputStreamStatisticsOfZipBombExcel() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>();
        expected.put("[Content_Types].xml", Arrays.asList(8390036L, 8600L));
        expected.put("xl/worksheets/sheet1.xml", Arrays.asList(1348L, 508L));
        this.testInputStreamStatistics("zipbomb.xlsx", expected);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testListAllFilesWithNestedArchive() throws Exception {
        File input = ZipTest.getFile("OSX_ArchiveWithNestedArchive.zip");
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<ZipException> expectedExceptions = new ArrayList<ZipException>();
        try (InputStream fis = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZipArchiveInputStream in = (ZipArchiveInputStream)ArchiveStreamFactory.DEFAULT.createArchiveInputStream("zip", fis);){
            ZipArchiveEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                results.add(entry.getName());
                ZipArchiveInputStream nestedIn = (ZipArchiveInputStream)ArchiveStreamFactory.DEFAULT.createArchiveInputStream("zip", (InputStream)in);
                try {
                    ZipArchiveEntry nestedEntry;
                    while ((nestedEntry = nestedIn.getNextEntry()) != null) {
                        results.add(nestedEntry.getName());
                    }
                }
                catch (ZipException ex) {
                    expectedExceptions.add(ex);
                }
            }
        }
        Assertions.assertTrue((boolean)results.contains("NestedArchiv.zip"));
        Assertions.assertTrue((boolean)results.contains("test1.xml"));
        Assertions.assertTrue((boolean)results.contains("test2.xml"));
        Assertions.assertTrue((boolean)results.contains("test3.xml"));
        Assertions.assertEquals((int)1, (int)expectedExceptions.size());
    }

    @Test
    public void testSkipEntryWithUnsupportedCompressionMethod() throws IOException {
        try (ZipArchiveInputStream zip = new ZipArchiveInputStream(ZipTest.newInputStream("moby.zip"));){
            ZipArchiveEntry entry = zip.getNextZipEntry();
            Assertions.assertEquals((int)ZipMethod.TOKENIZATION.getCode(), (int)entry.getMethod(), (String)"method");
            Assertions.assertEquals((Object)"README", (Object)entry.getName());
            Assertions.assertFalse((boolean)zip.canReadEntryData((ArchiveEntry)entry));
            Assertions.assertDoesNotThrow(() -> Assertions.assertNull((Object)zip.getNextZipEntry()), (String)"COMPRESS-93: Unable to skip an unsupported ZIP entry");
        }
    }

    @Test
    public void testSkipsPK00Prefix() throws Exception {
        File input = ZipTest.getFile("COMPRESS-208.zip");
        ArrayList<String> al = new ArrayList<String>();
        al.add("test1.xml");
        al.add("test2.xml");
        try (InputStream fis = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZipArchiveInputStream inputStream = new ZipArchiveInputStream(fis);){
            this.checkArchiveContent((ArchiveInputStream<?>)inputStream, (List<String>)al);
        }
    }

    @Test
    public void testTokenizationCompressionMethod() throws IOException {
        try (ZipFile moby = new ZipFile(ZipTest.getFile("moby.zip"));){
            ZipArchiveEntry entry = moby.getEntry("README");
            Assertions.assertEquals((int)ZipMethod.TOKENIZATION.getCode(), (int)entry.getMethod(), (String)"method");
            Assertions.assertFalse((boolean)moby.canReadEntryData(entry));
        }
    }

    @Test
    public void testUnixModeInAddRaw() throws IOException {
        File file1 = this.createTempFile("unixModeBits.", ".zip");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(file1);){
            ZipArchiveEntry archiveEntry = new ZipArchiveEntry("fred");
            archiveEntry.setUnixMode(436);
            archiveEntry.setMethod(0);
            archiveEntry.setSize(3L);
            archiveEntry.setCompressedSize(3L);
            zos.addRawArchiveEntry(archiveEntry, (InputStream)new ByteArrayInputStream("fud".getBytes()));
        }
        try (ZipFile zf1 = new ZipFile(file1);){
            ZipArchiveEntry fred = zf1.getEntry("fred");
            Assertions.assertEquals((int)436, (int)fred.getUnixMode());
        }
    }

    @Test
    public void testZipArchiveCreation() throws Exception {
        File output = this.newTempFile("bla.zip");
        File file1 = ZipTest.getFile("test1.xml");
        File file2 = ZipTest.getFile("test2.xml");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("zip", out);){
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test1.xml"));
            Files.copy(file1.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test2.xml"));
            Files.copy(file2.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
        }
        ArrayList<File> results = new ArrayList<File>();
        try (InputStream fileInputStream = Files.newInputStream(output.toPath(), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("zip", fileInputStream);){
            ZipArchiveEntry entry;
            while ((entry = (ZipArchiveEntry)archiveInputStream.getNextEntry()) != null) {
                File outfile = new File(this.tempResultDir.getCanonicalPath() + "/result/" + entry.getName());
                outfile.getParentFile().mkdirs();
                Files.copy((InputStream)archiveInputStream, outfile.toPath(), new CopyOption[0]);
                results.add(outfile);
            }
        }
        Assertions.assertEquals((int)results.size(), (int)2);
        File result = (File)results.get(0);
        Assertions.assertEquals((long)file1.length(), (long)result.length());
        result = (File)results.get(1);
        Assertions.assertEquals((long)file2.length(), (long)result.length());
    }

    @Test
    public void testZipArchiveCreationInMemory() throws Exception {
        File file1 = ZipTest.getFile("test1.xml");
        File file2 = ZipTest.getFile("test2.xml");
        byte[] file1Contents = new byte[(int)file1.length()];
        byte[] file2Contents = new byte[(int)file2.length()];
        IOUtils.read((File)file1, (byte[])file1Contents);
        IOUtils.read((File)file2, (byte[])file2Contents);
        ArrayList<byte[]> results = new ArrayList<byte[]>();
        try (SeekableInMemoryByteChannel channel = new SeekableInMemoryByteChannel();){
            try (ZipArchiveOutputStream os = new ZipArchiveOutputStream((SeekableByteChannel)channel);){
                os.putArchiveEntry(new ZipArchiveEntry("testdata/test1.xml"));
                os.write(file1Contents);
                os.closeArchiveEntry();
                os.putArchiveEntry(new ZipArchiveEntry("testdata/test2.xml"));
                os.write(file2Contents);
                os.closeArchiveEntry();
            }
            try (ZipArchiveInputStream inputStream = (ZipArchiveInputStream)ArchiveStreamFactory.DEFAULT.createArchiveInputStream("zip", (InputStream)new ByteArrayInputStream(channel.array()));){
                ZipArchiveEntry entry;
                while ((entry = inputStream.getNextEntry()) != null) {
                    byte[] result = new byte[(int)entry.getSize()];
                    IOUtils.readFully((InputStream)inputStream, (byte[])result);
                    results.add(result);
                }
            }
        }
        Assertions.assertArrayEquals((byte[])((byte[])results.get(0)), (byte[])file1Contents);
        Assertions.assertArrayEquals((byte[])((byte[])results.get(1)), (byte[])file2Contents);
    }

    @Test
    public void testZipArchiveEntryNewFromPath() throws Exception {
        File tmpFile = this.createTempFile();
        Path tmpFilePath = tmpFile.toPath();
        File archiveFile = this.createTempFile("test.", ".zip");
        Path archivePath = archiveFile.toPath();
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(archivePath, new OpenOption[0]);){
            ZipArchiveEntry in = zos.createArchiveEntry(tmpFilePath, "foo", new LinkOption[0]);
            zos.putArchiveEntry(in);
            byte[] b = new byte[(int)tmpFile.length()];
            try (InputStream fis = Files.newInputStream(tmpFile.toPath(), new OpenOption[0]);){
                while (fis.read(b) > 0) {
                    zos.write(b);
                }
            }
            zos.closeArchiveEntry();
        }
        try (ZipFile zf = new ZipFile(archiveFile);){
            ZipArchiveEntry out = zf.getEntry("foo");
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo", (Object)out.getName());
            Assertions.assertEquals((long)tmpFile.length(), (long)out.getSize());
            Assertions.assertEquals((long)(tmpFile.lastModified() / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            Assertions.assertFalse((boolean)out.isDirectory());
        }
    }

    @Test
    public void testZipUnarchive() throws Exception {
        File input = ZipTest.getFile("bla.zip");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("zip", is);){
            ZipArchiveEntry entry = (ZipArchiveEntry)in.getNextEntry();
            Files.copy((InputStream)in, this.newTempFile(entry.getName()).toPath(), new CopyOption[0]);
        }
    }
}

