/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class DetectArchiverTest
extends AbstractTest {
    final ClassLoader classLoader = this.getClass().getClassLoader();

    private void checkEmptyArchive(String type) throws Exception {
        Path ar = this.createEmptyArchive(type);
        Assertions.assertDoesNotThrow(() -> {
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(ar, new OpenOption[0]));){
                ArchiveInputStream ais = this.factory.createArchiveInputStream((InputStream)inputStream);
                if (ais != null) {
                    ais.close();
                }
            }
        }, (String)("Should have recognized empty archive for " + type));
    }

    private <T extends ArchiveInputStream<? extends E>, E extends ArchiveEntry> T createArchiveInputStream(String resource) throws ArchiveException, IOException {
        return (T)this.factory.createArchiveInputStream((InputStream)new BufferedInputStream(DetectArchiverTest.newInputStream(resource)));
    }

    @Test
    public void testCOMPRESS_117() throws Exception {
        try (Object tar = this.createArchiveInputStream("COMPRESS-117.tar");){
            Assertions.assertNotNull(tar);
            Assertions.assertTrue((boolean)(tar instanceof TarArchiveInputStream));
        }
    }

    @Test
    public void testCOMPRESS_335() throws Exception {
        try (Object tar = this.createArchiveInputStream("COMPRESS-335.tar");){
            Assertions.assertNotNull(tar);
            Assertions.assertTrue((boolean)(tar instanceof TarArchiveInputStream));
        }
    }

    @Test
    public void testDetection() throws Exception {
        try (Object ar = this.createArchiveInputStream("bla.ar");){
            Assertions.assertNotNull(ar);
            Assertions.assertTrue((boolean)(ar instanceof ArArchiveInputStream));
        }
        try (Object tar = this.createArchiveInputStream("bla.tar");){
            Assertions.assertNotNull(tar);
            Assertions.assertTrue((boolean)(tar instanceof TarArchiveInputStream));
        }
        try (Object zip = this.createArchiveInputStream("bla.zip");){
            Assertions.assertNotNull(zip);
            Assertions.assertTrue((boolean)(zip instanceof ZipArchiveInputStream));
        }
        try (Object jar = this.createArchiveInputStream("bla.jar");){
            Assertions.assertNotNull(jar);
            Assertions.assertTrue((boolean)(jar instanceof ZipArchiveInputStream));
        }
        try (Object cpio = this.createArchiveInputStream("bla.cpio");){
            Assertions.assertNotNull(cpio);
            Assertions.assertTrue((boolean)(cpio instanceof CpioArchiveInputStream));
        }
        try (Object arj = this.createArchiveInputStream("bla.arj");){
            Assertions.assertNotNull(arj);
            Assertions.assertTrue((boolean)(arj instanceof ArjArchiveInputStream));
        }
    }

    @Test
    public void testDetectionNotArchive() {
        Assertions.assertThrows(ArchiveException.class, () -> this.createArchiveInputStream("test.txt"));
    }

    @Test
    public void testEmptyCpioArchive() throws Exception {
        this.checkEmptyArchive("cpio");
    }

    @Test
    public void testEmptyJarArchive() throws Exception {
        this.checkEmptyArchive("jar");
    }

    @Test
    public void testEmptyZipArchive() throws Exception {
        this.checkEmptyArchive("zip");
    }
}

