/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.BufferedReader;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ArchiveReadTest
extends AbstractTest {
    private static final ClassLoader CLASSLOADER = ArchiveReadTest.class.getClassLoader();
    private static final File ARCDIR;
    private static final ArrayList<String> FILELIST;

    public static Stream<Arguments> data() {
        Assertions.assertTrue((boolean)ARCDIR.exists());
        ArrayList<Arguments> params = new ArrayList<Arguments>();
        for (String fileName : ARCDIR.list((dir, name) -> !name.endsWith(".txt"))) {
            params.add(Arguments.of((Object[])new Object[]{new File(ARCDIR, fileName)}));
        }
        return params.stream();
    }

    @BeforeAll
    public static void setUpFileList() throws Exception {
        Assertions.assertTrue((boolean)ARCDIR.exists());
        File listing = new File(ARCDIR, "files.txt");
        Assertions.assertTrue((boolean)listing.canRead(), (String)"files.txt is readable");
        try (BufferedReader br = new BufferedReader(Files.newBufferedReader(listing.toPath()));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                FILELIST.add(line);
            }
        }
    }

    @Override
    protected String getExpectedString(ArchiveEntry entry) {
        return entry.getSize() + " " + entry.getName();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testArchive(File file) throws Exception {
        ArrayList expected = (ArrayList)FILELIST.clone();
        Assertions.assertDoesNotThrow(() -> this.checkArchiveContent(file, (List<String>)expected), (String)("Problem checking " + file));
    }

    static {
        FILELIST = new ArrayList();
        try {
            ARCDIR = new File(CLASSLOADER.getResource("archives").toURI());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }
}

