/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.io.TempDir;

public class AbstractTempDirTest {
    @TempDir
    private File tempDirFile;

    public File createTempFile() throws IOException {
        return File.createTempFile("testfile", "", this.getTempDirFile());
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, this.getTempDirFile());
    }

    public Path createTempPath(String prefix, String suffix) throws IOException {
        return Files.createTempFile(this.getTempDirPath(), prefix, suffix, new FileAttribute[0]);
    }

    public File getTempDirFile() {
        return this.tempDirFile;
    }

    public Path getTempDirPath() {
        return this.tempDirFile.toPath();
    }

    protected File newTempFile(String child) {
        return new File(this.getTempDirFile(), child);
    }
}

