/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.io.IOException;
import java.util.List;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.unpack200.AttributeLayout;
import org.apache.commons.compress.harmony.unpack200.NewAttributeBands;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.compress.harmony.unpack200.tests.AbstractBandsTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class NewAttributeBandsTest
extends AbstractBandsTestCase {
    @Test
    public void testEmptyLayout() throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 0, "", 25));
        List<?> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)0, (int)layoutElements.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"B", "FB", "SB", "H", "FH", "SH", "I", "FI", "SI", "PB", "OB", "OSB", "POB", "PH", "OH", "OSH", "POH", "PI", "OI", "OSI", "POI"})
    public void testIntegralLayout(String layoutStr) throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 0, layoutStr, 25));
        List<?> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Integral element = (NewAttributeBands.Integral)layoutElements.get(0);
        Assertions.assertEquals((Object)layoutStr, (Object)element.getTag());
    }

    @Test
    public void testLayoutWithBackwardsCall() throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 2, "[NH[(1)]][KIH][(-1)]", 20));
        List<?> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)3, (int)layoutElements.size());
        NewAttributeBands.Callable firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        NewAttributeBands.Callable secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        NewAttributeBands.Callable thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        List thirdBody = thirdCallable.getBody();
        Assertions.assertEquals((int)1, (int)thirdBody.size());
        NewAttributeBands.Call call = (NewAttributeBands.Call)thirdBody.get(0);
        Assertions.assertEquals((Object)secondCallable, (Object)call.getCallable());
        Assertions.assertTrue((boolean)secondCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)firstCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)thirdCallable.isBackwardsCallable());
        newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 2, "[NH[(1)]][KIH][(-2)]", 20));
        layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)3, (int)layoutElements.size());
        firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        thirdBody = thirdCallable.getBody();
        Assertions.assertEquals((int)1, (int)thirdBody.size());
        call = (NewAttributeBands.Call)thirdBody.get(0);
        Assertions.assertEquals((Object)firstCallable, (Object)call.getCallable());
        Assertions.assertTrue((boolean)firstCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)secondCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)thirdCallable.isBackwardsCallable());
        newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 2, "[NH[(1)]][KIH][(0)]", 20));
        layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)3, (int)layoutElements.size());
        firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        thirdBody = thirdCallable.getBody();
        Assertions.assertEquals((int)1, (int)thirdBody.size());
        call = (NewAttributeBands.Call)thirdBody.get(0);
        Assertions.assertEquals((Object)thirdCallable, (Object)call.getCallable());
        Assertions.assertTrue((boolean)thirdCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)firstCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)secondCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)firstCallable.isBackwardsCallable());
    }

    @Test
    public void testLayoutWithCalls() throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 1, "[NH[(1)]][RSH NH[RUH(1)]][TB(66,67,73,83,90)[KIH](68)[KDH](70)[KFH](74)[KJH](99)[RSH](101)[RSH RUH](115)[RUH](91)[NH[(0)]](64)[RSH[RUH(0)]]()[]]", 26));
        List<?> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)3, (int)layoutElements.size());
        NewAttributeBands.Callable firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        NewAttributeBands.Callable secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        NewAttributeBands.Callable thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        List firstBody = firstCallable.getBody();
        Assertions.assertEquals((int)1, (int)firstBody.size());
        NewAttributeBands.Replication rep = (NewAttributeBands.Replication)firstBody.get(0);
        List repBody = rep.getLayoutElements();
        Assertions.assertEquals((int)1, (int)repBody.size());
        NewAttributeBands.Call call = (NewAttributeBands.Call)repBody.get(0);
        Assertions.assertEquals((int)1, (int)call.getCallableIndex());
        Assertions.assertEquals((Object)secondCallable, (Object)call.getCallable());
        Assertions.assertFalse((boolean)firstCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)secondCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)thirdCallable.isBackwardsCallable());
    }

    @ParameterizedTest
    @ValueSource(strings={"KIB", "KIH", "KII", "KINH", "KJH", "KDH", "KSH", "KQH", "RCH", "RSH", "RDH", "RFH", "RMH", "RIH", "RUH", "RQH", "RQNH", "RQNI"})
    public void testReferenceLayouts(String layout) throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 3, layout, 26));
        List<?> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Reference element = (NewAttributeBands.Reference)layoutElements.get(0);
        Assertions.assertEquals((Object)layout, (Object)element.getTag());
    }

    @Test
    public void testReplicationLayout() throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 0, "NH[PHOHRUHRSHH]", 25));
        List<?> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Replication element = (NewAttributeBands.Replication)layoutElements.get(0);
        NewAttributeBands.Integral countElement = element.getCountElement();
        Assertions.assertEquals((Object)"H", (Object)countElement.getTag());
        List replicatedElements = element.getLayoutElements();
        Assertions.assertEquals((int)5, (int)replicatedElements.size());
        NewAttributeBands.Integral firstElement = (NewAttributeBands.Integral)replicatedElements.get(0);
        Assertions.assertEquals((Object)"PH", (Object)firstElement.getTag());
        NewAttributeBands.Integral secondElement = (NewAttributeBands.Integral)replicatedElements.get(1);
        Assertions.assertEquals((Object)"OH", (Object)secondElement.getTag());
        NewAttributeBands.Reference thirdElement = (NewAttributeBands.Reference)replicatedElements.get(2);
        Assertions.assertEquals((Object)"RUH", (Object)thirdElement.getTag());
        NewAttributeBands.Reference fourthElement = (NewAttributeBands.Reference)replicatedElements.get(3);
        Assertions.assertEquals((Object)"RSH", (Object)fourthElement.getTag());
        NewAttributeBands.Integral fifthElement = (NewAttributeBands.Integral)replicatedElements.get(4);
        Assertions.assertEquals((Object)"H", (Object)fifthElement.getTag());
    }

    @Test
    public void testUnionLayout() throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 3, "TB(55)[FH](23)[]()[RSH]", 26));
        List<?> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Union element = (NewAttributeBands.Union)layoutElements.get(0);
        NewAttributeBands.Integral tag = element.getUnionTag();
        Assertions.assertEquals((Object)"B", (Object)tag.getTag());
        List unionCases = element.getUnionCases();
        Assertions.assertEquals((int)2, (int)unionCases.size());
        NewAttributeBands.UnionCase firstCase = (NewAttributeBands.UnionCase)unionCases.get(0);
        Assertions.assertTrue((boolean)firstCase.hasTag(55));
        Assertions.assertFalse((boolean)firstCase.hasTag(23));
        List body = firstCase.getBody();
        Assertions.assertEquals((int)1, (int)body.size());
        NewAttributeBands.Integral bodyElement = (NewAttributeBands.Integral)body.get(0);
        Assertions.assertEquals((Object)"FH", (Object)bodyElement.getTag());
        NewAttributeBands.UnionCase secondCase = (NewAttributeBands.UnionCase)unionCases.get(1);
        Assertions.assertTrue((boolean)secondCase.hasTag(23));
        Assertions.assertFalse((boolean)secondCase.hasTag(55));
        body = secondCase.getBody();
        Assertions.assertEquals((int)0, (int)body.size());
        List defaultBody = element.getDefaultCaseBody();
        Assertions.assertEquals((int)1, (int)defaultBody.size());
        NewAttributeBands.Reference ref = (NewAttributeBands.Reference)defaultBody.get(0);
        Assertions.assertEquals((Object)"RSH", (Object)ref.getTag());
    }

    private class MockNewAttributeBands
    extends NewAttributeBands {
        public MockNewAttributeBands(Segment segment, AttributeLayout layout) throws IOException {
            super(segment, layout);
        }

        public List<?> getLayoutElements() {
            return this.attributeLayoutElements;
        }
    }
}

