/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.util.stream.Stream;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.unpack200.AttributeLayout;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.compress.harmony.unpack200.SegmentConstantPool;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class AttributeLayoutTest {
    static Stream<Arguments> badData() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, 0, ""}), Arguments.of((Object[])new Object[]{"", 0, ""}), Arguments.of((Object[])new Object[]{"name", -1, ""}), Arguments.of((Object[])new Object[]{"name", 1234, ""}));
    }

    static Stream<Arguments> codec() {
        return Stream.of(Arguments.of((Object[])new Object[]{"O", 0, "HOBS", Codec.BRANCH5}), Arguments.of((Object[])new Object[]{"P", 2, "PIN", Codec.BCI5}), Arguments.of((Object[])new Object[]{"S", 1, "HS", Codec.SIGNED5}), Arguments.of((Object[])new Object[]{"RS", 3, "RRRS", Codec.UNSIGNED5}), Arguments.of((Object[])new Object[]{"KS", 0, "RKS", Codec.UNSIGNED5}), Arguments.of((Object[])new Object[]{"B", 0, "TRKSB", Codec.BYTE1}));
    }

    static Stream<Arguments> okData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"name", 0, ""}), Arguments.of((Object[])new Object[]{"name", 2, ""}), Arguments.of((Object[])new Object[]{"name", 1, ""}), Arguments.of((Object[])new Object[]{"name", 3, ""}));
    }

    @ParameterizedTest
    @MethodSource(value={"badData"})
    public void testBadData(String name, int context, String layout) {
        Assertions.assertThrows(Pack200Exception.class, () -> new AttributeLayout(name, context, layout, -1));
    }

    @ParameterizedTest
    @MethodSource(value={"codec"})
    public void testGetCodec(String name, int context, String layout, Codec expectedCodec) throws Pack200Exception {
        AttributeLayout attributeLayout = new AttributeLayout(name, context, layout, 1);
        Assertions.assertEquals((Object)expectedCodec, (Object)attributeLayout.getCodec());
    }

    @Test
    public void testLayoutRS() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RS", 0, "RS", 1);
        TestSegment segment = new TestSegment();
        Assertions.assertNull((Object)layout.getValue(-1L, segment.getConstantPool()));
        Assertions.assertEquals((Object)"Eins", (Object)((CPUTF8)layout.getValue(0L, segment.getConstantPool())).underlyingString());
        Assertions.assertEquals((Object)"Zwei", (Object)((CPUTF8)layout.getValue(1L, segment.getConstantPool())).underlyingString());
    }

    @Test
    public void testLayoutRSN() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RSN", 0, "RSN", 1);
        TestSegment segment = new TestSegment();
        Assertions.assertNull((Object)layout.getValue(0L, segment.getConstantPool()));
        Assertions.assertEquals((Object)"Eins", (Object)((CPUTF8)layout.getValue(1L, segment.getConstantPool())).underlyingString());
        Assertions.assertEquals((Object)"Zwei", (Object)((CPUTF8)layout.getValue(2L, segment.getConstantPool())).underlyingString());
    }

    @Test
    public void testLayoutRU() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RU", 0, "RU", 1);
        TestSegment segment = new TestSegment();
        Assertions.assertNull((Object)layout.getValue(-1L, segment.getConstantPool()));
        Assertions.assertEquals((Object)"Zero", (Object)((CPUTF8)layout.getValue(0L, segment.getConstantPool())).underlyingString());
        Assertions.assertEquals((Object)"One", (Object)((CPUTF8)layout.getValue(1L, segment.getConstantPool())).underlyingString());
    }

    @Test
    public void testLayoutRUN() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RUN", 0, "RUN", 1);
        TestSegment segment = new TestSegment();
        Assertions.assertNull((Object)layout.getValue(0L, segment.getConstantPool()));
        Assertions.assertEquals((Object)"Zero", (Object)((CPUTF8)layout.getValue(1L, segment.getConstantPool())).underlyingString());
        Assertions.assertEquals((Object)"One", (Object)((CPUTF8)layout.getValue(2L, segment.getConstantPool())).underlyingString());
    }

    @ParameterizedTest
    @MethodSource(value={"okData"})
    public void testOkData(String name, int context, String layout) {
        Assertions.assertDoesNotThrow(() -> new AttributeLayout(name, context, layout, -1));
    }

    public class TestSegment
    extends Segment {
        private ClassFileEntry entry(String string) {
            return new CPUTF8(string);
        }

        public SegmentConstantPool getConstantPool() {
            final ClassFileEntry[][] data = new ClassFileEntry[][]{new ClassFileEntry[0], {this.entry("Zero"), this.entry("One"), this.entry("Two"), this.entry("Three"), this.entry("Four"), this.entry("Five"), this.entry("Six"), this.entry("Seven"), this.entry("Eight"), this.entry("Nine")}, new ClassFileEntry[0], new ClassFileEntry[0], new ClassFileEntry[0], new ClassFileEntry[0], new ClassFileEntry[0], new ClassFileEntry[0], {this.entry("Eins"), this.entry("Zwei"), this.entry("Drei"), this.entry("Vier"), this.entry("Funf"), this.entry("Sechs"), this.entry("Sieben"), this.entry("Acht"), this.entry("Neun")}};
            return new SegmentConstantPool(null){

                public ClassFileEntry getValue(int cp, long index) {
                    if (index == -1L) {
                        return null;
                    }
                    return data[cp][(int)index];
                }
            };
        }
    }
}

