/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.compress.harmony.pack200.Archive;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.pack200.PackingOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PackingOptionsTest {
    JarFile in;
    OutputStream out;
    File file;

    private void compareFiles(JarFile jarFile, JarFile jarFile2) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Assertions.assertNotNull((Object)entry);
            String name = entry.getName();
            JarEntry entry2 = jarFile2.getJarEntry(name);
            Assertions.assertNotNull((Object)entry2, (String)("Missing Entry: " + name));
            if (name.equals("META-INF/MANIFEST.MF")) continue;
            InputStream ours = jarFile.getInputStream(entry);
            InputStream expected = jarFile2.getInputStream(entry2);
            try (BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
                 BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));){
                String line1 = reader1.readLine();
                String line2 = reader2.readLine();
                int i = 1;
                while (line1 != null || line2 != null) {
                    Assertions.assertEquals((Object)line2, (Object)line1, (String)("Unpacked files differ for " + name + " at line " + i));
                    line1 = reader1.readLine();
                    line2 = reader2.readLine();
                    ++i;
                }
            }
        }
    }

    private void compareJarEntries(JarFile jarFile, JarFile jarFile2) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Assertions.assertNotNull((Object)entry);
            String name = entry.getName();
            JarEntry entry2 = jarFile2.getJarEntry(name);
            Assertions.assertNotNull((Object)entry2, (String)("Missing Entry: " + name));
        }
    }

    @Test
    public void testDeflateHint() {
        PackingOptions options = new PackingOptions();
        Assertions.assertEquals((Object)"keep", (Object)options.getDeflateHint());
        options.setDeflateHint("true");
        Assertions.assertEquals((Object)"true", (Object)options.getDeflateHint());
        options.setDeflateHint("false");
        Assertions.assertEquals((Object)"false", (Object)options.getDeflateHint());
        Assertions.assertThrows(IllegalArgumentException.class, () -> options.setDeflateHint("hello"), (String)"Should throw IllegalArgumentException for incorrect deflate hint");
    }

    @Test
    public void testE0() throws Pack200Exception, IOException, URISyntaxException {
        File f1 = new File(Archive.class.getResource("/pack200/jndi.jar").toURI());
        this.in = new JarFile(f1);
        this.file = File.createTempFile("jndiE0", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.setGzip(false);
        options.setEffort(0);
        Archive archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        try (JarFile jf1 = new JarFile(f1);
             JarFile jf2 = new JarFile(this.file);){
            this.compareFiles(jf1, jf2);
        }
    }

    @Test
    public void testErrorAttributes() throws Exception {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI()));
        this.file = File.createTempFile("unknown", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.addClassAttributeAction("Pack200", "error");
        Archive ar = new Archive(this.in, this.out, options);
        Error error = (Error)Assertions.assertThrows(Error.class, () -> {
            ar.pack();
            this.in.close();
            this.out.close();
        });
        Assertions.assertEquals((Object)"Attribute Pack200 was found", (Object)error.getMessage());
    }

    @Test
    public void testKeepFileOrder() throws Exception {
        PackingOptions options = new PackingOptions();
        Assertions.assertTrue((boolean)options.isKeepFileOrder());
        options.setKeepFileOrder(false);
        Assertions.assertFalse((boolean)options.isKeepFileOrder());
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setGzip(false);
        Archive archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("sql", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        JarFile jarFile = new JarFile(file2);
        JarFile jarFile2 = new JarFile(compareFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        Enumeration<JarEntry> entries2 = jarFile2.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Assertions.assertNotNull((Object)entry);
            JarEntry entry2 = entries2.nextElement();
            String name = entry.getName();
            String name2 = entry2.getName();
            Assertions.assertEquals((Object)name, (Object)name2);
        }
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setKeepFileOrder(false);
        options.setGzip(false);
        archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        in2 = new FileInputStream(this.file);
        file2 = File.createTempFile("sql", ".jar");
        file2.deleteOnExit();
        out2 = new JarOutputStream(new FileOutputStream(file2));
        u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        jarFile = new JarFile(file2);
        jarFile2 = new JarFile(compareFile);
        this.compareJarEntries(jarFile, jarFile2);
        entries = jarFile.entries();
        entries2 = jarFile2.entries();
        boolean inOrder = true;
        while (entries.hasMoreElements()) {
            String name2;
            JarEntry entry = entries.nextElement();
            Assertions.assertNotNull((Object)entry);
            JarEntry entry2 = entries2.nextElement();
            String name = entry.getName();
            if (name.equals(name2 = entry2.getName())) continue;
            inOrder = false;
            break;
        }
        Assertions.assertFalse((boolean)inOrder, (String)"Files are not expected to be in order");
    }

    @Test
    public void testLoggingOptions() throws Exception {
        PackingOptions options = new PackingOptions();
        Assertions.assertFalse((boolean)options.isVerbose());
        Assertions.assertNull((Object)options.getLogFile());
        options.setVerbose(true);
        Assertions.assertTrue((boolean)options.isVerbose());
        options.setQuiet(true);
        Assertions.assertFalse((boolean)options.isVerbose());
        File logFile = File.createTempFile("logfile", ".txt");
        logFile.deleteOnExit();
        options.setLogFile(logFile.getPath());
        Assertions.assertEquals((Object)logFile.getPath(), (Object)options.getLogFile());
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        this.file = File.createTempFile("helloworld", ".pack.gz");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        new Archive(this.in, this.out, options).pack();
        this.in.close();
        this.out.close();
        try (FileReader reader = new FileReader(logFile);){
            Assertions.assertFalse((boolean)reader.ready());
        }
        options.setVerbose(true);
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        this.file = File.createTempFile("helloworld", ".pack.gz");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        new Archive(this.in, this.out, options).pack();
        this.in.close();
        this.out.close();
        reader = new FileReader(logFile);
        try {
            Assertions.assertTrue((boolean)reader.ready());
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testModificationTime() throws Exception {
        PackingOptions options = new PackingOptions();
        Assertions.assertEquals((Object)"keep", (Object)options.getModificationTime());
        options.setModificationTime("latest");
        Assertions.assertEquals((Object)"latest", (Object)options.getModificationTime());
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            PackingOptions illegalOption = new PackingOptions();
            illegalOption.setModificationTime("true");
        }, (String)"Should throw IllegalArgumentException for incorrect mod time");
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setGzip(false);
        Archive archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("sql", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        JarFile jarFile = new JarFile(file2);
        JarFile jarFile2 = new JarFile(compareFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        Enumeration<JarEntry> entries2 = jarFile2.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Assertions.assertNotNull((Object)entry);
            JarEntry entry2 = entries2.nextElement();
            String name = entry.getName();
            String name2 = entry2.getName();
            Assertions.assertEquals((Object)name, (Object)name2);
            Assertions.assertEquals((long)entry.getTime(), (long)entry2.getTime());
        }
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setGzip(false);
        options.setModificationTime("latest");
        archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        in2 = new FileInputStream(this.file);
        file2 = File.createTempFile("sql", ".jar");
        file2.deleteOnExit();
        out2 = new JarOutputStream(new FileOutputStream(file2));
        u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        jarFile = new JarFile(file2);
        jarFile2 = new JarFile(compareFile);
        entries = jarFile.entries();
        entries2 = jarFile2.entries();
        long modtime = -1L;
        boolean sameAsOriginal = true;
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Assertions.assertNotNull((Object)entry);
            JarEntry entry2 = entries2.nextElement();
            String name = entry.getName();
            if (!name.startsWith("META-INF")) {
                if (modtime == -1L) {
                    modtime = entry.getTime();
                } else {
                    Assertions.assertEquals((long)modtime, (long)entry.getTime());
                }
            }
            if (entry2.getTime() == entry.getTime()) continue;
            sameAsOriginal = false;
        }
        Assertions.assertFalse((boolean)sameAsOriginal, (String)"Some modtimes should have changed");
    }

    @Test
    public void testNewAttributes() throws Exception {
        this.file = File.createTempFile("unknown", ".pack");
        try (FileOutputStream out = new FileOutputStream(this.file);
             JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI()));){
            this.file.deleteOnExit();
            PackingOptions options = new PackingOptions();
            options.addClassAttributeAction("Pack200", "I");
            Archive ar = new Archive(in, (OutputStream)out, options);
            ar.pack();
        }
        File file2 = File.createTempFile("unknown", ".jar");
        file2.deleteOnExit();
        try (FileInputStream in2 = new FileInputStream(this.file);
             JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));){
            org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
            u2archive.unpack();
            File compareFile = new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI());
            try (JarFile jarFile = new JarFile(file2);
                 JarFile jarFile2 = new JarFile(compareFile);){
                Assertions.assertEquals((int)jarFile2.size(), (int)jarFile.size());
                this.compareJarEntries(jarFile, jarFile2);
            }
        }
    }

    @Test
    public void testNewAttributes2() throws Exception {
        this.file = File.createTempFile("unknown", ".pack");
        this.file.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(this.file);
             JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/p200WithUnknownAttributes.jar").toURI()));){
            PackingOptions options = new PackingOptions();
            options.addFieldAttributeAction("Pack200", "I");
            options.addMethodAttributeAction("Pack200", "I");
            options.addCodeAttributeAction("Pack200", "I");
            Archive ar = new Archive(in, (OutputStream)out, options);
            ar.pack();
        }
        File file2 = File.createTempFile("unknown", ".jar");
        file2.deleteOnExit();
        try (FileInputStream in2 = new FileInputStream(this.file);
             JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));){
            org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
            u2archive.unpack();
        }
        File compareFile = new File(Archive.class.getResource("/pack200/p200WithUnknownAttributes.jar").toURI());
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(compareFile);){
            Assertions.assertEquals((int)jarFile2.size(), (int)jarFile.size());
            this.compareJarEntries(jarFile, jarFile2);
        }
    }

    @Test
    public void testPassAttributes() throws Exception {
        this.file = File.createTempFile("unknown", ".pack");
        this.file.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(this.file);
             JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI()));){
            PackingOptions options = new PackingOptions();
            options.addClassAttributeAction("Pack200", "pass");
            Archive ar = new Archive(in, (OutputStream)out, options);
            ar.pack();
        }
        File file2 = File.createTempFile("unknown", ".jar");
        file2.deleteOnExit();
        try (FileInputStream in2 = new FileInputStream(this.file);
             JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));){
            org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
            u2archive.unpack();
        }
        File compareFile = new File(Archive.class.getResource("/pack200/jndiWithUnknownAttributes.jar").toURI());
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(compareFile);){
            Assertions.assertEquals((int)jarFile2.size(), (int)jarFile.size());
            this.compareJarEntries(jarFile, jarFile2);
        }
    }

    @Test
    public void testPassFiles() throws IOException, URISyntaxException, Pack200Exception {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        File file0 = File.createTempFile("sql", ".pack");
        file0.deleteOnExit();
        this.out = new FileOutputStream(file0);
        PackingOptions options = new PackingOptions();
        options.setGzip(false);
        Archive archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        options = new PackingOptions();
        options.setGzip(false);
        options.addPassFile("bin/test/org/apache/harmony/sql/tests/java/sql/DatabaseMetaDataTest.class");
        Assertions.assertTrue((boolean)options.isPassFile("bin/test/org/apache/harmony/sql/tests/java/sql/DatabaseMetaDataTest.class"));
        archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        File file2 = File.createTempFile("sql", ".pack");
        file2.deleteOnExit();
        this.out = new FileOutputStream(file2);
        options = new PackingOptions();
        options.setGzip(false);
        options.addPassFile("bin/test/org/apache/harmony/sql/tests/java/sql");
        Assertions.assertTrue((boolean)options.isPassFile("bin/test/org/apache/harmony/sql/tests/java/sql/DatabaseMetaDataTest.class"));
        Assertions.assertFalse((boolean)options.isPassFile("bin/test/org/apache/harmony/sql/tests/java/sqldata/SqlData.class"));
        archive = new Archive(this.in, this.out, options);
        archive.pack();
        this.in.close();
        this.out.close();
        Assertions.assertTrue((this.file.length() > file0.length() ? 1 : 0) != 0, (String)"If files are passed then the pack file should be larger");
        Assertions.assertTrue((file2.length() > this.file.length() ? 1 : 0) != 0, (String)"If more files are passed then the pack file should be larger");
        File file3 = File.createTempFile("sql", ".jar");
        file3.deleteOnExit();
        FileInputStream in2 = new FileInputStream(this.file);
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file3));
        org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        u2archive.unpack();
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        try (JarFile jarFile = new JarFile(file3);
             JarFile jarFile2 = new JarFile(compareFile);){
            this.compareJarEntries(jarFile, jarFile2);
        }
        File file4 = File.createTempFile("sql", ".jar");
        file4.deleteOnExit();
        try (FileInputStream in3 = new FileInputStream(file2);
             JarOutputStream out3 = new JarOutputStream(new FileOutputStream(file4));){
            u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in3, out3);
            u2archive.unpack();
        }
        try (JarFile jarFile = new JarFile(file4);
             JarFile jarFile2 = new JarFile(compareFile);){
            this.compareJarEntries(jarFile, jarFile2);
        }
    }

    @Test
    public void testSegmentLimits() throws IOException, Pack200Exception, URISyntaxException {
        Archive archive;
        PackingOptions options;
        FileOutputStream out;
        this.file = File.createTempFile("helloworld", ".pack.gz");
        this.file.deleteOnExit();
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));){
            out = new FileOutputStream(this.file);
            try {
                options = new PackingOptions();
                options.setSegmentLimit(0L);
                archive = new Archive(in, (OutputStream)out, options);
                archive.pack();
            }
            finally {
                out.close();
            }
        }
        this.file = File.createTempFile("helloworld", ".pack.gz");
        this.file.deleteOnExit();
        in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        try {
            out = new FileOutputStream(this.file);
            try {
                options = new PackingOptions();
                options.setSegmentLimit(-1L);
                archive = new Archive(in, (OutputStream)out, options);
                archive.pack();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
        this.file = File.createTempFile("helloworld", ".pack.gz");
        this.file.deleteOnExit();
        in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        try {
            out = new FileOutputStream(this.file);
            try {
                options = new PackingOptions();
                options.setSegmentLimit(5000L);
                archive = new Archive(in, (OutputStream)out, options);
                archive.pack();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    @Test
    public void testStripDebug() throws IOException, Pack200Exception, URISyntaxException {
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        try (JarFile in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
             FileOutputStream out = new FileOutputStream(this.file);){
            PackingOptions options = new PackingOptions();
            options.setGzip(false);
            options.setStripDebug(true);
            Archive archive = new Archive(in, (OutputStream)out, options);
            archive.pack();
        }
        File file2 = File.createTempFile("sqloutNoDebug", ".jar");
        file2.deleteOnExit();
        try (FileInputStream in2 = new FileInputStream(this.file);
             JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));){
            org.apache.commons.compress.harmony.unpack200.Archive u2archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
            u2archive.unpack();
        }
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpackedNoDebug.jar").toURI());
        try (JarFile jarFile = new JarFile(file2);
             JarFile jarFile2 = new JarFile(compareFile);){
            Assertions.assertTrue((file2.length() < 250000L ? 1 : 0) != 0);
            this.compareFiles(jarFile, jarFile2);
        }
    }
}

