/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class BlockLZ4CompressorOutputStreamTest {
    @Test
    public void cantWriteBackReferenceFollowedByLiteralThatIsTooShort() {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        p.setBackReference(new LZ77Compressor.BackReference(10, 14));
        Assertions.assertFalse((boolean)p.canBeWritten(4));
    }

    @Test
    public void cantWriteBackReferenceIfAccumulatedOffsetIsTooShort() {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        p.setBackReference(new LZ77Compressor.BackReference(1, 4));
        Assertions.assertFalse((boolean)p.canBeWritten(5));
    }

    @Test
    public void canWriteBackReferenceFollowedByLongLiteral() {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        p.setBackReference(new LZ77Compressor.BackReference(1, 4));
        Assertions.assertTrue((boolean)p.canBeWritten(16));
    }

    @Test
    @Disabled(value="would pass if the algorithm used for rewriting the final pairs was smarter")
    public void canWriteBackReferenceFollowedByShortLiteralIfLengthIsBigEnough() {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        p.setBackReference(new LZ77Compressor.BackReference(1, 10));
        Assertions.assertTrue((boolean)p.canBeWritten(5));
    }

    @Test
    @Disabled(value="would pass if the algorithm used for rewriting the final pairs was smarter")
    public void canWriteBackReferenceFollowedByShortLiteralIfOffsetIsBigEnough() {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        p.setBackReference(new LZ77Compressor.BackReference(10, 4));
        Assertions.assertTrue((boolean)p.canBeWritten(5));
    }

    @Test
    public void canWritePairWithoutBackReference() throws IOException {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        byte[] b = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        p.addLiteral(new LZ77Compressor.LiteralBlock(b, 1, 4));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        p.writeTo((OutputStream)bos);
        Assertions.assertArrayEquals((byte[])new byte[]{64, 2, 3, 4, 5}, (byte[])bos.toByteArray());
    }

    @Test
    public void canWritePairWithoutLiterals() throws IOException {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        p.setBackReference(new LZ77Compressor.BackReference(1, 4));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        p.writeTo((OutputStream)bos);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 1, 0}, (byte[])bos.toByteArray());
    }

    private byte[] compress(byte[] input, int ... lengthOfTrailers) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (BlockLZ4CompressorOutputStream lo = new BlockLZ4CompressorOutputStream((OutputStream)baos);){
                lo.write(input);
                for (int i = 0; i < lengthOfTrailers.length; ++i) {
                    int lengthOfTrailer = lengthOfTrailers[i];
                    for (int j = 0; j < lengthOfTrailer; ++j) {
                        lo.write(i + 1);
                    }
                }
                lo.close();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    private byte[] compress(int length) throws IOException {
        return this.compress(length, 0);
    }

    private byte[] compress(int lengthBeforeTrailer, int ... lengthOfTrailers) throws IOException {
        byte[] b = this.prepareExpected(lengthBeforeTrailer);
        return this.compress(b, lengthOfTrailers);
    }

    @Test
    public void pairAccumulatesLengths() {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        p.setBackReference(new LZ77Compressor.BackReference(1, 4));
        byte[] b = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        p.addLiteral(new LZ77Compressor.LiteralBlock(b, 1, 4));
        p.addLiteral(new LZ77Compressor.LiteralBlock(b, 2, 5));
        Assertions.assertEquals((int)13, (int)p.length());
    }

    @Test
    public void pairSeesBackReferenceWhenSet() {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        Assertions.assertFalse((boolean)p.hasBackReference());
        p.setBackReference(new LZ77Compressor.BackReference(1, 4));
        Assertions.assertTrue((boolean)p.hasBackReference());
    }

    private byte[] prepareExpected(int length) {
        byte[] b = new byte[length];
        Arrays.fill(b, (byte)-1);
        return b;
    }

    @Test
    public void rewritingOfFinalBlockWithoutTrailingLZ77Literals() throws IOException {
        byte[] expected;
        byte[] compressed;
        int i;
        for (i = 1; i < 13; ++i) {
            compressed = this.compress(i);
            expected = this.prepareExpected(i + 1);
            expected[0] = (byte)(i << 4);
            Assertions.assertArrayEquals((byte[])expected, (byte[])compressed, (String)("input length is " + i));
        }
        for (i = 13; i < 17; ++i) {
            compressed = this.compress(i);
            expected = this.prepareExpected(i < 15 ? i + 1 : i + 2);
            if (i < 15) {
                expected[0] = (byte)(i << 4);
            } else {
                expected[0] = -16;
                expected[1] = (byte)(i - 15);
            }
            Assertions.assertArrayEquals((byte[])expected, (byte[])compressed, (String)("input length is " + i));
        }
        for (i = 17; i < 20; ++i) {
            compressed = this.compress(i);
            expected = this.prepareExpected(17);
            expected[0] = (byte)(0x10 | i - 17);
            expected[2] = 1;
            expected[3] = 0;
            expected[4] = -64;
            Assertions.assertArrayEquals((byte[])expected, (byte[])compressed, (String)("input length is " + i));
        }
    }

    @Test
    public void rewritingOfFinalBlockWithTrailingLZ77Literals() throws IOException {
        int j;
        byte[] expected;
        byte[] compressed;
        int i;
        for (i = 1; i < 5; ++i) {
            compressed = this.compress(16, i);
            expected = this.prepareExpected(17);
            expected[0] = (byte)(0x10 | i - 1);
            expected[2] = 1;
            expected[3] = 0;
            expected[4] = -64;
            for (j = 0; j < i; ++j) {
                expected[expected.length - 1 - j] = 1;
            }
            Assertions.assertArrayEquals((byte[])expected, (byte[])compressed, (String)("trailer length is " + i));
        }
        for (i = 5; i < 12; ++i) {
            compressed = this.compress(16, i);
            expected = this.prepareExpected(17);
            expected[0] = (byte)(0x10 | i - 1);
            expected[2] = 1;
            expected[3] = 0;
            expected[4] = -64;
            for (j = 0; j < i; ++j) {
                expected[expected.length - 1 - j] = 1;
            }
            Assertions.assertArrayEquals((byte[])expected, (byte[])compressed, (String)("trailer length is " + i));
        }
        for (i = 12; i < 15; ++i) {
            compressed = this.compress(16, i);
            expected = this.prepareExpected(i + 5);
            expected[0] = 27;
            expected[2] = 1;
            expected[3] = 0;
            expected[4] = (byte)(i << 4);
            for (j = 0; j < i; ++j) {
                expected[expected.length - 1 - j] = 1;
            }
            Assertions.assertArrayEquals((byte[])expected, (byte[])compressed, (String)("trailer length is " + i));
        }
    }

    @Test
    public void rewritingOfFourPairs() throws IOException {
        int i;
        byte[] compressed = this.compress(6, 5, 5, 1);
        byte[] expected = this.prepareExpected(17);
        expected[0] = 16;
        expected[2] = 1;
        expected[3] = 0;
        expected[4] = -64;
        for (i = 6; i < 11; ++i) {
            expected[i] = 1;
        }
        for (i = 11; i < 16; ++i) {
            expected[i] = 2;
        }
        expected[16] = 3;
        Assertions.assertArrayEquals((byte[])expected, (byte[])compressed);
    }

    @Test
    public void rewritingWithFinalBackreferenceAndOffsetBiggerThan1() throws IOException {
        byte[] toCompress = this.prepareExpected(25);
        for (int i = 0; i < toCompress.length; i += 4) {
            toCompress[i] = 1;
        }
        byte[] compressed = this.compress(toCompress, new int[0]);
        byte[] expected = this.prepareExpected(20);
        expected[0] = 69;
        expected[1] = 1;
        expected[5] = 4;
        expected[6] = 0;
        expected[7] = -64;
        for (int i = 11; i < expected.length; i += 4) {
            expected[i] = 1;
        }
        Assertions.assertArrayEquals((byte[])expected, (byte[])compressed);
    }

    @Test
    public void writesCompletePair() throws IOException {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        byte[] b = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        p.addLiteral(new LZ77Compressor.LiteralBlock(b, 1, 4));
        b[2] = 19;
        p.setBackReference(new LZ77Compressor.BackReference(1, 5));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        p.writeTo((OutputStream)bos);
        Assertions.assertArrayEquals((byte[])new byte[]{65, 2, 3, 4, 5, 1, 0}, (byte[])bos.toByteArray());
    }

    @Test
    public void writesCorrectSizeFor15ByteLengthLiteral() throws IOException {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        byte[] b = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        p.addLiteral(new LZ77Compressor.LiteralBlock(b, 0, 9));
        p.addLiteral(new LZ77Compressor.LiteralBlock(b, 0, 6));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        p.writeTo((OutputStream)bos);
        Assertions.assertArrayEquals((byte[])new byte[]{-16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6}, (byte[])bos.toByteArray());
    }

    @Test
    public void writesCorrectSizeFor19ByteLengthBackReference() throws IOException {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        p.setBackReference(new LZ77Compressor.BackReference(1, 19));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        p.writeTo((OutputStream)bos);
        Assertions.assertArrayEquals((byte[])new byte[]{15, 1, 0, 0}, (byte[])bos.toByteArray());
    }

    @Test
    public void writesCorrectSizeFor269ByteLengthLiteral() throws IOException {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        byte[] b = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        for (int i = 0; i < 26; ++i) {
            p.addLiteral(new LZ77Compressor.LiteralBlock(b, 0, 10));
        }
        p.addLiteral(new LZ77Compressor.LiteralBlock(b, 0, 9));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        p.writeTo((OutputStream)bos);
        Assertions.assertArrayEquals((byte[])new byte[]{-16, -2, 1}, (byte[])Arrays.copyOfRange(bos.toByteArray(), 0, 3));
    }

    @Test
    public void writesCorrectSizeFor270ByteLengthLiteral() throws IOException {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        byte[] b = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        for (int i = 0; i < 27; ++i) {
            p.addLiteral(new LZ77Compressor.LiteralBlock(b, 0, 10));
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        p.writeTo((OutputStream)bos);
        Assertions.assertArrayEquals((byte[])new byte[]{-16, -1, 0, 1}, (byte[])Arrays.copyOfRange(bos.toByteArray(), 0, 4));
    }

    @Test
    public void writesCorrectSizeFor273ByteLengthBackReference() throws IOException {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        p.setBackReference(new LZ77Compressor.BackReference(1, 273));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        p.writeTo((OutputStream)bos);
        Assertions.assertArrayEquals((byte[])new byte[]{15, 1, 0, -2}, (byte[])bos.toByteArray());
    }

    @Test
    public void writesCorrectSizeFor274ByteLengthBackReference() throws IOException {
        BlockLZ4CompressorOutputStream.Pair p = new BlockLZ4CompressorOutputStream.Pair();
        p.setBackReference(new LZ77Compressor.BackReference(1, 274));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        p.writeTo((OutputStream)bos);
        Assertions.assertArrayEquals((byte[])new byte[]{15, 1, 0, -1, 0}, (byte[])bos.toByteArray());
    }
}

