/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PythonTruncatedBzip2Test {
    private static final String TEXT = "root:x:0:0:root:/root:/bin/bash\nbin:x:1:1:bin:/bin:\ndaemon:x:2:2:daemon:/sbin:\nadm:x:3:4:adm:/var/adm:\nlp:x:4:7:lp:/var/spool/lpd:\nsync:x:5:0:sync:/sbin:/bin/sync\nshutdown:x:6:0:shutdown:/sbin:/sbin/shutdown\nhalt:x:7:0:halt:/sbin:/sbin/halt\nmail:x:8:12:mail:/var/spool/mail:\nnews:x:9:13:news:/var/spool/news:\nuucp:x:10:14:uucp:/var/spool/uucp:\noperator:x:11:0:operator:/root:\ngames:x:12:100:games:/usr/games:\ngopher:x:13:30:gopher:/usr/lib/gopher-data:\nftp:x:14:50:FTP User:/var/ftp:/bin/bash\nnobody:x:65534:65534:Nobody:/home:\npostfix:x:100:101:postfix:/var/spool/postfix:\nniemeyer:x:500:500::/home/niemeyer:/bin/bash\npostgres:x:101:102:PostgreSQL Server:/var/lib/pgsql:/bin/bash\nmysql:x:102:103:MySQL server:/var/lib/mysql:/bin/bash\nwww:x:103:104::/var/www:/bin/false\n";
    private static byte[] DATA;
    private static byte[] TRUNCATED_DATA;
    private ReadableByteChannel bz2Channel;

    private static byte[] copyOfRange(byte[] original, int from, int to) {
        int length = to - from;
        byte[] buff = new byte[length];
        System.arraycopy(original, from, buff, 0, length);
        return buff;
    }

    @BeforeAll
    public static void initializeTestData() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BZip2CompressorOutputStream bz2out = new BZip2CompressorOutputStream((OutputStream)out);){
            bz2out.write(TEXT.getBytes(), 0, TEXT.getBytes().length);
        }
        DATA = out.toByteArray();
        TRUNCATED_DATA = PythonTruncatedBzip2Test.copyOfRange(DATA, 0, DATA.length - 10);
    }

    private static ReadableByteChannel makeBZ2C(InputStream source) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(source);
        BZip2CompressorInputStream bZin = new BZip2CompressorInputStream((InputStream)bin, true);
        return Channels.newChannel((InputStream)bZin);
    }

    @AfterEach
    public void closeChannel() throws IOException {
        this.bz2Channel.close();
        this.bz2Channel = null;
    }

    @BeforeEach
    public void initializeChannel() throws IOException {
        ByteArrayInputStream source = new ByteArrayInputStream(TRUNCATED_DATA);
        this.bz2Channel = PythonTruncatedBzip2Test.makeBZ2C(source);
    }

    @Test
    public void testPartialReadTruncatedData() throws IOException {
        int length = TEXT.length();
        ByteBuffer buffer1 = ByteBuffer.allocate(length);
        this.bz2Channel.read(buffer1);
        Assertions.assertArrayEquals((byte[])PythonTruncatedBzip2Test.copyOfRange(TEXT.getBytes(), 0, length), (byte[])buffer1.array());
        ByteBuffer buffer2 = ByteBuffer.allocate(1);
        Assertions.assertThrows(IOException.class, () -> this.bz2Channel.read(buffer2), (String)"The read should have thrown.");
    }

    @Test
    public void testTruncatedData() {
        System.out.println("Attempt to read the whole thing in, should throw ...");
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        Assertions.assertThrows(IOException.class, () -> this.bz2Channel.read(buffer));
    }
}

