/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipSplitOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZipSplitOutputStreamTest
extends AbstractTestCase {
    @Test
    public void splitZipBeginsWithZipSplitSignature() throws IOException {
        File tempFile = File.createTempFile("temp", "zip");
        new ZipSplitOutputStream(tempFile, 102400L);
        InputStream inputStream = Files.newInputStream(tempFile.toPath(), new OpenOption[0]);
        byte[] buffer = new byte[4];
        inputStream.read(buffer);
        Assertions.assertEquals((int)ByteBuffer.wrap(ZipArchiveOutputStream.DD_SIG).getInt(), (int)ByteBuffer.wrap(buffer).getInt());
    }

    @Test
    public void testCreateSplittedFiles() throws IOException {
        File testOutputFile = new File(this.dir, "testCreateSplittedFiles.zip");
        int splitSize = 102400;
        ZipSplitOutputStream zipSplitOutputStream = new ZipSplitOutputStream(testOutputFile, 102400L);
        File fileToTest = ZipSplitOutputStreamTest.getFile("COMPRESS-477/split_zip_created_by_zip/zip_to_compare_created_by_zip.zip");
        try (InputStream inputStream = Files.newInputStream(fileToTest.toPath(), new OpenOption[0]);){
            int readLen;
            byte[] buffer = new byte[4096];
            while ((readLen = inputStream.read(buffer)) > 0) {
                zipSplitOutputStream.write(buffer, 0, readLen);
            }
        }
        zipSplitOutputStream.close();
        File zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z01");
        Assertions.assertEquals((long)zipFile.length(), (long)102400L);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z02");
        Assertions.assertEquals((long)zipFile.length(), (long)102400L);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z03");
        Assertions.assertEquals((long)zipFile.length(), (long)102400L);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z04");
        Assertions.assertEquals((long)zipFile.length(), (long)102400L);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z05");
        Assertions.assertEquals((long)zipFile.length(), (long)102400L);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.zip");
        Assertions.assertEquals((long)zipFile.length(), (long)(fileToTest.length() + 4L - 512000L));
    }

    @Test
    public void throwsExceptionIfSplitSizeIsTooLarge() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ZipSplitOutputStream(File.createTempFile("temp", "zip"), 0x100000000L));
    }

    @Test
    public void throwsExceptionIfSplitSizeIsTooSmall() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ZipSplitOutputStream(File.createTempFile("temp", "zip"), 65535L));
    }

    @Test
    public void throwsIfUnsplittableSizeLargerThanSplitSize() throws IOException {
        long splitSize = 102400L;
        ZipSplitOutputStream output = new ZipSplitOutputStream(File.createTempFile("temp", "zip"), 102400L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> output.prepareToWriteUnsplittableContent(102401L));
    }
}

