/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScatterZipOutputStreamTest {
    private File scatterFile = null;
    private File target = null;

    @AfterEach
    public void cleanup() {
        AbstractTestCase.tryHardToDelete(this.scatterFile);
        AbstractTestCase.tryHardToDelete(this.target);
    }

    private InputStreamSupplier createPayloadSupplier(ByteArrayInputStream payload) {
        return () -> payload;
    }

    @Test
    public void putArchiveEntry() throws Exception {
        this.scatterFile = File.createTempFile("scattertest", ".notzip");
        byte[] B_PAYLOAD = "RBBBBBBS".getBytes();
        byte[] A_PAYLOAD = "XAAY".getBytes();
        try (ScatterZipOutputStream scatterZipOutputStream = ScatterZipOutputStream.fileBased((File)this.scatterFile);){
            ZipArchiveEntry zab = new ZipArchiveEntry("b.txt");
            zab.setMethod(8);
            ByteArrayInputStream payload = new ByteArrayInputStream(B_PAYLOAD);
            scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zab, (InputStreamSupplier)this.createPayloadSupplier(payload)));
            ZipArchiveEntry zae = new ZipArchiveEntry("a.txt");
            zae.setMethod(8);
            ByteArrayInputStream payload1 = new ByteArrayInputStream(A_PAYLOAD);
            scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zae, (InputStreamSupplier)this.createPayloadSupplier(payload1)));
            this.target = File.createTempFile("scattertest", ".zip");
            try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(this.target);){
                scatterZipOutputStream.writeTo(outputStream);
            }
        }
        try (ZipFile zf = new ZipFile(this.target);){
            ZipArchiveEntry bEntry = (ZipArchiveEntry)zf.getEntries("b.txt").iterator().next();
            Assertions.assertEquals((long)8L, (long)bEntry.getSize());
            try (InputStream inputStream = zf.getInputStream(bEntry);){
                Assertions.assertArrayEquals((byte[])B_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
            }
            ZipArchiveEntry aEntry = (ZipArchiveEntry)zf.getEntries("a.txt").iterator().next();
            Assertions.assertEquals((long)4L, (long)aEntry.getSize());
            try (InputStream inputStream = zf.getInputStream(aEntry);){
                Assertions.assertArrayEquals((byte[])A_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
            }
        }
    }
}

