/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.jar;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.JarMarker;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JarArchiveOutputStreamTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJarMarker() throws IOException {
        Path testArchive = Files.createTempFile("jar-aostest", ".jar", new FileAttribute[0]);
        testArchive.toFile().deleteOnExit();
        try (JarArchiveOutputStream out = new JarArchiveOutputStream(Files.newOutputStream(testArchive, new OpenOption[0]));){
            ZipArchiveEntry ze1 = new ZipArchiveEntry("foo/");
            ze1.setTime(Instant.parse("2022-12-27T12:10:23Z").toEpochMilli());
            out.putArchiveEntry((ArchiveEntry)ze1);
            out.closeArchiveEntry();
            ZipArchiveEntry ze2 = new ZipArchiveEntry("bar/");
            ze2.setTime(Instant.parse("2022-12-28T02:56:01Z").toEpochMilli());
            out.putArchiveEntry((ArchiveEntry)ze2);
            out.closeArchiveEntry();
            out.finish();
        }
        try (ZipFile zf = new ZipFile(testArchive);){
            ZipArchiveEntry ze = zf.getEntry("foo/");
            Assertions.assertNotNull((Object)ze);
            ZipExtraField[] fes = ze.getExtraFields();
            Assertions.assertEquals((int)1, (int)fes.length);
            Assertions.assertTrue((boolean)(fes[0] instanceof JarMarker));
            ze = zf.getEntry("bar/");
            Assertions.assertNotNull((Object)ze);
            fes = ze.getExtraFields();
            Assertions.assertEquals((int)0, (int)fes.length);
        }
        finally {
            AbstractTestCase.tryHardToDelete(testArchive);
        }
    }
}

