/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.dump;

import org.apache.commons.compress.archivers.dump.DumpArchiveEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DumpArchiveEntryTest {
    @Test
    public void publicNameAddsTrailingSlashForDirectories() {
        DumpArchiveEntry ent = new DumpArchiveEntry("foo", "bar", -1, DumpArchiveEntry.TYPE.DIRECTORY);
        Assertions.assertEquals((Object)"bar", (Object)ent.getSimpleName());
        Assertions.assertEquals((Object)"foo", (Object)ent.getOriginalName());
        Assertions.assertEquals((Object)"foo/", (Object)ent.getName());
    }

    @Test
    public void publicNameRemovesLeadingDotSlash() {
        DumpArchiveEntry ent = new DumpArchiveEntry("./foo", "bar");
        Assertions.assertEquals((Object)"bar", (Object)ent.getSimpleName());
        Assertions.assertEquals((Object)"./foo", (Object)ent.getOriginalName());
        Assertions.assertEquals((Object)"foo", (Object)ent.getName());
    }
}

