/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CpioArchiveInputStreamTest
extends AbstractTestCase {
    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = CpioArchiveInputStreamTest.newInputStream("bla.cpio");
             CpioArchiveInputStream archive = new CpioArchiveInputStream(in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (InputStream in = CpioArchiveInputStreamTest.newInputStream("bla.cpio");
             CpioArchiveInputStream archive = new CpioArchiveInputStream(in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read());
            Assertions.assertEquals((int)-1, (int)archive.read());
        }
    }

    @Test
    public void testCpioUnarchive() throws Exception {
        StringBuilder expected = new StringBuilder();
        expected.append("./test1.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>./test2.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>\n");
        StringBuilder result = new StringBuilder();
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(CpioArchiveInputStreamTest.newInputStream("bla.cpio"));){
            CpioArchiveEntry entry;
            while ((entry = (CpioArchiveEntry)in.getNextEntry()) != null) {
                int tmp;
                result.append(entry.getName());
                while ((tmp = in.read()) != -1) {
                    result.append((char)tmp);
                }
            }
        }
        Assertions.assertEquals((Object)result.toString(), (Object)expected.toString());
    }

    @Test
    public void testCpioUnarchiveCreatedByRedlineRpm() throws Exception {
        int count = 0;
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(CpioArchiveInputStreamTest.newInputStream("redline.cpio"));){
            CpioArchiveEntry entry;
            while ((entry = (CpioArchiveEntry)in.getNextEntry()) != null) {
                ++count;
                Assertions.assertNotNull((Object)entry);
            }
        }
        Assertions.assertEquals((int)count, (int)1);
    }

    @Test
    public void testCpioUnarchiveMultibyteCharName() throws Exception {
        int count = 0;
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(CpioArchiveInputStreamTest.newInputStream("COMPRESS-459.cpio"), "UTF-8");){
            CpioArchiveEntry entry;
            while ((entry = (CpioArchiveEntry)in.getNextEntry()) != null) {
                ++count;
                Assertions.assertNotNull((Object)entry);
            }
        }
        Assertions.assertEquals((int)2, (int)count);
    }
}

