/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class DetectArchiverTestCase
extends AbstractTestCase {
    final ClassLoader classLoader = this.getClass().getClassLoader();

    private void checkEmptyArchive(String type) throws Exception {
        Path ar = this.createEmptyArchive(type);
        ar.toFile().deleteOnExit();
        Assertions.assertDoesNotThrow(() -> {
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(ar, new OpenOption[0]));){
                ArchiveInputStream ais = this.factory.createArchiveInputStream((InputStream)in);
                if (ais != null) {
                    ais.close();
                }
            }
        }, (String)("Should have recognized empty archive for " + type));
    }

    private ArchiveInputStream getStreamFor(String resource) throws ArchiveException, IOException {
        return this.factory.createArchiveInputStream((InputStream)new BufferedInputStream(DetectArchiverTestCase.newInputStream(resource)));
    }

    @Test
    public void testCOMPRESS_117() throws Exception {
        ArchiveInputStream tar = this.getStreamFor("COMPRESS-117.tar");
        Assertions.assertNotNull((Object)tar);
        Assertions.assertTrue((boolean)(tar instanceof TarArchiveInputStream));
    }

    @Test
    public void testCOMPRESS_335() throws Exception {
        try (ArchiveInputStream tar = this.getStreamFor("COMPRESS-335.tar");){
            Assertions.assertNotNull((Object)tar);
            Assertions.assertTrue((boolean)(tar instanceof TarArchiveInputStream));
        }
    }

    @Test
    public void testDetection() throws Exception {
        try (ArchiveInputStream ar = this.getStreamFor("bla.ar");){
            Assertions.assertNotNull((Object)ar);
            Assertions.assertTrue((boolean)(ar instanceof ArArchiveInputStream));
        }
        try (ArchiveInputStream tar = this.getStreamFor("bla.tar");){
            Assertions.assertNotNull((Object)tar);
            Assertions.assertTrue((boolean)(tar instanceof TarArchiveInputStream));
        }
        try (ArchiveInputStream zip = this.getStreamFor("bla.zip");){
            Assertions.assertNotNull((Object)zip);
            Assertions.assertTrue((boolean)(zip instanceof ZipArchiveInputStream));
        }
        try (ArchiveInputStream jar = this.getStreamFor("bla.jar");){
            Assertions.assertNotNull((Object)jar);
            Assertions.assertTrue((boolean)(jar instanceof ZipArchiveInputStream));
        }
        try (ArchiveInputStream cpio = this.getStreamFor("bla.cpio");){
            Assertions.assertNotNull((Object)cpio);
            Assertions.assertTrue((boolean)(cpio instanceof CpioArchiveInputStream));
        }
        try (ArchiveInputStream arj = this.getStreamFor("bla.arj");){
            Assertions.assertNotNull((Object)arj);
            Assertions.assertTrue((boolean)(arj instanceof ArjArchiveInputStream));
        }
    }

    @Test
    public void testDetectionNotArchive() {
        Assertions.assertThrows(ArchiveException.class, () -> this.getStreamFor("test.txt"));
    }

    @Test
    public void testEmptyCpioArchive() throws Exception {
        this.checkEmptyArchive("cpio");
    }

    @Test
    public void testEmptyJarArchive() throws Exception {
        this.checkEmptyArchive("jar");
    }

    @Test
    public void testEmptyZipArchive() throws Exception {
        this.checkEmptyArchive("zip");
    }
}

